/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;

public class DataMessage
extends UDPConnectionMessage {
    public static final int MAX_DATA = 512;

    public DataMessage(byte connectionID, long sequenceNumber, byte[] data, int datalength) {
        super(connectionID, (byte)3, sequenceNumber, data, datalength);
    }

    public DataMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, payload);
    }

    public Chunk getData1Chunk() {
        if (this._data1Length == 0) {
            return null;
        }
        Chunk chunk = new Chunk();
        chunk.data = this._data1;
        chunk.start = this._data1Offset;
        chunk.length = this._data1Length;
        return chunk;
    }

    public Chunk getData2Chunk() {
        if (this._data2Length == 0) {
            return null;
        }
        Chunk chunk = new Chunk();
        chunk.data = this._data2;
        chunk.start = this._data2Offset;
        chunk.length = this._data2Length;
        return chunk;
    }

    public byte getDataAt(int i) {
        if (i < 12) {
            return this._data1[i + 4];
        }
        return this._data2[i - 12];
    }

    public String toString() {
        return "DataMessage DestID:" + this.getConnectionID() + " len:" + this.getDataLength() + " seq:" + this.getSequenceNumber();
    }
}

