/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.DataRecord;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataWindow {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$DataWindow == null ? (class$com$limegroup$gnutella$udpconnect$DataWindow = DataWindow.class$("com.limegroup.gnutella.udpconnect.DataWindow")) : class$com$limegroup$gnutella$udpconnect$DataWindow));
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final int HIST_SIZE = 4;
    private static final float RTT_GAIN = 0.125f;
    private static final float DEVIATION_GAIN = 0.25f;
    private final HashMap window;
    private long windowStart;
    private int windowSize;
    private long averageRTT;
    private long averageLowRTT;
    private int lowRTTCount;
    private float srtt;
    private float rttvar;
    private float rto;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$DataWindow;

    public DataWindow(int size, long start) {
        this.windowStart = start;
        this.windowSize = size;
        this.window = new HashMap(size + 2);
    }

    public DataRecord addData(UDPConnectionMessage msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding message seq " + msg.getSequenceNumber() + " window start " + this.windowStart));
        }
        DataRecord d = new DataRecord(msg.getSequenceNumber(), msg);
        this.window.put(d.pkey, d);
        return d;
    }

    public DataRecord getBlock(long pnum) {
        return (DataRecord)this.window.get(new Long(pnum));
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getUsedSpots() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 3L; ++i) {
            Long pkey = new Long(i);
            DataRecord d = (DataRecord)this.window.get(pkey);
            if (d == null || d.written && i == this.windowStart) continue;
            ++count;
        }
        return count;
    }

    public int getWindowSpace() {
        return this.windowSize - this.getUsedSpots();
    }

    public int calculateWaitTime(long time, int n) {
        int count = 0;
        long totalDelta = 0L;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long pkey = new Long(i);
            DataRecord d = (DataRecord)this.window.get(pkey);
            if (d == null || d.acks != 0) continue;
            totalDelta += time - d.sentTime;
            if (++count >= n) break;
        }
        if (count > 0) {
            return (int)totalDelta / count;
        }
        return 0;
    }

    public int clearLowAckedBlocks() {
        Long pkey;
        DataRecord d;
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (d = (DataRecord)this.window.get(pkey = new Long(i))) != null && d.acks > 0; ++i) {
            this.window.remove(pkey);
            ++count;
        }
        this.windowStart += (long)count;
        return count;
    }

    public long getLowestUnsentBlock() {
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long pkey = new Long(i);
            if (this.window.get(pkey) != null) continue;
            return i;
        }
        return -1L;
    }

    public int countHigherAckBlocks() {
        int count = 0;
        for (long i = this.windowStart + 1L; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long pkey = new Long(i);
            DataRecord d = (DataRecord)this.window.get(pkey);
            if (d == null || d.acks <= 0) continue;
            ++count;
        }
        return count;
    }

    public boolean acksAppearToBeMissing(long time, int multiple) {
        int irto = (int)this.rto;
        DataRecord drec = this.getBlock(this.windowStart);
        return irto > 0 && drec != null && drec.acks < 1 && drec.sentTime + (long)(multiple * irto) < time;
    }

    public int getRTO() {
        return (int)this.rto;
    }

    public float getRTTVar() {
        return this.rttvar;
    }

    public float getSRTT() {
        return this.srtt;
    }

    public int lowRoundTripTime() {
        return (int)this.averageLowRTT;
    }

    public void ackBlock(long pnum) {
        DataRecord drec;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered ackBlock with # " + pnum));
        }
        if ((drec = this.getBlock(pnum)) != null) {
            ++drec.acks;
            drec.ackTime = System.currentTimeMillis();
            if (drec.acks == 1 && drec.sends == 1) {
                long rtt = drec.ackTime - drec.sentTime;
                float delta = (float)rtt - this.srtt;
                if (rtt > 0L) {
                    this.srtt = (double)this.srtt <= 0.1 ? delta : (this.srtt += 0.125f * delta);
                    this.rttvar += 0.25f * (Math.abs(delta) - this.rttvar);
                    this.rto = (float)((double)(this.srtt + 4.0f * this.rttvar) + 0.5);
                    if (this.averageRTT == 0L) {
                        this.averageRTT = rtt;
                    } else {
                        float avgRTT = (float)(this.averageRTT * 3L + rtt) / 4.0f;
                        this.averageRTT = (long)avgRTT;
                    }
                    if (this.lowRTTCount < 10 || rtt < this.averageLowRTT) {
                        if (this.averageLowRTT == 0L) {
                            this.averageLowRTT = rtt;
                        } else {
                            float lowRtt = (float)(this.averageLowRTT * 3L + rtt) / 4.0f;
                            this.averageLowRTT = (long)lowRtt;
                        }
                        ++this.lowRTTCount;
                    }
                }
            }
        }
    }

    public void pseudoAckToReceiverWindow(long wStart) {
        if (wStart <= this.windowStart) {
            return;
        }
        for (long i = this.windowStart; i < wStart; ++i) {
            DataRecord drec = this.getBlock(i);
            if (drec == null || drec.acks != 0) continue;
            ++drec.acks;
            drec.ackTime = drec.sentTime + (long)((int)this.rto);
        }
    }

    public DataRecord getOldestUnackedBlock() {
        DataRecord oldest = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null || d.acks != 0 || oldest != null && d.sentTime >= oldest.sentTime) continue;
            oldest = d;
        }
        return oldest;
    }

    public DataRecord getWritableBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered getWritableBlock wStart " + this.windowStart + " wSize " + this.windowSize));
        }
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null) {
                LOG.debug((Object)"log is null");
                break;
            }
            LOG.debug((Object)"current block not null");
            if (!d.written) {
                LOG.debug((Object)"returning a block");
                return d;
            }
            LOG.debug((Object)"current block is written");
        }
        LOG.debug((Object)"returning null");
        return null;
    }

    public int clearEarlyWrittenBlocks() {
        Long pkey;
        DataRecord d;
        int count = 0;
        long maxBlock = this.windowStart + (long)this.windowSize;
        long newMaxBlock = maxBlock + (long)this.windowSize;
        long lastBlock = -1L;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (d = (DataRecord)this.window.get(pkey = new Long(i))) != null && d.written; ++i) {
            this.window.remove(pkey);
            ++count;
        }
        this.windowStart += (long)count;
        return count;
    }

    public DataRecord findMostAcked() {
        DataRecord mostAcked = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (mostAcked == null) {
                mostAcked = d;
                continue;
            }
            if (d == null || mostAcked.acks >= d.acks) continue;
            mostAcked = d;
        }
        return mostAcked;
    }

    public int numNotWritten() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null || d.written) continue;
            ++count;
        }
        return count;
    }

    public int numNotAcked() {
        int count = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord d = this.getBlock(i);
            if (d == null || d.acks > 0) continue;
            ++count;
        }
        return count;
    }

    public void printFinalStats() {
        System.out.println(" avgRTT:" + this.averageRTT + " lowRTT:" + this.averageLowRTT);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG.debug((Object)"log system initialized debug level");
    }
}

