/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import com.limegroup.gnutella.udpconnect.UDPTimerEvent;
import com.limegroup.gnutella.util.ManagedThread;
import java.util.ArrayList;
import java.util.Iterator;

public class UDPScheduler
extends ManagedThread {
    public static final UDPTimerEvent NO_EVENT = new NoEvent(Long.MAX_VALUE);
    private static final String NAME_OF_THREAD = "UDPScheduler";
    private ArrayList _connectionEvents;
    private UDPTimerEvent _scheduledEvent;
    private boolean _started = false;
    private Thread _myThread;
    private static UDPScheduler _instance = null;
    private UpdateThread _updateThread = null;
    private final Object _updateThreadLock = new Object();

    public static synchronized UDPScheduler instance() {
        if (_instance == null) {
            _instance = new UDPScheduler();
        }
        return _instance;
    }

    private UDPScheduler() {
        super(NAME_OF_THREAD);
        this._connectionEvents = new ArrayList();
        this._scheduledEvent = NO_EVENT;
    }

    public void register(UDPTimerEvent evt) {
        this.startThreads();
        this._updateThread.registerEvent(evt);
    }

    private final synchronized void registerSync(UDPTimerEvent evt) {
        this._connectionEvents.add(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startThreads() {
        if (!this._started) {
            this.setDaemon(true);
            this.start();
            this._started = true;
        }
        Object object = this._updateThreadLock;
        synchronized (object) {
            if (this._updateThread == null) {
                this._updateThread = new UpdateThread();
                this._updateThread.setDaemon(true);
                this._updateThread.start();
            }
        }
    }

    public void scheduleEvent(UDPTimerEvent evt) {
        this.startThreads();
        this._updateThread.addEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedRun() {
        this._myThread = Thread.currentThread();
        while (true) {
            long waitTime;
            UDPScheduler uDPScheduler;
            try {
                uDPScheduler = this;
                synchronized (uDPScheduler) {
                    if (this._scheduledEvent == NO_EVENT) {
                        waitTime = 0L;
                    } else {
                        waitTime = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                        if (waitTime == 0L) {
                            waitTime = -1L;
                        }
                    }
                    if (waitTime >= 0L) {
                        this.wait(waitTime);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            uDPScheduler = this;
            synchronized (uDPScheduler) {
                waitTime = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                if (waitTime > 0L) {
                    continue;
                }
            }
            this.runEvent();
            this.reworkSchedule();
        }
    }

    private synchronized void runEvent() {
        if (this._scheduledEvent.shouldUnregister()) {
            this._connectionEvents.remove(this._scheduledEvent);
        } else {
            this._scheduledEvent.handleEvent();
        }
    }

    private synchronized void reworkSchedule() {
        this._scheduledEvent = NO_EVENT;
        for (int i = 0; i < this._connectionEvents.size(); ++i) {
            UDPTimerEvent evt = (UDPTimerEvent)this._connectionEvents.get(i);
            long time = evt.getEventTime();
            if (evt == NO_EVENT || time >= this._scheduledEvent.getEventTime() && this._scheduledEvent != NO_EVENT) continue;
            this._scheduledEvent = evt;
        }
    }

    private static final class NoEvent
    extends UDPTimerEvent {
        public NoEvent(long time) {
            super(time, null);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
        }
    }

    class UpdateThread
    extends ManagedThread {
        ArrayList _listSchedule = new ArrayList();
        ArrayList _listRegister = new ArrayList();

        public synchronized void addEvent(UDPTimerEvent evt) {
            this._listSchedule.add(evt);
            this.notify();
        }

        public synchronized void registerEvent(UDPTimerEvent evt) {
            this._listRegister.add(evt);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void managedRun() {
            while (true) {
                ArrayList localListRegister;
                ArrayList localListSchedule;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                UpdateThread e = this;
                synchronized (e) {
                    localListSchedule = (ArrayList)this._listSchedule.clone();
                    this._listSchedule.clear();
                    localListRegister = (ArrayList)this._listRegister.clone();
                    this._listRegister.clear();
                }
                Iterator iter = localListRegister.iterator();
                while (iter.hasNext()) {
                    UDPScheduler.this.registerSync((UDPTimerEvent)iter.next());
                }
                for (int i = 0; i < localListSchedule.size(); ++i) {
                    UDPTimerEvent evt = (UDPTimerEvent)localListSchedule.get(i);
                    this.updateSchedule(evt);
                }
                UpdateThread updateThread = this;
                synchronized (updateThread) {
                    if (this._listSchedule.size() > 0 || this._listRegister.size() > 0) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSchedule(UDPTimerEvent evt) {
            UDPScheduler uDPScheduler = UDPScheduler.this;
            synchronized (uDPScheduler) {
                if (evt.getEventTime() < UDPScheduler.this._scheduledEvent.getEventTime() && UDPScheduler.this._connectionEvents.contains(evt)) {
                    UDPScheduler.this._scheduledEvent = evt;
                    UDPScheduler.this.notify();
                }
            }
        }
    }
}

