/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UDPTimerEvent
implements Comparable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$UDPTimerEvent == null ? (class$com$limegroup$gnutella$udpconnect$UDPTimerEvent = UDPTimerEvent.class$("com.limegroup.gnutella.udpconnect.UDPTimerEvent")) : class$com$limegroup$gnutella$udpconnect$UDPTimerEvent));
    protected volatile long _eventTime;
    private volatile boolean _shouldUnregister;
    protected final WeakReference _udpCon;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPTimerEvent;

    UDPTimerEvent(long eventTime, UDPConnectionProcessor conn) {
        this._eventTime = eventTime;
        this._udpCon = new WeakReference<UDPConnectionProcessor>(conn);
    }

    final boolean shouldUnregister() {
        if (this._udpCon.get() == null || this._shouldUnregister) {
            LOG.debug((Object)"Event decided to unregister itself");
            return true;
        }
        return false;
    }

    protected final void unregister() {
        this._shouldUnregister = true;
        this._eventTime = 1L;
    }

    public void updateTime(long updatedEventTime) {
        if (!this._shouldUnregister) {
            this._eventTime = updatedEventTime;
        }
    }

    public long getEventTime() {
        return this._eventTime;
    }

    public final void handleEvent() {
        UDPConnectionProcessor udpCon = (UDPConnectionProcessor)this._udpCon.get();
        if (udpCon == null) {
            return;
        }
        this.doActualEvent(udpCon);
    }

    protected abstract void doActualEvent(UDPConnectionProcessor var1);

    public int compareTo(Object x) {
        long ret = ((UDPTimerEvent)x)._eventTime - this._eventTime;
        if (ret > 0L) {
            return 1;
        }
        if (ret < 0L) {
            return -1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

