/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.html.FileListHTMLPage;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class FileViewUploadState
extends UploadState {
    public static final byte[] BAD_PASS_REPLY = "Wrong Password!".getBytes();
    public static final byte[] MALFORMED_REQUEST_REPLY = "Malformed Request!".getBytes();
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public FileViewUploadState(HTTPUploader uploader) {
        super(uploader);
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        String pass;
        String fileName = this.UPLOADER.getFileName();
        if (fileName.startsWith(pass = "/gnutella/file-view/" + UploadManager.FV_PASS)) {
            FileListHTMLPage htmlGen = FileListHTMLPage.instance();
            String indices = fileName.substring(pass.length());
            if (indices.length() > 1) {
                StringTokenizer st = new StringTokenizer(indices, "/&");
                ArrayList<FileDesc> descs = new ArrayList<FileDesc>(st.countTokens());
                while (st.hasMoreTokens()) {
                    try {
                        int i = Integer.parseInt(st.nextToken());
                        descs.add(RouterService.getFileManager().get(i));
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (IndexOutOfBoundsException ioooe) {}
                }
                if (descs.size() > 0) {
                    FileDesc[] descArray = descs.toArray(new FileDesc[0]);
                    this.BAOS.write(htmlGen.getSharedFilePage(descArray).getBytes());
                } else {
                    this.BAOS.write(MALFORMED_REQUEST_REPLY);
                }
            } else {
                this.BAOS.write(htmlGen.getSharedFilePage().getBytes());
            }
        } else {
            this.BAOS.write(BAD_PASS_REPLY);
        }
        String str = "HTTP/1.1 200 OK\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/html; charset=ISO-8859-1\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + this.BAOS.size() + "\r\n";
        ostream.write(str.getBytes());
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(this.BAOS.toByteArray());
        this.UPLOADER.setAmountUploaded(this.BAOS.size());
        this.debug("BHUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception out) {
    }
}

