/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.AbstractI18NConverter;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.BitSet;

final class I18NConvert118
extends AbstractI18NConverter {
    private Trie _convert = new Trie(false);
    private Trie _kc = new Trie(false);
    BitSet _ex;

    I18NConvert118() throws IOException, ClassNotFoundException {
        String line;
        InputStream fi = CommonUtils.getResourceStream("nudata.txt");
        BufferedReader buf = new BufferedReader(new InputStreamReader(fi));
        while ((line = buf.readLine()) != null) {
            String[] splitUp = StringUtils.splitNoCoalesce(line, ";");
            this._convert.add(this.code2char(splitUp[0]), this.code2char(splitUp[1]));
            if (splitUp[2].equals("")) continue;
            this._kc.add(this.code2char(splitUp[1]), this.code2char(splitUp[2]));
        }
        fi = CommonUtils.getResourceStream("excluded.dat");
        ObjectInputStream ois = new ObjectInputStream(fi);
        this._ex = (BitSet)ois.readObject();
    }

    public String getNorm(String s) {
        return this.blockSplit(this.kmp(this.dekmp(s)));
    }

    private String dekmp(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            buf.append(this.getDK(s.charAt(i)));
        }
        return buf.toString();
    }

    private String kmp(String s) {
        if (s.length() == 0) {
            return s;
        }
        char first = s.charAt(0);
        StringBuffer b = new StringBuffer();
        String comped = "";
        int n = s.length();
        for (int i = 1; i < n; ++i) {
            comped = this.getKC(String.valueOf(first) + String.valueOf(s.charAt(i)));
            if (comped != null) {
                first = comped.charAt(0);
                continue;
            }
            b.append(first);
            first = s.charAt(i);
        }
        b.append(first);
        return b.toString();
    }

    private String code2char(String s) {
        StringBuffer b = new StringBuffer();
        if (s.indexOf(" ") > -1) {
            String[] splitup = StringUtils.split(s, " ");
            for (int i = 0; i < splitup.length; ++i) {
                b.append((char)Integer.parseInt(splitup[i], 16));
            }
        } else {
            b.append((char)Integer.parseInt(s, 16));
        }
        return b.toString();
    }

    private String getDK(char c) {
        if (this._ex.get(c)) {
            return "";
        }
        String s = (String)this._convert.get(String.valueOf(c));
        return s == null ? String.valueOf(c) : s;
    }

    private String getKC(String s) {
        return (String)this._kc.get(s);
    }
}

