/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.metadata.MP3MetaData;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument
implements Serializable {
    public static final String XML_ID_ATTRIBUTE_STRING = "identifier";
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private static DOMParser parser = new DOMParser();
    private volatile transient int hashCode = 0;
    static final long serialVersionUID = 7396170507085078485L;
    private final Map fieldToValue = new TreeMap(Comparators.stringComparator());
    private String schemaUri;
    private String xmlString;
    private String identifier;
    private String action = "";
    private boolean supportsID3v2 = true;
    private transient List CACHED_KEYWORDS = null;

    public boolean supportsID3v2() {
        return this.supportsID3v2;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public void setSchemaURI(String uri) {
        this.schemaUri = uri;
    }

    public LimeXMLDocument(String XMLStr) throws SAXException, SchemaNotFoundException, IOException {
        if (XMLStr == null || XMLStr.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource doc = new InputSource(new StringReader(XMLStr));
        this.initialize(doc);
        this.xmlString = LimeXMLDocument.ripIdentifier(XMLStr.trim());
        if (this.xmlString.equals("")) {
            throw new SAXException("empty after identifier ripped");
        }
    }

    public LimeXMLDocument(Node node, Node rootElement) throws SchemaNotFoundException, IOException {
        this.grabDocInfo(rootElement, true);
        this.grabDocInfo(node, false);
        this.createMap(node, rootElement.getNodeName());
        if (this.fieldToValue.isEmpty()) {
            throw new IOException("no elements.");
        }
        if (this.getXMLString().equals("")) {
            throw new IOException("invalid elements.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public LimeXMLDocument(Collection nameValueList, String schemaURI) {
        this.schemaUri = schemaURI;
        if (nameValueList.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        Iterator i = nameValueList.iterator();
        while (i.hasNext()) {
            void var5_6;
            void var4_5;
            Object value;
            String name;
            Object next = i.next();
            if (next instanceof NameValue) {
                name = ((NameValue)next).getName();
                value = ((NameValue)next).getValue();
            } else if (next instanceof Map.Entry) {
                name = (String)((Map.Entry)next).getKey();
                value = ((Map.Entry)next).getValue();
            } else {
                throw new IllegalArgumentException("Invalid Collection");
            }
            this.fieldToValue.put(var4_5.trim(), var5_6);
        }
        try {
            if (this.getXMLString().equals("")) {
                throw new IllegalArgumentException("invalid collection data.");
            }
        }
        catch (SchemaNotFoundException snfe) {
            throw new IllegalArgumentException(snfe.getMessage());
        }
    }

    boolean isValid() {
        try {
            return !this.getXMLString().equals("") && !this.fieldToValue.isEmpty();
        }
        catch (SchemaNotFoundException snfe) {
            return false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String genre;
        in.defaultReadObject();
        if (this.xmlString != null) {
            this.xmlString = this.xmlString.trim();
        }
        if (this.identifier != null && this.fieldToValue != null && LimeXMLUtils.isMP3File(this.identifier) && (genre = (String)this.fieldToValue.get("audios__audio__genre__")) != null) {
            try {
                short index = Short.parseShort(genre);
                genre = MP3MetaData.getGenreString(index);
                this.fieldToValue.put("audios__audio__genre__", genre);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static String ripIdentifier(String xmlWithID) {
        String retString = xmlWithID;
        int indexOfID = xmlWithID.indexOf(XML_ID_ATTRIBUTE_STRING);
        if (indexOfID > -1) {
            String quote = "\"";
            int indexOfEndQuote = xmlWithID.indexOf("\"", indexOfID + 1);
            indexOfEndQuote = xmlWithID.indexOf("\"", indexOfEndQuote + 1);
            String begin = xmlWithID.substring(0, indexOfID);
            String end = xmlWithID.substring(indexOfEndQuote + 1);
            retString = begin + end;
        }
        if (retString.indexOf(XML_HEADER) < 0) {
            retString = XML_HEADER + retString;
        }
        return retString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(InputSource doc) throws SchemaNotFoundException, IOException, SAXException {
        Document document = null;
        DOMParser dOMParser = parser;
        synchronized (dOMParser) {
            parser.parse(doc);
            document = parser.getDocument();
        }
        Element docElement = document.getDocumentElement();
        this.grabDocInfo(docElement, true);
        Node child = docElement.getFirstChild();
        this.grabDocInfo(child, false);
        this.createMap(docElement);
    }

    private void grabDocInfo(Node docElement, boolean root) throws SchemaNotFoundException, IOException {
        if (docElement == null) {
            throw new IOException("null doc element");
        }
        NamedNodeMap nnm = docElement.getAttributes();
        if (nnm == null) {
            throw new IOException("invalid doc element -- null namednodemap");
        }
        List attributes = LimeXMLUtils.getAttributes(nnm);
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            Element e;
            Node att = (Node)attributes.get(i);
            String attName = att.getNodeName();
            String lowerAttName = attName.toLowerCase(Locale.US);
            if (lowerAttName.indexOf("schemalocation") >= 0) {
                this.schemaUri = att.getNodeValue();
                continue;
            }
            if (lowerAttName.indexOf(XML_ID_ATTRIBUTE_STRING) >= 0) {
                this.identifier = att.getNodeValue();
                e = (Element)docElement;
                e.removeAttribute(attName);
                continue;
            }
            if (lowerAttName.indexOf("action") >= 0) {
                this.action = att.getNodeValue();
                continue;
            }
            if (lowerAttName.indexOf("index") >= 0) {
                e = (Element)docElement;
                e.removeAttribute(attName);
                continue;
            }
            if (!root) continue;
            String canonicalizedAttName = docElement.getNodeName() + "__" + att.getNodeName() + "__";
            this.fieldToValue.put(canonicalizedAttName.trim(), att.getNodeValue().trim());
        }
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException();
        }
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList<String> retList = new ArrayList<String>();
        Iterator iter = this.fieldToValue.values().iterator();
        while (iter.hasNext()) {
            boolean number = true;
            String val = (String)iter.next();
            try {
                new Double(val);
            }
            catch (NumberFormatException e) {
                number = false;
            }
            if (number || val == null || val.equals("")) continue;
            retList.add(val);
        }
        this.CACHED_KEYWORDS = retList;
        return retList;
    }

    private void createMap(Node docElement) {
        this.doAllChildren(docElement, "");
    }

    private void createMap(Node docElement, String parent) {
        this.doAllChildren(docElement, parent);
    }

    private void doAllChildren(Node currNode, String parentName) {
        if (!currNode.hasChildNodes()) {
            this.doEntry(currNode, parentName);
            return;
        }
        String currString = this.doEntry(currNode, parentName);
        List children = LimeXMLUtils.getElements(currNode.getChildNodes());
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)children.get(i);
            this.doAllChildren(child, currString);
        }
    }

    private String doEntry(Node currNode, String parentName) {
        String currTag = !parentName.equals("") ? parentName + "__" + currNode.getNodeName() : currNode.getNodeName();
        Element currElement = (Element)currNode;
        String nodeValue = LimeXMLUtils.getText(currElement.getChildNodes());
        if (nodeValue != null && !nodeValue.equals("")) {
            this.fieldToValue.put(currTag.trim(), nodeValue.trim());
        }
        if (!parentName.equals("")) {
            List attribs = LimeXMLUtils.getAttributes(currNode.getAttributes());
            int size = attribs.size();
            for (int i = 0; i < size; ++i) {
                Node att = (Node)attribs.get(i);
                String attName = att.getNodeName();
                String attString = currTag + "__" + attName + "__";
                String attValue = att.getNodeValue();
                this.fieldToValue.put(attString.trim(), attValue.trim());
            }
        }
        return currTag;
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema schema = this.getSchema();
        if (schema != null) {
            return schema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAction() {
        return this.action;
    }

    public Set getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection getValueList() {
        return this.fieldToValue.values();
    }

    public List getOrderedNameValueList() throws SchemaNotFoundException {
        LinkedList<NameValue> retList = new LinkedList<NameValue>();
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException("no schema given.");
        }
        LimeXMLSchema schema = LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
        if (schema == null) {
            throw new SchemaNotFoundException("invalid schema: " + this.schemaUri);
        }
        String[] fNames = schema.getCanonicalizedFieldNames();
        for (int i = 0; i < fNames.length; ++i) {
            Object retObj = this.fieldToValue.get(fNames[i].trim());
            if (retObj == null) continue;
            retList.add(new NameValue(fNames[i].trim(), retObj));
        }
        return retList;
    }

    public String getValueFast(String field) {
        return (String)this.fieldToValue.get(field);
    }

    public String getValue(String fieldName) {
        String retValue = null;
        fieldName = fieldName.trim();
        retValue = (String)this.fieldToValue.get(fieldName);
        return retValue;
    }

    public String getXMLString() throws SchemaNotFoundException {
        if (this.xmlString == null || this.xmlString.equals("")) {
            this.xmlString = LimeXMLDocument.constructXML(this.getOrderedNameValueList(), this.schemaUri);
            this.xmlString = this.xmlString.trim();
        }
        return this.xmlString;
    }

    public String getXMLStringWithIdentifier() throws SchemaNotFoundException {
        String ret = this.getXMLString();
        int index = ret.indexOf(">");
        if (index < 0) {
            return ret;
        }
        ++index;
        index = ret.indexOf(">", index);
        ++index;
        index = ret.indexOf(">", index);
        String first = ret.substring(0, index);
        String last = ret.substring(index);
        String middle = " identifier=\"" + this.identifier + "\"";
        ret = first + middle + last;
        return ret;
    }

    public static String constructXML(List namValList, String uri) {
        if (namValList.size() == 0) {
            return "";
        }
        uri = LimeXMLUtils.encodeXML(uri);
        int size = namValList.size();
        StringBuffer first = new StringBuffer();
        StringBuffer last = new StringBuffer();
        String prevString = "";
        ArrayList<String> tagsToClose = new ArrayList<String>();
        boolean prevAtt = false;
        NameValue nv = (NameValue)namValList.get(0);
        String n = nv.getName();
        boolean end = n.endsWith("__");
        StringTokenizer tok = new StringTokenizer(n, "__");
        int c = tok.countTokens();
        boolean rootAtts = end && c == 2;
        int i = 0;
        Iterator iter = namValList.iterator();
        while (iter.hasNext()) {
            NameValue namevalue = (NameValue)iter.next();
            String currString = namevalue.getName();
            String value = LimeXMLUtils.encodeXML((String)namevalue.getValue());
            List currFields = XMLStringUtils.split(currString);
            int commonCount = 0;
            List prevFields = null;
            boolean attribute = false;
            if (currString.endsWith("__")) {
                attribute = true;
            }
            if (prevAtt && !attribute) {
                first.append(">");
            }
            if (i > 0) {
                prevFields = XMLStringUtils.split(prevString);
                commonCount = LimeXMLDocument.getCommonCount(currFields, prevFields);
            }
            int z = currFields.size();
            int numPending = tagsToClose.size();
            if (commonCount < numPending) {
                int closeCount = numPending - commonCount;
                int currClose = numPending - 1;
                for (int k = 0; k < closeCount; ++k) {
                    String closeStr = (String)tagsToClose.remove(currClose);
                    --currClose;
                    last.append("</" + closeStr + ">");
                }
            }
            if (last.length() != 0) {
                first.append(last);
                last.setLength(0);
            }
            for (int j = commonCount; j < z - 1; ++j) {
                String str = (String)currFields.get(j);
                first.append("<" + str);
                if (i == 0 && j == 0) {
                    first.append(" xsi:noNamespaceSchemaLocation=\"" + uri + "\"");
                    if (!rootAtts) {
                        first.append(">");
                    }
                } else if (!attribute) {
                    first.append(">");
                }
                tagsToClose.add(str);
            }
            String curr = (String)currFields.get(z - 1);
            if (!attribute) {
                first.append("<" + curr + ">" + value + "</" + curr + ">");
            } else {
                first.append(" " + curr + "=\"" + value + "\"");
                if (i == size - 1) {
                    first.append(">");
                }
            }
            prevString = currString;
            prevAtt = attribute;
            ++i;
        }
        int stillPending = tagsToClose.size();
        for (int l = stillPending - 1; l >= 0; --l) {
            String tag = (String)tagsToClose.remove(l);
            first.append("</" + tag + ">");
        }
        first.insert(0, XML_HEADER);
        return first.toString();
    }

    private static int getCommonCount(List currFields, List prevFields) {
        int retValue = 0;
        int smaller = currFields.size() < prevFields.size() ? currFields.size() : prevFields.size();
        for (int i = 0; i < smaller && currFields.get(i).equals(prevFields.get(i)); ++i) {
            ++retValue;
        }
        return retValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument xmlDoc = (LimeXMLDocument)o;
        return (this.schemaUri == null ? xmlDoc.schemaUri == null : this.schemaUri.equals(xmlDoc.schemaUri)) && (this.identifier == null ? xmlDoc.identifier == null : this.identifier.equals(xmlDoc.identifier)) && (this.action == null ? xmlDoc.action == null : this.action.equals(xmlDoc.action)) && (this.fieldToValue == null ? xmlDoc.fieldToValue == null : ((Object)this.fieldToValue).equals(xmlDoc.fieldToValue));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.fieldToValue != null) {
                result = 37 * result + ((Object)this.fieldToValue).hashCode();
            }
            if (this.schemaUri != null) {
                result = 37 * result + this.schemaUri.hashCode();
            }
            if (this.identifier != null) {
                result = 37 * result + this.identifier.hashCode();
            }
            if (this.action != null) {
                result = 37 * result + this.action.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return this.getXMLString();
        }
        catch (SchemaNotFoundException snfe) {
            return "no schema.";
        }
    }
}

