/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.impl.DatabasePlaylists;
import de.kapsi.net.daap.chunks.impl.DatabaseSongs;
import de.kapsi.net.daap.chunks.impl.DeletedIdListing;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Database
implements Cloneable {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$Database == null ? (class$de$kapsi$net$daap$Database = Database.class$("de.kapsi.net.daap.Database")) : class$de$kapsi$net$daap$Database));
    private static int ID = 0;
    private int id;
    private long persistentId;
    private byte[] databaseSongs;
    private byte[] databaseSongsUpdate;
    private byte[] databasePlaylists;
    private byte[] databasePlaylistsUpdate;
    private HashSet containers;
    private HashSet deletedContainers;
    private Playlist masterPlaylist;
    static /* synthetic */ Class class$de$kapsi$net$daap$Database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(String name) {
        Class clazz = class$de$kapsi$net$daap$Database == null ? (class$de$kapsi$net$daap$Database = Database.class$("de.kapsi.net.daap.Database")) : class$de$kapsi$net$daap$Database;
        synchronized (clazz) {
            this.id = ++ID;
        }
        this.persistentId = Library.nextPersistentId();
        this.containers = new HashSet();
        this.deletedContainers = new HashSet();
        this.masterPlaylist = new Playlist(name);
        this.containers.add(this.masterPlaylist);
    }

    private Database(Database orig) throws CloneNotSupportedException {
        this.id = orig.id;
        this.persistentId = orig.persistentId;
        this.databaseSongs = orig.databaseSongs;
        this.databaseSongsUpdate = orig.databaseSongsUpdate;
        this.databasePlaylists = orig.databasePlaylists;
        this.databasePlaylistsUpdate = orig.databasePlaylistsUpdate;
        this.containers = new HashSet();
        Iterator it = orig.containers.iterator();
        while (it.hasNext()) {
            Playlist playlist = (Playlist)it.next();
            Playlist clone = (Playlist)playlist.clone();
            if (playlist == orig.masterPlaylist) {
                this.masterPlaylist = clone;
            }
            this.containers.add(clone);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.masterPlaylist.getName();
    }

    public void setName(Transaction txn, String name) {
        this.masterPlaylist.setName(txn, name);
    }

    long getPersistentId() {
        return this.persistentId;
    }

    public Playlist getMasterPlaylist() {
        return this.masterPlaylist;
    }

    public Set getPlaylists() {
        return Collections.unmodifiableSet(this.containers);
    }

    public Set getDeletedPlaylists() {
        return Collections.unmodifiableSet(this.deletedContainers);
    }

    Txn openTxn(Transaction txn) throws DaapException {
        if (!txn.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        DatabaseTxn obj = (DatabaseTxn)txn.getAttribute(this);
        if (obj == null) {
            obj = new DatabaseTxn(this);
            txn.setAttribute(this, obj);
        }
        return obj;
    }

    public void add(Transaction txn, Playlist playlist) throws DaapException {
        if (playlist == this.masterPlaylist) {
            throw new DaapException("You cannot add the master playlist.");
        }
        DatabaseTxn obj = (DatabaseTxn)this.openTxn(txn);
        obj.add(playlist);
    }

    public void remove(Transaction txn, Playlist playlist) throws DaapException {
        if (playlist == this.masterPlaylist) {
            throw new DaapException("You cannot remove the master playlist.");
        }
        DatabaseTxn obj = (DatabaseTxn)this.openTxn(txn);
        obj.remove(playlist);
    }

    public void update(Transaction txn, Song song) throws DaapException {
        DatabaseTxn obj = (DatabaseTxn)this.openTxn(txn);
        obj.update(song);
    }

    public void add(Transaction txn, Song song) throws DaapException {
        DatabaseTxn obj = (DatabaseTxn)this.openTxn(txn);
        obj.add(song);
    }

    public void remove(Transaction txn, Song song) throws DaapException {
        DatabaseTxn obj = (DatabaseTxn)this.openTxn(txn);
        obj.remove(song);
    }

    public boolean isEmpty() {
        return this.containers.isEmpty();
    }

    public int size() {
        return this.containers.size();
    }

    public boolean contains(Playlist playlist) {
        return this.containers.contains(playlist);
    }

    private Playlist getPlaylist(int playlistId) {
        Iterator it = this.containers.iterator();
        while (it.hasNext()) {
            Playlist pl = (Playlist)it.next();
            if (pl.getId() != playlistId) continue;
            return pl;
        }
        return null;
    }

    private Song getSong(int songId) {
        Iterator it = this.containers.iterator();
        while (it.hasNext()) {
            Playlist playlist = (Playlist)it.next();
            Song song = playlist.getSong(songId);
            if (song == null) continue;
            return song;
        }
        return null;
    }

    public synchronized Object select(DaapRequest request) {
        if (request.isSongRequest()) {
            return this.getSong(request.getItemId());
        }
        if (request.isDatabaseSongsRequest()) {
            if (request.isUpdateType()) {
                return this.databaseSongsUpdate;
            }
            return this.databaseSongs;
        }
        if (request.isDatabasePlaylistsRequest()) {
            if (request.isUpdateType()) {
                return this.databasePlaylistsUpdate;
            }
            return this.databasePlaylists;
        }
        if (request.isPlaylistSongsRequest()) {
            Playlist playlist = this.getPlaylist(request.getContainerId());
            if (playlist == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No playlist " + request.getContainerId() + " known in Database " + this.id));
                }
                return null;
            }
            return playlist.select(request);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unknown request: " + request));
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Database(this);
    }

    public String toString() {
        return "Database(" + this.getId() + ", " + this.getName() + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ byte[] access$902(Database x0, byte[] x1) {
        x0.databaseSongs = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1102(Database x0, byte[] x1) {
        x0.databaseSongsUpdate = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1202(Database x0, byte[] x1) {
        x0.databasePlaylists = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1502(Database x0, byte[] x1) {
        x0.databasePlaylistsUpdate = x1;
        return x1;
    }

    private static final class DatabaseSongsImpl
    extends DatabaseSongs {
        private DatabaseSongsImpl(Playlist playlist, boolean updateType) {
            Song song;
            Set items = playlist.getSongs();
            Set newItems = playlist.getNewSongs();
            Set deletedItems = playlist.getDeletedSongs();
            this.add(new Status(200));
            this.add(new UpdateType(updateType));
            int secifiedTotalCount = items.size() - deletedItems.size();
            int returnedCount = newItems.size();
            this.add(new SpecifiedTotalCount(secifiedTotalCount));
            this.add(new ReturnedCount(returnedCount));
            Listing listing = new Listing();
            Iterator it = (updateType ? newItems : items).iterator();
            while (it.hasNext()) {
                ListingItem listingItem = new ListingItem();
                song = (Song)it.next();
                Iterator<String> properties = Arrays.asList(DaapUtil.DATABASE_SONGS_META).iterator();
                while (properties.hasNext()) {
                    String key = properties.next();
                    Chunk chunk = song.getProperty(key);
                    if (chunk != null) {
                        listingItem.add(chunk);
                        continue;
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Unknown chunk type: " + key));
                }
                listing.add(listingItem);
            }
            this.add(listing);
            if (updateType && (it = deletedItems.iterator()).hasNext()) {
                DeletedIdListing deletedListing = new DeletedIdListing();
                while (it.hasNext()) {
                    song = (Song)it.next();
                    deletedListing.add(new ItemId(song.getId()));
                }
                this.add(deletedListing);
            }
        }

        public byte[] getBytes() {
            return this.getBytes(true);
        }

        public byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }

    private static final class DatabasePlaylistsImpl
    extends DatabasePlaylists {
        private DatabasePlaylistsImpl(Database database, boolean updateType) {
            int specifiedTotalCount;
            this.add(new Status(200));
            this.add(new UpdateType(updateType));
            int returnedCount = specifiedTotalCount = database.containers.size() - database.deletedContainers.size();
            this.add(new SpecifiedTotalCount(specifiedTotalCount));
            this.add(new ReturnedCount(returnedCount));
            Listing listing = new Listing();
            Playlist masterPlaylist = database.getMasterPlaylist();
            listing.add(this.toListingItem(masterPlaylist));
            Iterator it = database.containers.iterator();
            while (it.hasNext()) {
                Playlist playlist = (Playlist)it.next();
                if (playlist == masterPlaylist) continue;
                listing.add(this.toListingItem(playlist));
            }
            this.add(listing);
            if (updateType && (it = database.deletedContainers.iterator()).hasNext()) {
                DeletedIdListing deletedListing = new DeletedIdListing();
                while (it.hasNext()) {
                    Playlist playlist = (Playlist)it.next();
                    deletedListing.add(new ItemId(playlist.getId()));
                }
                this.add(deletedListing);
            }
        }

        private ListingItem toListingItem(Playlist playlist) {
            ListingItem listingItem = new ListingItem();
            Iterator<String> properties = Arrays.asList(DaapUtil.DATABASE_PLAYLISTS_META).iterator();
            while (properties.hasNext()) {
                String key = properties.next();
                Chunk chunk = playlist.getProperty(key);
                if (chunk != null) {
                    listingItem.add(chunk);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Unknown chunk type: " + key));
            }
            return listingItem;
        }

        private byte[] getBytes() {
            return this.getBytes(true);
        }

        private byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }

    private static class DatabaseTxn
    implements Txn {
        private Database database;
        private HashSet newItems = new HashSet();
        private HashSet deletedItems = new HashSet();
        private HashSet updateItems = new HashSet();
        private HashSet containers = new HashSet();
        private HashSet deletedContainers = new HashSet();

        private DatabaseTxn(Database database) {
            this.database = database;
        }

        private void add(Playlist playlist) {
            if (!this.containers.contains(playlist)) {
                this.containers.add(playlist);
                this.deletedContainers.remove(playlist);
            }
        }

        private void remove(Playlist playlist) {
            if (!this.deletedContainers.contains(playlist)) {
                this.deletedContainers.add(playlist);
                this.containers.remove(playlist);
            }
        }

        private void add(Song song) {
            if (!this.newItems.contains(song)) {
                this.newItems.add(song);
                this.deletedItems.remove(song);
                this.updateItems.remove(song);
            }
        }

        private void remove(Song song) {
            if (!this.deletedItems.contains(song)) {
                this.deletedItems.add(song);
                this.newItems.remove(song);
                this.updateItems.remove(song);
            }
        }

        private void update(Song song) {
            if (!(this.updateItems.contains(song) || this.newItems.contains(song) || this.deletedItems.contains(song))) {
                this.updateItems.add(song);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(Transaction txn) {
            Database database = this.database;
            synchronized (database) {
                Playlist playlist;
                Iterator it = null;
                it = this.containers.iterator();
                while (it.hasNext()) {
                    playlist = (Playlist)it.next();
                    if (this.database.containers.contains(playlist)) continue;
                    this.database.containers.add(playlist);
                    this.database.deletedContainers.remove(playlist);
                }
                it = this.deletedContainers.iterator();
                while (it.hasNext()) {
                    playlist = (Playlist)it.next();
                    if (!this.database.containers.remove(playlist)) continue;
                    this.database.deletedContainers.add(playlist);
                    playlist.setMasterPlaylist(null);
                }
                it = this.database.containers.iterator();
                while (it.hasNext()) {
                    playlist = (Playlist)it.next();
                    Iterator add = this.newItems.iterator();
                    while (add.hasNext()) {
                        Song song = (Song)add.next();
                        playlist.add(txn, song);
                    }
                    Iterator update = this.updateItems.iterator();
                    while (update.hasNext()) {
                        Song song = (Song)update.next();
                        playlist.update(txn, song);
                    }
                    Iterator remove = this.deletedItems.iterator();
                    while (remove.hasNext()) {
                        Song song = (Song)remove.next();
                        playlist.remove(txn, song);
                    }
                }
                it = this.database.containers.iterator();
                while (it.hasNext()) {
                    Txn obj;
                    playlist = (Playlist)it.next();
                    if (playlist == this.database.masterPlaylist || (obj = txn.getAttribute(playlist)) == null) continue;
                    playlist.setMasterPlaylist(this.database.masterPlaylist);
                    obj.commit(txn);
                }
                Txn obj = txn.getAttribute(this.database.masterPlaylist);
                if (obj != null) {
                    obj.commit(txn);
                }
                Database.access$902(this.database, new DatabaseSongsImpl(this.database.masterPlaylist, false).getBytes());
                Database.access$1102(this.database, new DatabaseSongsImpl(this.database.masterPlaylist, true).getBytes());
                Database.access$1202(this.database, new DatabasePlaylistsImpl(this.database, false).getBytes());
                Database.access$1502(this.database, new DatabasePlaylistsImpl(this.database, true).getBytes());
            }
            this.containers.clear();
            this.deletedContainers.clear();
            this.updateItems.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(Transaction txn) {
            Database database = this.database;
            synchronized (database) {
                Iterator it = this.containers.iterator();
                while (it.hasNext()) {
                    Txn obj;
                    Playlist playlist = (Playlist)it.next();
                    if (playlist == this.database.masterPlaylist || (obj = txn.getAttribute(playlist)) == null) continue;
                    obj.rollback(txn);
                }
                Txn obj = txn.getAttribute(this.database.masterPlaylist);
                if (obj != null) {
                    obj.rollback(txn);
                }
            }
            this.containers.clear();
            this.deletedContainers.clear();
            this.updateItems.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup(Transaction txn) {
            Database database = this.database;
            synchronized (database) {
                Iterator it = this.containers.iterator();
                while (it.hasNext()) {
                    Playlist playlist = (Playlist)it.next();
                    Txn obj = txn.getAttribute(playlist);
                    if (obj == null) continue;
                    obj.cleanup(txn);
                }
                this.database.deletedContainers.clear();
            }
            this.containers.clear();
            this.deletedContainers.clear();
            this.updateItems.clear();
        }

        public void join(Txn value) {
            DatabaseTxn obj = (DatabaseTxn)value;
            Iterator it = obj.newItems.iterator();
            while (it.hasNext()) {
                this.add((Song)it.next());
            }
            it = obj.updateItems.iterator();
            while (it.hasNext()) {
                this.update((Song)it.next());
            }
            it = obj.deletedItems.iterator();
            while (it.hasNext()) {
                this.remove((Song)it.next());
            }
            it = obj.containers.iterator();
            while (it.hasNext()) {
                this.add((Playlist)it.next());
            }
            it = obj.deletedContainers.iterator();
            while (it.hasNext()) {
                this.remove((Playlist)it.next());
            }
        }

        public String toString() {
            return "DatabaseTxn for " + this.database;
        }
    }
}

