/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.TransactionListener;
import de.kapsi.net.daap.Txn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class Transaction {
    private static final long SCHEDULE_INTERVAL = 5000L;
    private static Timer timer;
    private static AutoCommitTask timerTask;
    private Library library;
    private Txn rootTxn;
    boolean autoCommit;
    private boolean open;
    private HashMap attributes = new HashMap();
    private HashSet listener = new HashSet();
    private final long txnCreated;
    private long lastModified;
    static /* synthetic */ Class class$de$kapsi$net$daap$Transaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transaction(Library library, Txn rootTxn, boolean autoCommit) {
        this.library = library;
        this.rootTxn = rootTxn;
        this.autoCommit = autoCommit;
        this.open = true;
        this.setAttribute(library, rootTxn);
        if (autoCommit) {
            Class clazz = class$de$kapsi$net$daap$Transaction == null ? (class$de$kapsi$net$daap$Transaction = Transaction.class$("de.kapsi.net.daap.Transaction")) : class$de$kapsi$net$daap$Transaction;
            synchronized (clazz) {
                if (timer == null) {
                    timer = new Timer(true);
                    timerTask = new AutoCommitTask();
                    timer.scheduleAtFixedRate((TimerTask)timerTask, 5000L, 5000L);
                }
                Transaction.timerTask.add(this);
            }
        }
        this.lastModified = this.txnCreated = System.currentTimeMillis();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public synchronized long lastModified() {
        return this.lastModified;
    }

    public synchronized void touch() {
        this.lastModified = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws DaapException {
        if (!this.isOpen()) {
            throw new DaapException();
        }
        try {
            this.rootTxn.commit(this);
            Iterator it = this.listener.iterator();
            while (it.hasNext()) {
                ((TransactionListener)it.next()).commit(this);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.rootTxn.cleanup(this);
            this.open = false;
            this.listener.clear();
            throw throwable;
        }
        this.rootTxn.cleanup(this);
        this.open = false;
        this.listener.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws DaapException {
        if (!this.isOpen()) {
            throw new DaapException();
        }
        try {
            this.rootTxn.rollback(this);
            Iterator it = this.listener.iterator();
            while (it.hasNext()) {
                ((TransactionListener)it.next()).rollback(this);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.rootTxn.cleanup(this);
            this.open = false;
            this.listener.clear();
            throw throwable;
        }
        this.rootTxn.cleanup(this);
        this.open = false;
        this.listener.clear();
    }

    public synchronized void join(Transaction txn) throws DaapException {
        if (this == txn) {
            throw new DaapException("Cannot join 'this' with itself");
        }
        if (!this.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        if (!txn.isOpen()) {
            throw new DaapException("The other Transaction is not open");
        }
        if (this.library != txn.library) {
            throw new DaapException("Transactions are associated with different Libraries");
        }
        this.listener.addAll(txn.listener);
        Iterator it = txn.attributes.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Txn value = (Txn)txn.attributes.get(key);
            if (!this.attributes.containsKey(key)) {
                this.attributes.put(key, value);
                continue;
            }
            Txn thizValue = (Txn)this.attributes.get(key);
            thizValue.join(value);
        }
    }

    public synchronized void addTransactionListener(TransactionListener l) {
        this.listener.add(l);
    }

    public synchronized void removeTransactionListener(TransactionListener l) {
        this.listener.remove(l);
    }

    void setAttribute(Object key, Txn value) throws DaapException {
        if (!this.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        if (value != null) {
            this.attributes.put(key, value);
        } else {
            this.attributes.remove(key);
        }
        this.touch();
    }

    Txn getAttribute(Object key) throws DaapException {
        if (!this.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        this.touch();
        return (Txn)this.attributes.get(key);
    }

    boolean hasAttribute(Object key) throws DaapException {
        if (!this.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        this.touch();
        return this.attributes.containsKey(key);
    }

    public String toString() {
        return this.attributes.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class AutoCommitTask
    extends TimerTask {
        private ArrayList list = new ArrayList();

        private AutoCommitTask() {
        }

        private void add(Transaction txn) {
            this.list.add(txn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$de$kapsi$net$daap$Transaction == null ? (class$de$kapsi$net$daap$Transaction = Transaction.class$("de.kapsi.net.daap.Transaction")) : class$de$kapsi$net$daap$Transaction;
            synchronized (clazz) {
                if (this.list.isEmpty()) {
                    this.cancel();
                    timer.cancel();
                    timer = null;
                    timerTask = null;
                }
                Iterator it = this.list.iterator();
                Transaction root = null;
                while (it.hasNext()) {
                    Transaction txn = (Transaction)it.next();
                    if (!txn.isOpen()) {
                        it.remove();
                        continue;
                    }
                    if (System.currentTimeMillis() - txn.lastModified() <= 5000L) continue;
                    if (root == null) {
                        root = txn;
                    } else {
                        root.join(txn);
                    }
                    it.remove();
                }
                if (root != null) {
                    root.commit();
                }
            }
        }
    }
}

