/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.jmdns.DNSEntry;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSOutgoing;

abstract class DNSRecord
extends DNSEntry {
    int ttl;
    long created;

    DNSRecord(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.ttl = n3;
        this.created = System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        return object instanceof DNSRecord && this.sameAs((DNSRecord)object);
    }

    boolean sameAs(DNSRecord dNSRecord) {
        return super.equals(dNSRecord) && this.sameValue(dNSRecord);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean suppressedBy(DNSIncoming dNSIncoming) {
        int n = dNSIncoming.numAnswers;
        while (n-- > 0) {
            if (!this.suppressedBy((DNSRecord)dNSIncoming.answers.elementAt(n))) continue;
            return true;
        }
        return false;
    }

    boolean suppressedBy(DNSRecord dNSRecord) {
        return this.sameAs(dNSRecord) && dNSRecord.ttl > this.ttl / 2;
    }

    long getExpirationTime(int n) {
        return this.created + (long)(n * this.ttl) * 10L;
    }

    int getRemainingTTL(long l) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - l) / 1000L);
    }

    boolean isExpired(long l) {
        return this.getExpirationTime(100) <= l;
    }

    boolean isStale(long l) {
        return this.getExpirationTime(50) <= l;
    }

    void resetTTL(DNSRecord dNSRecord) {
        this.created = dNSRecord.created;
        this.ttl = dNSRecord.ttl;
    }

    abstract void write(DNSOutgoing var1) throws IOException;

    public String toString(String string) {
        return this.toString("record", this.ttl + "/" + this.getRemainingTTL(System.currentTimeMillis()) + "," + string);
    }

    static class Service
    extends DNSRecord {
        int priority;
        int weight;
        int port;
        String server;

        Service(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2) {
            super(string, n, n2, n3);
            this.priority = n4;
            this.weight = n5;
            this.port = n6;
            this.server = string2;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeShort(this.priority);
            dNSOutgoing.writeShort(this.weight);
            dNSOutgoing.writeShort(this.port);
            dNSOutgoing.writeName(this.server);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            Service service = (Service)dNSRecord;
            return this.priority == service.priority && this.weight == service.weight && this.port == service.port && this.server.equals(service.server);
        }

        public String toString() {
            return this.toString(this.server + ":" + this.port);
        }
    }

    static class Text
    extends DNSRecord {
        byte[] text;

        Text(String string, int n, int n2, int n3, byte[] byArray) {
            super(string, n, n2, n3);
            this.text = byArray;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeBytes(this.text, 0, this.text.length);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            Text text = (Text)dNSRecord;
            if (text.text.length != this.text.length) {
                return false;
            }
            int n = this.text.length;
            while (n-- > 0) {
                if (text.text[n] == this.text[n]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(this.text.length > 10 ? new String(this.text, 0, 7) + "..." : new String(this.text));
        }
    }

    static class Pointer
    extends DNSRecord {
        String alias;

        Pointer(String string, int n, int n2, int n3, String string2) {
            super(string, n, n2, n3);
            this.alias = string2;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeName(this.alias);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            return this.alias.equals(((Pointer)dNSRecord).alias);
        }

        public String toString() {
            return this.toString(this.alias);
        }
    }

    static class Address
    extends DNSRecord {
        int addr;

        Address(String string, int n, int n2, int n3, int n4) {
            super(string, n, n2, n3);
            this.addr = n4;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeInt(this.addr);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            return this.addr == ((Address)dNSRecord).addr;
        }

        InetAddress getInetAddress() {
            try {
                return InetAddress.getByName(this.getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                return null;
            }
        }

        String getAddress() {
            return (this.addr >> 24 & 0xFF) + "." + (this.addr >> 16 & 0xFF) + "." + (this.addr >> 8 & 0xFF) + "." + (this.addr & 0xFF);
        }

        public String toString() {
            return this.toString(this.getAddress());
        }
    }
}

