/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.acquisitionx;

import com.limegroup.gnutella.*;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.settings.*;
import java.io.File;
import java.io.PrintStream;
import java.util.*;


public class AqDispatcher 
{
    public static void dispatchCommand(Vector v) throws Exception
    {
        String command = (String)v.elementAt(0);
        String firstElement = (v.size() > 1) ? (String)v.elementAt(1) : "";
        int intValue;
        try {
            intValue = (v.size() > 1 && !firstElement.equals("")) ? new Integer(firstElement).intValue() : 0;
        } catch (Exception e) {
            intValue = 0;
        }
        
		/* heavy */
		
			if (command.equals("setAdultFilter")) {
				FilterSettings.FILTER_ADULT.setValue(intValue == 1);
				return;
			}
			
			if (command.equals("setFreeloaderFiles")) {
				SharingSettings.FREELOADER_FILES.setValue(intValue);
				return;
			}
			
			if (command.equals("setIncompletePurgeTime")) {
				SharingSettings.INCOMPLETE_PURGE_TIME.setValue(intValue);
				return;
			}
			
			if (command.equals("setDownloadSpeed")) {
				DownloadSettings.DOWNLOAD_SPEED.setValue(intValue);
				return;
			}
            
            if (command.equals("setLanguage")) {
                ApplicationSettings.LANGUAGE.setValue(firstElement);
                return;
            }

        /* Magnet URLs */
        
            if (command.equals("handleMagnet")) {
                ExternalControl.handleMagnetRequest(firstElement);
                return;
            }
        
        /* Ultrapeers */
            
            if (command.equals("setEnableUltrapeer")) {	
                UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(intValue == 0);
                return;
            }
            
        /* Query */

            if (command.equals("query"))
            {
                byte[] guid = RouterService.newQueryGUID();
                AqEventHandler.queries.add(new GUID(guid).toString());

                try {
                    RouterService.query(guid, firstElement, "", MediaType.getAnyTypeMediaType());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            
            if (command.equals("queryWhatIsNew"))
            {
                byte[] guid = RouterService.newQueryGUID();
                AqEventHandler.queries.add(new GUID(guid).toString());
                
                try {
                    RouterService.queryWhatIsNew(guid, MediaType.getAnyTypeMediaType());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            
            
        /* Downloads */
            
            if (command.equals("download"))
            {
				RemoteFileDesc files[] = new RemoteFileDesc[v.size() - 1];
				List altRFDs = new LinkedList();
				for(int i = 1; i < v.size(); i++)
				{
					int index = (new Integer((String)v.elementAt(i))).intValue();
					files[i - 1] = (RemoteFileDesc)AqEventHandler.responses.elementAt(index);
					Set alts = (Set)AqEventHandler.alts.elementAt(index);
					Endpoint ep;
					for(Iterator itr = alts.iterator(); itr.hasNext(); altRFDs.add(new RemoteFileDesc(files[i - 1], ep)))
						ep = (Endpoint)itr.next();
				}

				try
				{
					RouterService.download(files, altRFDs, true, (GUID)AqEventHandler.queryGUIDs.get(intValue));
				}
				catch(AlreadyDownloadingException e) { }
				return;
			}
            
            if (command.equals("pauseDownload"))
            {
				Downloader d = (Downloader)AqEventHandler.indicesToDownloads.get(firstElement);
				if(d != null)
				{
					d.pause();
					AqEvent.signalEvent(AqEvent.kLWEventUpdateDownloadStats, d);
					AqEvent.signalEvent(AqEvent.kLWEventDownloadsUpdated, null);
				}
                return;
            }

            if (command.equals("retryDownload"))
            {
				Downloader d = (Downloader)AqEventHandler.indicesToDownloads.get(firstElement);
				if(d != null)
					d.resume();
				return;
            }

            if (command.equals("requeryDownload"))
            {
				ManagedDownloader d = (ManagedDownloader)AqEventHandler.indicesToDownloads.get(firstElement);
				if(d != null)
					d.sendRequeryImmediately();
				return;
            }

            if (command.equals("cancelDownload"))
            {
				Downloader d = (Downloader)AqEventHandler.indicesToDownloads.get(firstElement);
				if(d != null)
				{
					d.stop();
					if(d.getState() != Downloader.COMPLETE)
						d.getDownloadFragment().delete();
					RouterService.getDownloadManager().writeSnapshot();
				}
				return;
            }
            
        /* Uploads */
        
            if (command.equals("cancelUpload")) {
                Iterator i = RouterService.getUploadManager().getUploads().iterator();
                while (i.hasNext()) {
                    Uploader u = (Uploader)i.next();
                    if (u.getHost().equals(v.elementAt(1)) && u.getFileName().equals(v.elementAt(2)))
                        u.stop();
                }
                return;
            }

            if (command.equals("setMaxUploads")) {
                UploadSettings.HARD_MAX_UPLOADS.setValue(intValue);
                return;
            }

            if (command.equals("setUploadsPerPerson")) {
                UploadSettings.UPLOADS_PER_PERSON.setValue(intValue);
                return;
            }
            
            if (command.equals("setUploadSpeed")) {
                UploadSettings.UPLOAD_SPEED.setValue(intValue);
                return;
            }
            
            if (command.equals("setAllowPartialSharing")) {
                UploadSettings.ALLOW_PARTIAL_SHARING.setValue(intValue == 1);
                return;
            }

            if (command.equals("setAllowFreeloaders")) {
                if (intValue == 1) {
                    SharingSettings.FREELOADER_ALLOWED.setValue(100);
                } else {
                    SharingSettings.FREELOADER_ALLOWED.setValue(0);
                }
                return;
            }
        
        /* DAAP */
            
            if (command.equals("setDAAPEnabled")) {
                try {
                    if (intValue == 1) {
                        DaapManager.instance().start();
                        RouterService.getFileManager().loadSettings(false);
                    } else {
                        DaapManager.instance().stop();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }

            if (command.equals("setDAAPName")) {
                DaapSettings.DAAP_LIBRARY_NAME.setValue(firstElement);
                DaapSettings.DAAP_SERVICE_NAME.setValue(firstElement);
                if (DaapManager.instance().isServerRunning()) {
                    DaapManager.instance().updateService();
                }
                return;
            }

            if (command.equals("setDAAPRequirePassword")) {
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(intValue == 1);
                if (DaapManager.instance().isServerRunning()) {
                    DaapManager.instance().updateService();
                }
                return;
            }

            if (command.equals("setDAAPPassword")) {
                DaapSettings.DAAP_PASSWORD.setValue(firstElement);
                if (DaapManager.instance().isServerRunning()) {
                    DaapManager.instance().updateService();
                }
                return;
            }

        /* Connections */
        
            if (command.equals("closeConnection")) {
                Iterator i = RouterService.getConnectionManager().getConnections().iterator();
                while (i.hasNext()) {
                    Connection c = (Connection)i.next();
                    if (c.getAddress().equals(firstElement)) {
                        c.close();
                    }
                }
                return;
            }
        
            if (command.equals("setKeepAlive")) {
				RouterService.getConnectionManager();
				ConnectionManager.PREFERRED_CONNECTIONS_FOR_LEAF = intValue;
                //* heavy *//
				ConnectionSettings.NUM_LOCALE_PREF.setValue(intValue);
				RouterService.getConnectionManager().setPreferredConnections();
                return;
            }
            
            if (command.equals("setConnectionSpeed")) {
                ConnectionSettings.CONNECTION_SPEED.setValue(intValue);
                return;
            }
        
        /* 'setPort' */

            if (command.equals("setPort")) 
            {
                ConnectionSettings.PORT.setValue(intValue);
                RouterService.setListeningPort(intValue);
                return;
            }

        /* 'doBrowseHost' */

            if (command.equals("doBrowseHost")) 
            {
                final GUID queryGUID = new GUID(RouterService.newQueryGUID());
                AqEventHandler.queries.add(queryGUID.toString());
                
                try {
                    final String host = firstElement;
                    final int port = new Integer((String)v.elementAt(2)).intValue();
                    final GUID serventID = (GUID)AqEventHandler.hosts.get(host + port);

                    new Thread() {
                        public void run() {
                            /* davew better check these params */
                            RouterService.doAsynchronousBrowseHost(host, port, queryGUID, serventID, null, false);
                        }
                    }.start();
                } catch (Exception e) {
                    e.printStackTrace();
                }

                return;
            }

        /* Directories */

            if (command.equals("setDirectories")) 
            {   
                SharingSettings.setDirectoriesWithString(firstElement);
                RouterService.getFileManager().loadSettings(false);
                return;
            }

            if (command.equals("setSaveDirectory")) 
            {
                String value = firstElement;
                SharingSettings.DIRECTORY_FOR_SAVING_FILES.setValue(new File(value));
                return;
            }

            if (command.equals("setIncompleteDirectory")) 
            {
                String value = firstElement;
                if (value == null || value.equals("(null)")) {
                    SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(SharingSettings.DIRECTORY_FOR_SAVING_FILES.getValue(), "Incomplete"));
                } else {
                    SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(value));
                }
                return;
            }
        
        /* 'setMaxSimDownload' */
        
            if (command.equals("setMaxSimDownload")) {
                DownloadSettings.MAX_SIM_DOWNLOAD.setValue(intValue);
                return;
            }
            
        /* Proxy Settings */
            
            if (command.equals("setProxyType")) {
                if (intValue == ConnectionSettings.C_SOCKS4_PROXY)
                    ConnectionSettings.CONNECTION_METHOD.setValue(ConnectionSettings.C_SOCKS4_PROXY);
                else if (intValue == ConnectionSettings.C_SOCKS5_PROXY)
                    ConnectionSettings.CONNECTION_METHOD.setValue(ConnectionSettings.C_SOCKS5_PROXY);
                else if (intValue == ConnectionSettings.C_HTTP_PROXY)
                    ConnectionSettings.CONNECTION_METHOD.setValue(ConnectionSettings.C_HTTP_PROXY);
                else
                    ConnectionSettings.CONNECTION_METHOD.setValue(ConnectionSettings.C_NO_PROXY);
                return;
            }
            
            if (command.equals("setProxyServer")) {
                ConnectionSettings.PROXY_HOST.setValue(firstElement);
                return;
            }

            if (command.equals("setProxyPort")) {
                ConnectionSettings.PROXY_PORT.setValue(intValue);
                return;
            }

            if (command.equals("setProxyUsername")) {
                ConnectionSettings.PROXY_USERNAME.setValue(firstElement);
                return;
            }

            if (command.equals("setProxyPassword")) {
                ConnectionSettings.PROXY_PASS.setValue(firstElement);
                return;
            }

            if (command.equals("setProxyPrivate")) {
                ConnectionSettings.USE_PROXY_FOR_PRIVATE.setValue(intValue == 1);
                return;
            }
            
            if (command.equals("setRequiresAuthentication")) {
                ConnectionSettings.PROXY_AUTHENTICATE.setValue(intValue == 1);
                return;
            }
            
        /* Locale Settings */
                
            if (command.equals("setUsesLocalePreferencing")) {
                ConnectionSettings.USE_LOCALE_PREF.setValue(intValue == 1);
                return;
            }

            /* heavy
            if (command.equals("setDefaultLocale")) {
                ApplicationSettings.DEFAULT_LOCALE.setValue(firstElement);
                return;
            }
            */

        /* 'initComplete' */
        
            if (command.equals("initComplete"))
            {
				List waiting = RouterService.getDownloadManager().getWaitingDownloads();
				List active = RouterService.getDownloadManager().getActiveDownloads();
				for(Iterator i = active.iterator(); i.hasNext();)
				{
					Downloader d = (Downloader)i.next();
					try
					{
						d.resume();
					}
					catch(Exception e) { }
				}

				for(Iterator i = waiting.iterator(); i.hasNext();)
				{
					Downloader d = (Downloader)i.next();
					try
					{
						d.resume();
					}
					catch(Exception e) { }
				}

				return;
            }
            
        /* 'shutdown' */
        
            if (command.equals("shutdown")) {
                AqMain.killSelf();
                return;
            }

            if (command.equals("disconnectPipe")) {
                AqEvent.shouldSignalEvents = false;
                return;
            }
            
        /* Catch-All */
        
			try
			{
				System.err.println("AqDispatcher: Unhandled command: " + v);
            } catch (Exception e) {
                e.printStackTrace();
            }
			return;
    }
}