package com.limegroup.gnutella.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

/** 
 * Creates a new update panel for prompting the user for whether 
 * or not they would like to update. 
 */
final class UpdateDialog {
	
	/**
	 * Handle to the <tt>JDialog</tt> for the panel.
	 */
	private final JDialog DIALOG;
	
	/**
	 * Variable for the code for the user response.
	 */
	private int _responseCode;
	
	/**
	 * Constant for the user response to update later.
	 */
	private final static int UPDATE_LATER = 10;
	
	/**
	 * Constant for the user response to update now.
	 */
	private final static int UPDATE_NOW = 11;
	
	/**
	 * Constructs the pane that prompts the user for whether or not
	 * they would like to update the program.
	 *
	 * @param msg the message to display to the user regarding
	 *  the update
	 */
	public UpdateDialog(String msg) {
		final int WIDTH = 360;
    	DIALOG = new JDialog(GUIMediator.getAppFrame());
		DIALOG.setModal(true);
		DIALOG.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
		
		MultiLineLabel label = new MultiLineLabel(msg, WIDTH-40);
		
		String[] buttonLabels = {
		    "YES",
		    "NO"
		};
		
		String[] buttonTips = {
		    "UPDATE_NOW_TIP",
		    "UPDATE_LATER_TIP"
		};
		
		ActionListener[] buttonListeners = {
		    new UpdateNowListener(),
		    new UpdateLaterListener()
		};
		
		JPanel mainPanel = new JPanel();
		mainPanel.setBorder(BorderFactory.createEmptyBorder(6,6,6,6));
		mainPanel.add(label);
		ButtonRow buttonRow = 
		    new ButtonRow(buttonLabels, buttonTips, buttonListeners);
		Container contentPane = DIALOG.getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.add(mainPanel);
		contentPane.add(Box.createVerticalGlue());
		contentPane.add(buttonRow);
        DIALOG.pack();
        DIALOG.setLocation(GUIMediator.getScreenCenterPoint(DIALOG));
        DIALOG.setVisible(true);
	}
	
	/**
	 * Determines if the user is updating.
	 */
	boolean isUpdating() {
	    return _responseCode == UPDATE_NOW;
	}
	
	/**
	 * Class for responding to mouse clicks on the button for updating now.
	 * This sets the response code, initiates the update, and makes the window 
	 * invisible.
	 */
	private final class UpdateNowListener implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        _responseCode = UPDATE_NOW;
	        DIALOG.setVisible(false);
	        DIALOG.dispose();
	    }
	}
	
	/**
	 * Class for responding to mouse clicks on the button for updating later.
	 * This sets the response code and makes the window invisible.
	 */
	private final class UpdateLaterListener implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        _responseCode = UPDATE_LATER;
	        DIALOG.setVisible(false);
	        DIALOG.dispose();
	    }
	}
}
