package com.limegroup.gnutella.gui.download;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import com.limegroup.gnutella.gui.GUIMediator;

/**
 * This class contains the popup menu that is visible on right-click events in
 * the download window.
 */
final class DownloadPopupMenu {
	
	/**
	 * Constant for the <tt>JPopupMenu</tt> that contains all of the menu items.
	 */
	private final JPopupMenu MENU = new JPopupMenu();

	/**
	 * The index of the kill download menu item.
	 */
	static final int KILL_INDEX = 0;

	/**
	 * The index of the resume download menu item.
	 */
	static final int RESUME_INDEX = 1;

	/**
	 * The index of the launch download menu item.
	 */
	static final int LAUNCH_INDEX = 2;

	/**
	 * The index of the chat menu item.
	 */
	static final int CHAT_INDEX = 3;

	/**
	 * The index of the browse menu item.
	 */
	static final int BROWSE_INDEX = 4;
	
	DownloadPopupMenu(final DownloadMediator dm) {
    
    	/**
    	 * Constant for the kill download menu item.
    	 */
    	final JMenuItem KILL_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_KILL_DOWNLOAD")
    	);
    
    	/**
    	 * Constant for the resume download menu item.
    	 */
    	final JMenuItem RESUME_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_RESUME")
    	);
    
    	/**
    	 * Constant for the launch download file menu item.
    	 */
    	final JMenuItem LAUNCH_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_LAUNCH")
    	);
    
    	/**
    	 * Constant for the chat menu item.
    	 */
    	final JMenuItem CHAT_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_CHAT")
    	);
    
    	/**
    	 * Constant for the browse menu item.
    	 */
    	final JMenuItem BROWSE_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_BROWSE")
    	);
    
   		KILL_ITEM.addActionListener( dm.REMOVE_LISTENER );
		RESUME_ITEM.addActionListener( dm.RESUME_LISTENER );
		LAUNCH_ITEM.addActionListener( dm.LAUNCH_LISTENER );
		CHAT_ITEM.addActionListener( dm.CHAT_LISTENER );
        BROWSE_ITEM.addActionListener( dm.BROWSE_LISTENER );
		MENU.add(KILL_ITEM);
		MENU.add(RESUME_ITEM);
		MENU.add(LAUNCH_ITEM);
		MENU.add(CHAT_ITEM);
        MENU.add(BROWSE_ITEM);
    }
    
    JPopupMenu getComponent() { return MENU; }
    
}
