package com.limegroup.gnutella.gui.tables;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;

import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;

class LicenseRenderer extends DefaultTableCellRenderer implements ThemeObserver {
    
    /**
     * The CC icon.
     *
     * Lazily consructed.
     */
    private Icon CC_ICON = null;
    
    /**
     * The CC icon, unvalidated.
     *
     * Lazily constructed
     */
    private Icon CC_NOT_VALIDATED = null;    
    
    public LicenseRenderer() { 
        setHorizontalAlignment(JLabel.CENTER);
        ThemeMediator.addThemeObserver(this);
    }
    
    public void updateTheme() {
        CC_ICON = null;
        CC_NOT_VALIDATED = null;
    }

    /**
     * Retrieves the CC icon.
     */
    private Icon getCCIcon() {
        if(CC_ICON == null)
            CC_ICON = GUIMediator.getThemeImage("cc");
        return CC_ICON;
    }
    
    /**
     * Retrieves the invalid CC icon.
     */
    private Icon getCCUnvalidIcon() {
        if(CC_NOT_VALIDATED == null)
            CC_NOT_VALIDATED = ImageManipulator.gray(getCCIcon());
        return CC_NOT_VALIDATED;
    }

    public Component getTableCellRendererComponent(JTable table,
                                                   Object value, 
                                                   boolean isSel, 
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        Integer e = (Integer)value;
        super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, column);
        setText(null);
        if(e != null) {
            int i = e.intValue();
            switch(i) {
            case License.VERIFIED: setIcon(getCCIcon()); break;
            case License.UNVERIFIED:   setIcon(getCCUnvalidIcon()); break;
            default: setIcon(null);
            }
        } else {
            setIcon(null);
        }
        return this;
    }
}
