/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private boolean _triedSP2Workaround;
    private static final Log LOG;
    private static String[] STANDARD_HOSTS;
    private static ConnectionChecker current;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.ConnectionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        STANDARD_HOSTS = new String[]{"http://www.wanadoo.fr", "http://www.tiscali.com", "http://www.ntt.com", "http://www.tonline.com", "http://www.download.com", "http://www.ibm.com", "http://www.sun.com", "http://www.apple.com", "http://www.ebay.com", "http://www.sun.com", "http://www.monster.com", "http://www.uunet.com", "http://www.real.com", "http://www.microsoft.com", "http://www.sco.com", "http://www.google.com", "http://www.cnn.com", "http://www.amazon.com", "http://www.espn.com", "http://www.yahoo.com", "http://www.oracle.com", "http://www.dell.com", "http://www.ge.com", "http://www.sprint.com", "http://www.att.com", "http://www.mci.com", "http://www.cisco.com", "http://www.intel.com", "http://www.motorola.com", "http://www.hp.com", "http://www.gateway.com", "http://www.sony.com", "http://www.ford.com", "http://www.gm.com", "http://www.aol.com", "http://www.verizon.com", "http://www.passport.com", "http://www.go.com", "http://www.overture.com", "http://www.earthlink.net", "http://www.bellsouth.net", "http://www.excite.com", "http://www.paypal.com", "http://www.altavista.com", "http://www.weather.com", "http://www.mapquest.com", "http://www.geocities.com", "http://www.juno.com", "http://www.msnbc.com", "http://www.lycos.com", "http://www.comcast.com"};
    }

    private ConnectionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionChecker checkForLiveConnection() {
        LOG.trace((Object)"checking for live connection");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.ConnectionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = clazz;
        synchronized (clazz) {
            if (current == null) {
                current = new ConnectionChecker();
            }
            ConnectionChecker connectionChecker = current;
            // ** MonitorExit[var1] (shouldn't be in output)
            object = new ManagedThread(connectionChecker, "check for live connection");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            return connectionChecker;
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 191->195)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trySP2Workaround() {
        if (this.hasNoTransfers() && this.udpIsDead()) {
            return;
        }
        this.killAndSleep();
    }

    private boolean hasNoTransfers() {
        RouterService.getDownloadManager().measureBandwidth();
        float f = RouterService.getDownloadManager().getMeasuredBandwidth();
        if (f != 0.0f) {
            return false;
        }
        RouterService.getUploadManager().measureBandwidth();
        float f2 = RouterService.getUploadManager().getMeasuredBandwidth();
        return f2 == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean udpIsDead() {
        PingRequest pingRequest = PingRequest.createUDPPing();
        Collection collection = RouterService.getPreferencedHosts(false, "en", 50);
        UDPPinger uDPPinger = RouterService.getHostCatcher().getPinger();
        UDPChecker uDPChecker = new UDPChecker();
        uDPPinger.rank(collection, uDPChecker, uDPChecker, pingRequest);
        long l = System.currentTimeMillis();
        UDPChecker uDPChecker2 = uDPChecker;
        synchronized (uDPChecker2) {
            try {
                int n = 0;
                while (n < 5) {
                    uDPChecker.wait(1000L);
                    if (UDPService.instance().getLastReceivedTime() > l) {
                        uDPChecker.received = true;
                        return false;
                    }
                    ++n;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!uDPChecker.received) return true;
        return false;
    }

    private void killAndSleep() {
        RouterService.disconnect();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        this._unsuccessfulAttempts = 0;
    }

    public boolean hasConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectToHost(String string) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connecting to: " + string));
        }
        Socket socket = null;
        try {
            try {
                InetAddress.getByName(string);
                socket = Sockets.connectHardTimeout(string, 80, 20000);
                this._connected = true;
            }
            catch (IOException iOException) {
                ++this._unsuccessfulAttempts;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IOUtils.close(socket);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IOUtils.close(socket);
    }

    private class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        UDPChecker() {
        }

        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message message, ReplyHandler replyHandler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }
}

