/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;

public abstract class Message
implements Serializable,
Comparable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final byte F_UDP_CONNECTION = 65;
    public static final int N_UNKNOWN = -1;
    public static final int N_TCP = 1;
    public static final int N_UDP = 2;
    public static final int N_MULTICAST = 3;
    public static final byte SOFT_MAX = ConnectionSettings.SOFT_MAX.getValue();
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final int network;

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50, "Bad function code");
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte by, byte by2, int n) {
        this(by, by2, n, -1);
    }

    protected Message(byte by, byte by2, int n, int n2) {
        this(Message.makeGuid(), by, by2, 0, n, n2);
    }

    protected Message(byte[] byArray, byte by, byte by2, byte by3, int n) {
        this(byArray, by, by2, by3, n, -1);
    }

    protected Message(byte[] byArray, byte by, byte by2, byte by3, int n, int n2) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + byArray.length);
        }
        this.guid = byArray;
        this.func = by;
        this.ttl = by2;
        this.hops = by3;
        this.length = n;
        this.network = n2;
    }

    public static Message read(InputStream inputStream) throws BadPacketException, IOException {
        return Message.read(inputStream, new byte[23], -1, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte by) throws BadPacketException, IOException {
        return Message.read(inputStream, new byte[23], -1, by);
    }

    public static Message read(InputStream inputStream, int n) throws BadPacketException, IOException {
        return Message.read(inputStream, new byte[23], n, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte[] byArray, byte by) throws BadPacketException, IOException {
        return Message.read(inputStream, byArray, -1, by);
    }

    public static Message read(InputStream inputStream, int n, byte[] byArray) throws BadPacketException, IOException {
        return Message.read(inputStream, byArray, n, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte[] byArray, int n, byte by) throws BadPacketException, IOException {
        int n2 = 0;
        while (n2 < 23) {
            int n3;
            try {
                n3 = inputStream.read(byArray, n2, 23 - n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n2 == 0) {
                    return null;
                }
                throw interruptedIOException;
            }
            if (n3 == -1) {
                ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                throw new IOException("Connection closed.");
            }
            n2 += n3;
        }
        n2 = ByteOrder.leb2int(byArray, 19);
        if (n2 < 0 || n2 > MessageSettings.MAX_LENGTH.getValue()) {
            ReceivedErrorStat.INVALID_LENGTH.incrementStat();
            throw new IOException("Unreasonable message length: " + n2);
        }
        byte[] byArray2 = null;
        if (n2 != 0) {
            byArray2 = new byte[n2];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = inputStream.read(byArray2, n4, n2 - n4);
                if (n5 == -1) {
                    ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                    throw new IOException("Connection closed.");
                }
                n4 += n5;
            }
        } else {
            byArray2 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        return Message.createMessage(byArray, byArray2, by, n);
    }

    public static Message createMessage(byte[] byArray, byte[] byArray2, byte by, int n) throws BadPacketException, IOException {
        if (byArray.length < 19) {
            throw new IllegalArgumentException("header must be >= 19 bytes.");
        }
        byte by2 = byArray[16];
        byte by3 = byArray[17];
        byte by4 = byArray[18];
        int n2 = 14;
        if (by4 < 0) {
            ReceivedErrorStat.INVALID_HOPS.incrementStat();
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (by3 < 0) {
            ReceivedErrorStat.INVALID_TTL.incrementStat();
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (by4 > by && by2 != -127 && by2 != 1) {
            ReceivedErrorStat.HOPS_EXCEED_SOFT_MAX.incrementStat();
            throw new BadPacketException("func: " + by2 + ", ttl: " + by3 + ", hops: " + by4);
        }
        if (by3 + by4 > n2) {
            ReceivedErrorStat.HOPS_AND_TTL_OVER_HARD_MAX.incrementStat();
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (by3 + by4 > by && by2 != -127 && by2 != 1) {
            by3 = (byte)(by - by4);
            Assert.that(by3 >= 0);
        }
        byte[] byArray3 = new byte[16];
        int n3 = 0;
        while (n3 < 16) {
            byArray3[n3] = byArray[n3];
            ++n3;
        }
        n3 = byArray2.length;
        switch (by2) {
            case 0: {
                if (n3 > 0) {
                    return new PingRequest(byArray3, by3, by4, byArray2);
                }
                return new PingRequest(byArray3, by3, by4);
            }
            case 1: {
                return PingReply.createFromNetwork(byArray3, by3, by4, byArray2);
            }
            case -128: {
                if (n3 < 3) break;
                return QueryRequest.createNetworkQuery(byArray3, by3, by4, byArray2, n);
            }
            case -127: {
                if (n3 < 26) break;
                return new QueryReply(byArray3, by3, by4, byArray2, n);
            }
            case 64: {
                return new PushRequest(byArray3, by3, by4, byArray2, n);
            }
            case 48: {
                return RouteTableMessage.read(byArray3, by3, by4, byArray2);
            }
            case 49: {
                return VendorMessage.deriveVendorMessage(byArray3, by3, by4, byArray2, n);
            }
            case 50: {
                return VendorMessage.deriveVendorMessage(byArray3, by3, by4, byArray2, n);
            }
            case 65: {
                return UDPConnectionMessage.createMessage(byArray3, by3, by4, byArray2);
            }
        }
        ReceivedErrorStat.INVALID_CODE.incrementStat();
        throw new BadPacketException("Unrecognized function code: " + by2);
    }

    public void writeQuickly(OutputStream outputStream) throws IOException {
        outputStream.write(this.guid, 0, 16);
        outputStream.write(this.func);
        outputStream.write(this.ttl);
        outputStream.write(this.hops);
        ByteOrder.int2leb(this.length, outputStream);
        this.writePayload(outputStream);
    }

    public void write(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < 16) {
            byArray[n] = this.guid[n];
            ++n;
        }
        byArray[16] = this.func;
        byArray[17] = this.ttl;
        byArray[18] = this.hops;
        ByteOrder.int2leb(this.length, byArray, 19);
        outputStream.write(byArray);
        this.writePayload(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, new byte[23]);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    protected boolean writeGemExtension(OutputStream outputStream, boolean bl, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return bl;
        }
        if (bl) {
            outputStream.write(28);
        }
        outputStream.write(byArray);
        return true;
    }

    protected boolean writeGemExtension(OutputStream outputStream, boolean bl, String string) throws IOException {
        if (string != null) {
            return this.writeGemExtension(outputStream, bl, string.getBytes());
        }
        return this.writeGemExtension(outputStream, bl, new byte[0]);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean writeGemExtensions(OutputStream var1_1, boolean var2_2, Iterator var3_3) throws IOException {
        if (var3_3 != null) ** GOTO lbl4
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.writeGemExtension(var1_1, var2_2, var3_3.next().toString());
lbl4:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl5:
        // 1 sources

        return var2_2;
    }

    protected byte[] readNullTerminatedBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (inputStream.available() > 0 && (n = inputStream.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getNetwork() {
        return this.network;
    }

    public boolean isMulticast() {
        return this.network == 3;
    }

    public boolean isUDP() {
        return this.network == 2;
    }

    public boolean isTCP() {
        return this.network == 1;
    }

    public boolean isUnknownNetwork() {
        return this.network == -1;
    }

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        this.ttl = by;
    }

    protected void setGUID(GUID gUID) {
        this.guid = gUID.bytes();
    }

    public void setHops(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException("invalid hops: " + by);
        }
        this.hops = by;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    protected void updateLength(int n) {
        this.length = n;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public abstract Message stripExtendedPayload();

    public int compareTo(Object object) {
        Message message = (Message)object;
        return message.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", hops=" + this.hops + ", priority=" + this.getPriority() + "}";
    }

    public abstract void recordDrop();
}

