/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class TCPConnectBackRedirect
extends VendorMessage {
    public static final int VERSION = 1;
    private final int _port;
    private final InetAddress _addr;

    TCPConnectBackRedirect(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 7, n, byArray2);
        if (this.getVersion() == 1 && this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + byArray2.length);
        }
        byte[] byArray3 = new byte[4];
        System.arraycopy(this.getPayload(), 0, byArray3, 0, byArray3.length);
        if (!NetworkUtils.isValidAddress(byArray3)) {
            throw new BadPacketException("Bad Host!!");
        }
        try {
            this._addr = InetAddress.getByName(NetworkUtils.ip2string(byArray3));
        }
        catch (UnknownHostException unknownHostException) {
            throw new BadPacketException("Bad InetAddress!!");
        }
        this._port = ByteOrder.ushort2int(ByteOrder.leb2short(this.getPayload(), byArray3.length));
        if (!NetworkUtils.isValidPort(this._port)) {
            throw new BadPacketException("invalid port");
        }
    }

    public TCPConnectBackRedirect(InetAddress inetAddress, int n) {
        super(F_LIME_VENDOR_ID, 7, 1, TCPConnectBackRedirect.derivePayload(inetAddress, n));
        this._addr = inetAddress;
        this._port = n;
    }

    public InetAddress getConnectBackAddress() {
        return this._addr;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    private static byte[] derivePayload(InetAddress inetAddress, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = inetAddress.getAddress();
            if (!NetworkUtils.isValidAddress(byArray)) {
                throw new IllegalArgumentException("invalid ip: " + inetAddress);
            }
            byteArrayOutputStream.write(byArray);
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

