/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final Log LOG;
    private static final Object BUSH;
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    private static boolean dirty;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.tigertree.TigerTreeCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        BUSH = new Object();
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
        dirty = false;
    }

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        Object v = TREE_MAP.get(fileDesc.getSHA1Urn());
        if (v != null && v.equals(BUSH)) {
            return null;
        }
        HashTree hashTree = (HashTree)v;
        if (hashTree == null) {
            TREE_MAP.put(fileDesc.getSHA1Urn(), BUSH);
            QUEUE.add(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    public synchronized HashTree getHashTree(URN uRN) {
        Object v = TREE_MAP.get(uRN);
        if (v != null && v.equals(BUSH)) {
            return null;
        }
        return (HashTree)v;
    }

    public synchronized void purgeTree(URN uRN) {
        if (TREE_MAP.remove(uRN) != null) {
            dirty = true;
        }
    }

    public static synchronized void addHashTree(URN uRN, HashTree hashTree) {
        if (hashTree.isGoodDepth()) {
            TREE_MAP.put(uRN, hashTree);
            dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        Map map2;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CACHE_FILE)));
                Map map = (Map)objectInputStream.readObject();
                if (map != null) {
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (k instanceof URN && v instanceof HashTree) continue;
                        iterator.remove();
                    }
                }
                map2 = map;
                Object var6_9 = null;
                if (objectInputStream == null) return map2;
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Can't read tiger trees", throwable);
                HashMap hashMap = new HashMap();
                Object var6_10 = null;
                if (objectInputStream == null) return hashMap;
                try {
                    objectInputStream.close();
                    return hashMap;
                }
                catch (IOException iOException) {}
                return hashMap;
            }
        }
        catch (Throwable throwable2) {
            Object var6_11 = null;
            if (objectInputStream == null) throw throwable2;
            try {}
            catch (IOException iOException) {
                throw throwable2;
            }
            objectInputStream.close();
            throw throwable2;
        }
        try {}
        catch (IOException iOException) {}
        objectInputStream.close();
        return map2;
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (map.get(uRN) != BUSH && (RouterService.getFileManager().getFileDescForUrn(uRN) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map.size() / 200))) continue;
            iterator.remove();
            dirty = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void persistCache() {
        block9: {
            if (!dirty) {
                return;
            }
            TigerTreeCache.removeOldEntries(TREE_MAP);
            ObjectOutputStream objectOutputStream = null;
            try {
                try {
                    objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CACHE_FILE)));
                    objectOutputStream.writeObject(TREE_MAP);
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (objectOutputStream == null) throw throwable;
                try {
                    objectOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (objectOutputStream == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            objectOutputStream.close();
        }
        dirty = true;
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(uRN) == null) {
                    HashTree hashTree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

