/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor {
    private static final Log LOG;
    private static UDPMultiplexor _instance;
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile WeakReference[] _connections = new WeakReference[256];
    private int _lastConnectionID = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.udpconnect.UDPMultiplexor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _instance = new UDPMultiplexor();
    }

    public static UDPMultiplexor instance() {
        return _instance;
    }

    private UDPMultiplexor() {
    }

    public boolean isConnectedTo(InetAddress inetAddress) {
        WeakReference[] weakReferenceArray = this._connections;
        if (this._lastConnectionID == 0) {
            return false;
        }
        int n = 0;
        while (n < weakReferenceArray.length) {
            UDPConnectionProcessor uDPConnectionProcessor;
            WeakReference weakReference = weakReferenceArray[n];
            if (weakReference != null && (uDPConnectionProcessor = (UDPConnectionProcessor)weakReference.get()) != null && inetAddress.equals(uDPConnectionProcessor.getInetAddress())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized byte register(UDPConnectionProcessor uDPConnectionProcessor) {
        WeakReference[] weakReferenceArray = new WeakReference[this._connections.length];
        int n = 0;
        while (n < this._connections.length) {
            weakReferenceArray[n] = this._connections[n];
            ++n;
        }
        n = 1;
        while (n <= weakReferenceArray.length) {
            int n2 = (this._lastConnectionID + n) % 256;
            if (n2 != 0 && (weakReferenceArray[n2] == null || weakReferenceArray[n2].get() == null)) {
                this._lastConnectionID = n2;
                weakReferenceArray[n2] = new WeakReference<UDPConnectionProcessor>(uDPConnectionProcessor);
                this._connections = weakReferenceArray;
                return (byte)n2;
            }
            ++n;
        }
        return 0;
    }

    public synchronized void unregister(UDPConnectionProcessor uDPConnectionProcessor) {
        int n = uDPConnectionProcessor.getConnectionID() & 0xFF;
        WeakReference[] weakReferenceArray = new WeakReference[this._connections.length];
        int n2 = 0;
        while (n2 < this._connections.length) {
            weakReferenceArray[n2] = this._connections[n2];
            ++n2;
        }
        if (weakReferenceArray[n] != null && weakReferenceArray[n].get() == uDPConnectionProcessor) {
            weakReferenceArray[n].clear();
            weakReferenceArray[n] = null;
        }
        this._connections = weakReferenceArray;
    }

    public void routeMessage(UDPConnectionMessage uDPConnectionMessage, InetAddress inetAddress, int n) {
        WeakReference[] weakReferenceArray = this._connections;
        int n2 = uDPConnectionMessage.getConnectionID() & 0xFF;
        if (n2 == 0 && uDPConnectionMessage instanceof SynMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiving SynMessage :" + uDPConnectionMessage));
            }
            int n3 = 1;
            while (n3 < weakReferenceArray.length) {
                UDPConnectionProcessor uDPConnectionProcessor = weakReferenceArray[n3] == null ? null : (UDPConnectionProcessor)weakReferenceArray[n3].get();
                if (uDPConnectionProcessor != null && uDPConnectionProcessor.isConnecting() && uDPConnectionProcessor.matchAddress(inetAddress, n)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("routeMessage to conn:" + n3 + " Syn:" + uDPConnectionMessage));
                    }
                    uDPConnectionProcessor.handleMessage(uDPConnectionMessage);
                    break;
                }
                ++n3;
            }
        } else {
            UDPConnectionProcessor uDPConnectionProcessor = weakReferenceArray[n2] == null ? null : (UDPConnectionProcessor)weakReferenceArray[n2].get();
            if (uDPConnectionProcessor != null && uDPConnectionProcessor.matchAddress(inetAddress, n)) {
                uDPConnectionProcessor.handleMessage(uDPConnectionMessage);
            }
        }
    }
}

