/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortForSelf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class NetworkUtils {
    private static final byte[] INVALID_ADDRESSES_BYTE;
    private static final int[][] PRIVATE_ADDRESSES_BYTE;
    private static final byte LOCAL_ADDRESS_BYTE = 127;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        INVALID_ADDRESSES_BYTE = byArray;
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[2];
        nArray[0] = -16777216;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-16777216, 0x7F000000};
        nArrayArray[2] = new int[]{-16777216, -16777216};
        nArrayArray[3] = new int[]{-16777216, 0xA000000};
        nArrayArray[4] = new int[]{-1048576, -1408237568};
        nArrayArray[5] = new int[]{-65536, -1442971648};
        nArrayArray[6] = new int[]{-65536, -1062731776};
        PRIVATE_ADDRESSES_BYTE = nArrayArray;
    }

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] byArray, int n) {
        return NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidAddressAndPort(String string, int n) {
        return NetworkUtils.isValidAddress(string) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidPort(int n) {
        if ((n & 0xFFFF0000) != 0) {
            return false;
        }
        return n != 0;
    }

    public static boolean isValidAddress(byte[] byArray) {
        return byArray[0] != INVALID_ADDRESSES_BYTE[0] && byArray[0] != INVALID_ADDRESSES_BYTE[1];
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return NetworkUtils.isValidAddress(inetAddress.getAddress());
    }

    public static boolean isValidAddress(String string) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress inetAddress) {
        try {
            if (inetAddress.getAddress()[0] == 127) {
                return true;
            }
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            return Arrays.equals(inetAddress2.getAddress(), inetAddress.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0];
    }

    public static boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1];
    }

    public static boolean isVeryCloseIP(byte[] byArray) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), byArray);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] byArray) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16;
        int n2 = 0;
        while (n2 < 7) {
            if ((n & PRIVATE_ADDRESSES_BYTE[n2][0]) == PRIVATE_ADDRESSES_BYTE[n2][1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPrivateAddress(InetAddress inetAddress) {
        return NetworkUtils.isPrivateAddress(inetAddress.getAddress());
    }

    public static boolean isPrivateAddress(String string) {
        try {
            return NetworkUtils.isPrivateAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public static final String ip2string(byte[] byArray) {
        return NetworkUtils.ip2string(byArray, 0);
    }

    public static final String ip2string(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 1]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 2]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 3]));
        return stringBuffer.toString();
    }

    public static boolean isMe(String string, int n) {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (IOException iOException) {
            return false;
        }
        return NetworkUtils.isMe(byArray, n);
    }

    public static boolean isMe(byte[] byArray, int n) {
        if (byArray[0] == 127) {
            return n == RouterService.getPort();
        }
        byte[] byArray2 = RouterService.getAddress();
        return n == RouterService.getPort() && Arrays.equals(byArray, byArray2);
    }

    public static boolean isMe(IpPort ipPort) {
        if (ipPort == IpPortForSelf.instance()) {
            return true;
        }
        return NetworkUtils.isMe(ipPort.getInetAddress().getAddress(), ipPort.getPort());
    }

    public static boolean isLocalHost(Socket socket) {
        String string = socket.getInetAddress().getHostAddress();
        return "127.0.0.1".equals(string);
    }

    public static byte[] packIpPorts(Collection collection) {
        byte[] byArray = new byte[collection.size() * 6];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IpPort ipPort = (IpPort)iterator.next();
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            int n2 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteOrder.short2leb((short)n2, byArray, n += 4);
            n += 2;
        }
        return byArray;
    }

    public static List unpackIps(byte[] byArray) throws BadPacketException {
        if (byArray.length % 6 != 0) {
            throw new BadPacketException("invalid size");
        }
        int n = byArray.length / 6;
        ArrayList<QueryReply.IPPortCombo> arrayList = new ArrayList<QueryReply.IPPortCombo>(n);
        byte[] byArray2 = new byte[6];
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(byArray, n2 * 6, byArray2, 0, 6);
            arrayList.add(QueryReply.IPPortCombo.getCombo(byArray2));
            ++n2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List unpackPushEPs(InputStream inputStream) throws BadPacketException, IOException {
        LinkedList<PushEndpoint> linkedList = new LinkedList<PushEndpoint>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (dataInputStream.available() > 0) {
            linkedList.add(PushEndpoint.fromBytes(dataInputStream));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        String string = NetworkUtils.ip2string(byArray);
        return InetAddress.getByName(string);
    }

    public static boolean isValidExternalIpPort(IpPort ipPort) {
        if (ipPort == null) {
            return false;
        }
        byte[] byArray = ipPort.getInetAddress().getAddress();
        return NetworkUtils.isValidAddress(byArray) && !NetworkUtils.isPrivateAddress(byArray) && NetworkUtils.isValidPort(ipPort.getPort());
    }
}

