/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Random;

public final class UUID {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte INDEX_TYPE = 6;
    private static final byte INDEX_VARIATION = 8;
    private static final byte TYPE_RANDOM_BASED = 4;
    private static final Random RANDOM = new Random();
    private final String uuid;

    private UUID(byte[] byArray) {
        this.uuid = UUID.genString(byArray);
    }

    public UUID(String string) {
        this.uuid = string.toLowerCase();
        if (string.length() != 36) {
            throw new IllegalArgumentException();
        }
    }

    public static UUID nextUUID() {
        byte[] byArray = new byte[16];
        RANDOM.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        return new UUID(byArray);
    }

    private static String genString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = 0;
        while (n < 16) {
            if (n == 4 || n == 6 || n == 8 || n == 10) {
                stringBuffer.append('-');
            }
            int n2 = byArray[n] & 0xFF;
            stringBuffer.append(HEX[n2 >> 4]);
            stringBuffer.append(HEX[n2 & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.uuid;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            return this.uuid.equals(uUID.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

