/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLSchema {
    private final List _canonicalizedFields;
    private final String _schemaURI;
    private final String _description;
    private final String _rootXMLName;

    public LimeXMLSchema(File file) throws IOException {
        this(LimeXMLUtils.getInputSource(file));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        Document document = this.getDocument(inputSource);
        this._canonicalizedFields = new LimeXMLSchemaFieldExtractor().getFields(document);
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
        this._rootXMLName = LimeXMLSchema.getRootXMLName(document);
        this._description = LimeXMLSchema.getDisplayString(this._schemaURI);
    }

    private Document getDocument(InputSource inputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        documentBuilder.setEntityResolver(new Resolver(inputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        return document;
    }

    private static String retrieveSchemaURI(Document document) {
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("targetNamespace");
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    private static String getRootXMLName(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("element");
        if (nodeList.getLength() == 0) {
            return "";
        }
        Node node = nodeList.item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    private void printNode(Node node) {
        if (node.getNodeType() == 1) {
            System.out.print("node = " + node.getNodeName() + " ");
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("name");
            if (node2 != null) {
                System.out.print("" + node2);
            }
            System.out.println("");
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = nodeList.item(n2);
                this.printNode(node3);
                ++n2;
            }
        }
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public String getRootXMLName() {
        return this._rootXMLName;
    }

    public String getInnerXMLName() {
        return this._description;
    }

    public List getCanonicalizedFields() {
        return Collections.unmodifiableList(this._canonicalizedFields);
    }

    public List getEnumerationFields() {
        LinkedList<SchemaFieldInfo> linkedList = new LinkedList<SchemaFieldInfo>();
        Iterator iterator = this._canonicalizedFields.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator.next();
            if (schemaFieldInfo.getEnumerationList() == null) continue;
            linkedList.add(schemaFieldInfo);
        }
        return linkedList;
    }

    public String[] getCanonicalizedFieldNames() {
        List list = this.getCanonicalizedFields();
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((SchemaFieldInfo)iterator.next()).getCanonicalizedFieldName();
            ++n;
        }
        return stringArray;
    }

    public String getDescription() {
        return this._description;
    }

    public static String getDisplayString(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        String string2 = n == -1 || n2 == -1 ? string : string.substring(n + 1, n2);
        return string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this._schemaURI.equals(((LimeXMLSchema)object)._schemaURI);
    }

    public int hashCode() {
        return this._schemaURI.hashCode();
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource inputSource) {
            this.schema = inputSource;
        }

        public InputSource resolveEntity(String string, String string2) {
            return this.schema;
        }
    }
}

