/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageCallback;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEvent;

public class AqEventHandler
implements ActivityCallback,
ErrorCallback,
MessageCallback {
    protected static volatile Map hosts = new HashMap();
    protected static volatile Map queriesToIndices = new HashMap();
    protected static volatile Map indicesToQueries = new HashMap();
    protected static volatile Map queryGUIDs = new HashMap();
    protected static volatile Map responses = new HashMap();
    protected static volatile Map alts = new HashMap();
    protected static volatile List downloads = new LinkedList();
    protected static volatile List uploads = new LinkedList();

    public void addressStateChanged() {
    }

    public void connectionInitializing(Connection connection) {
    }

    public void connectionInitialized(Connection connection) {
        AqEvent.signalEvent(2, connection);
    }

    public void connectionClosed(Connection connection) {
        AqEvent.signalEvent(3, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQueryResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set set) {
        Map map;
        if (SearchSettings.hideJunk() && remoteFileDesc.getSpamRating() > SearchSettings.FILTER_SPAM_RESULTS.getValue()) {
            return;
        }
        if (hostData.isBrowseHostEnabled()) {
            map = hosts;
            synchronized (map) {
                hosts.put(String.valueOf(hostData.getIP()) + ":" + hostData.getPort(), hostData);
            }
        }
        map = queriesToIndices;
        synchronized (map) {
            if (queriesToIndices.containsKey(new GUID(hostData.getMessageGUID()))) {
                AqEvent.signalEvent(1, remoteFileDesc, hostData, set);
            }
        }
    }

    public void handleQueryString(String string) {
    }

    public void addUpload(Uploader uploader) {
        AqEvent.signalEvent(9, uploader);
        LinkedList<Uploader> linkedList = new LinkedList<Uploader>(uploads);
        linkedList.add(uploader);
        uploads = Collections.unmodifiableList(linkedList);
    }

    public void removeUpload(Uploader uploader) {
        LinkedList linkedList = new LinkedList(uploads);
        linkedList.remove(uploader);
        uploads = Collections.unmodifiableList(linkedList);
        AqEvent.signalEvent(11, uploader);
        AqEvent.signalEvent(10, uploader);
    }

    public void browseHostFailed(GUID gUID) {
    }

    public void fileManagerLoading() {
    }

    public void fileManagerLoaded() {
    }

    public boolean warnAboutSharingSensitiveDirectory(File file) {
        return false;
    }

    public void handleFileEvent(FileManagerEvent fileManagerEvent) {
        if (fileManagerEvent.isAddEvent()) {
            FileDesc[] fileDescArray = fileManagerEvent.getFileDescs();
            int n = 0;
            while (n < fileDescArray.length) {
                AqEvent.signalEvent(13, fileDescArray[n]);
                ++n;
            }
        }
    }

    public void handleSharedFileUpdate(File file) {
    }

    public void setAnnotateEnabled(boolean bl) {
    }

    public void uploadsComplete() {
    }

    public void restoreApplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryAlive(GUID gUID) {
        Map map = queriesToIndices;
        synchronized (map) {
            return queriesToIndices.containsKey(gUID);
        }
    }

    public void componentLoading(String string) {
        System.err.println(string);
    }

    public void acceptedIncomingChanged(boolean bl) {
    }

    public void addDownload(Downloader downloader) {
        AqEvent.signalEvent(5, downloader);
        LinkedList<Downloader> linkedList = new LinkedList<Downloader>(downloads);
        linkedList.add(downloader);
        downloads = Collections.unmodifiableList(linkedList);
    }

    public void removeDownload(Downloader downloader) {
        LinkedList linkedList = new LinkedList(downloads);
        linkedList.remove(downloader);
        downloads = Collections.unmodifiableList(linkedList);
        AqEvent.signalEvent(7, downloader);
        AqEvent.signalEvent(6, downloader);
    }

    public void downloadsComplete() {
    }

    public void showDownloads() {
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        downloader.discardCorruptDownload(false);
    }

    public String getHostValue(String string) {
        return null;
    }

    public void error(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void error(Throwable throwable, String string) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    public void showError(String string) {
        System.err.println(string);
    }

    public void showError(String string, BooleanSetting booleanSetting) {
        System.err.println(String.valueOf(string) + ": " + booleanSetting);
    }

    public void showError(String string, String string2) {
        System.err.println(String.valueOf(string) + ": " + string2);
    }

    public void showError(String string, String string2, BooleanSetting booleanSetting) {
        System.err.println(String.valueOf(string) + ": " + string2 + ": " + booleanSetting);
    }

    public void showMessage(String string) {
        System.err.println(string);
    }

    public void showMessage(String string, BooleanSetting booleanSetting) {
        System.err.println(String.valueOf(string) + ": " + booleanSetting);
    }
}

