/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.K;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.sign.Signature;

public class DHKey
extends K
implements Key,
CipherKey,
SignatureKey {
    private BigInteger x;
    private BigInteger y;
    private BigInteger g;
    private BigInteger m;

    public static DHKey parseCDS(String string) throws InvalidCDSException {
        DHKey dHKey = null;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as first argument to DHKey()");
            }
            BigInteger bigInteger = new BigInteger(streamTokenizer.sval, 16);
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + bigInteger.toString(16));
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as second argument to DHKey()");
            }
            BigInteger bigInteger2 = new BigInteger(streamTokenizer.sval, 16);
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + bigInteger2.toString(16));
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as third argument to DHKey()");
            }
            BigInteger bigInteger3 = new BigInteger(streamTokenizer.sval, 16);
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + bigInteger3.toString(16));
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("\"pub\" or \"pri\" expected as second argument to DHKey()");
            }
            String string2 = streamTokenizer.sval;
            if (string2.equals("pri")) {
                dHKey = new DHKey(bigInteger, bigInteger2, bigInteger3, true);
            } else if (string2.equals("pub")) {
                dHKey = new DHKey(bigInteger, bigInteger2, bigInteger3, false);
            } else {
                throw new InvalidCDSException("\"pub\" or \"pri\" expected as second argument to DHKey()");
            }
            if (streamTokenizer.nextToken() != -1) {
                throw new InvalidCDSException("no more parameters expected in DHKey() after " + string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dHKey;
    }

    public static BigInteger getModulus(int n) {
        if ((n = n < 256 ? 256 : (n + 7) / 8 * 8) == 256) {
            return TWO.pow(n).subtract(BigInteger.valueOf(36113L));
        }
        if (n == 512) {
            return TWO.pow(n).subtract(BigInteger.valueOf(38117L));
        }
        if (n == 1024) {
            return TWO.pow(n).subtract(BigInteger.valueOf(1093337L));
        }
        if (n == 2048) {
            return TWO.pow(n).subtract(BigInteger.valueOf(1942289L));
        }
        BigInteger bigInteger = TWO.pow(n).subtract(ONE);
        BigInteger bigInteger2 = bigInteger.divide(TWO);
        while (!(bigInteger.isProbablePrime(2) && bigInteger2.isProbablePrime(2) && bigInteger.isProbablePrime(4) && bigInteger2.isProbablePrime(4) && bigInteger.isProbablePrime(8) && bigInteger2.isProbablePrime(8) && bigInteger.isProbablePrime(primeCertainty - 14) && bigInteger2.isProbablePrime(primeCertainty - 14))) {
            bigInteger = bigInteger.subtract(FOUR);
            bigInteger2 = bigInteger.divide(TWO);
        }
        return bigInteger;
    }

    public static BigInteger getGenerator(BigInteger bigInteger) {
        BigInteger bigInteger2 = TWO;
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        while (!bigInteger3.gcd(bigInteger2).equals(ONE)) {
            bigInteger2 = bigInteger2.add(ONE);
        }
        return bigInteger2;
    }

    public static KeyPair createKeys(int n) {
        DHKey dHKey = new DHKey(n);
        return new KeyPair(dHKey.getPublic(), dHKey);
    }

    public int getSize() {
        return this.m.bitLength();
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public boolean isPrivate() {
        return this.x != null;
    }

    public DHKey getPublic() {
        return this.x == null ? this : new DHKey(this.y, this.g, this.m, false);
    }

    public BigInteger getKey() {
        return this.x != null ? this.x : this.y;
    }

    public BigInteger getM() {
        return this.m;
    }

    public BigInteger getG() {
        return this.g;
    }

    protected Fingerprint calcFingerprint(boolean bl, String string) throws InvalidCDSException {
        HashState hashState = HashState.create(string);
        hashState.update(this.getPublic().getKey().toByteArray());
        hashState.update(this.getPublic().getM().toByteArray());
        if (bl == (this.x == null)) {
            hashState.update("pri");
        } else {
            hashState.update("pub");
        }
        return hashState.calculate();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DHKey dHKey = (DHKey)object;
        return dHKey.getKey().equals(this.getKey()) && dHKey.getM().equals(this.getM()) && dHKey.getG().equals(this.getG());
    }

    public boolean matches(Key key) {
        if (key instanceof DHKey) {
            return this.getPublic().equals(((DHKey)key).getPublic());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DHKey(");
        if (this.x == null) {
            stringBuffer.append(this.y.toString(16));
        } else {
            stringBuffer.append(this.x.toString(16));
        }
        stringBuffer.append(',');
        stringBuffer.append(this.g.toString(16));
        stringBuffer.append(',');
        stringBuffer.append(this.m.toString(16));
        stringBuffer.append(this.x == null ? ",pub)" : ",pri)");
        return stringBuffer.toString();
    }

    public int plainBlockSize() {
        return (this.m.bitLength() - 1) / 8;
    }

    public int cipherBlockSize() {
        return 2 * this.signBlockSize() + 2;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.m.subtract(ONE);
        while ((bigInteger = new BigInteger(this.m.bitLength(), random)).compareTo(this.m) >= 0 || !bigInteger.gcd(bigInteger2).equals(ONE)) {
        }
        int n4 = this.plainBlockSize();
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n, byArray3, 0, this.plainBlockSize());
        BigInteger bigInteger3 = new BigInteger(1, byArray3);
        BigInteger bigInteger4 = this.g.modPow(bigInteger, this.m);
        BigInteger bigInteger5 = this.y.modPow(bigInteger, this.m).multiply(bigInteger3).mod(this.m);
        int n5 = n4 + 1;
        byArray3 = bigInteger4.toByteArray();
        if (byArray3.length >= n5) {
            System.arraycopy(byArray3, byArray3.length - n5, byArray2, n2, n5);
        } else {
            n3 = n2;
            while (n3 < n2 + n5 - byArray3.length) {
                byArray2[n3] = 0;
                ++n3;
            }
            System.arraycopy(byArray3, 0, byArray2, n2 + n5 - byArray3.length, byArray3.length);
        }
        byArray3 = bigInteger5.toByteArray();
        if (byArray3.length >= n5) {
            System.arraycopy(byArray3, byArray3.length - n5, byArray2, n2 + n5, n5);
        } else {
            n3 = n2 + n5;
            while (n3 < n2 + 2 * n5 - byArray3.length) {
                byArray2[n3] = 0;
                ++n3;
            }
            System.arraycopy(byArray3, 0, byArray2, n2 + 2 * n5 - byArray3.length, byArray3.length);
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (this.m.bitLength() + 7) / 8;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n, byArray3, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        System.arraycopy(byArray, n + n3, byArray3, 0, n3);
        BigInteger bigInteger2 = new BigInteger(1, byArray3);
        BigInteger bigInteger3 = bigInteger.modPow(this.x.negate(), this.m).multiply(bigInteger2).mod(this.m);
        int n4 = n3 - 1;
        byArray3 = bigInteger3.toByteArray();
        if (byArray3.length >= n4) {
            System.arraycopy(byArray3, byArray3.length - n4, byArray2, n2, n4);
        } else {
            int n5 = n2;
            while (n5 < n2 + n4 - byArray3.length) {
                byArray2[n5] = 0;
                ++n5;
            }
            System.arraycopy(byArray3, 0, byArray2, n2 + n4 - byArray3.length, byArray3.length);
        }
    }

    public int signBlockSize() {
        return (this.m.bitLength() - 1) / 8;
    }

    public int signatureSize() {
        return 2 * this.signBlockSize() + 2;
    }

    public Signature sign(Fingerprint fingerprint) throws KeyException {
        BigInteger bigInteger;
        if (this.x == null) {
            throw new KeyException("Signatures can only be verified with public ElGamal keys.");
        }
        BigInteger bigInteger2 = this.m.subtract(ONE);
        while ((bigInteger = new BigInteger(this.m.bitLength(), random)).compareTo(this.m) >= 0 || !bigInteger.gcd(bigInteger2).equals(ONE)) {
        }
        BigInteger bigInteger3 = new BigInteger(1, fingerprint.getBytes());
        BigInteger bigInteger4 = this.g.modPow(bigInteger, this.m);
        BigInteger bigInteger5 = bigInteger.modInverse(bigInteger2).multiply(bigInteger3.subtract(this.x.multiply(bigInteger4))).mod(bigInteger2);
        int n = (this.m.bitLength() + 7) / 8;
        byte[] byArray = new byte[2 * n];
        byte[] byArray2 = bigInteger4.toByteArray();
        if (byArray2.length >= n) {
            System.arraycopy(byArray2, byArray2.length - n, byArray, 0, n);
        } else {
            System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray2.length);
        }
        byArray2 = bigInteger5.toByteArray();
        if (byArray2.length >= n) {
            System.arraycopy(byArray2, byArray2.length - n, byArray, n, n);
        } else {
            System.arraycopy(byArray2, 0, byArray, 2 * n - byArray2.length, byArray2.length);
        }
        return new Signature(byArray, fingerprint.getName(), this.matchFingerprint());
    }

    public boolean verify(Signature signature, Fingerprint fingerprint) throws KeyException {
        if (this.x != null) {
            throw new KeyException("Signatures can only be verified with public ElGamal keys.");
        }
        int n = (this.m.bitLength() + 7) / 8;
        byte[] byArray = signature.getBytes();
        if (byArray.length != 2 * n) {
            return false;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        System.arraycopy(byArray, n, byArray2, 0, n);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger bigInteger3 = new BigInteger(1, fingerprint.getBytes());
        BigInteger bigInteger4 = this.y.modPow(bigInteger, this.m).multiply(bigInteger.modPow(bigInteger2, this.m)).mod(this.m);
        BigInteger bigInteger5 = this.g.modPow(bigInteger3, this.m);
        return bigInteger4.equals(bigInteger5);
    }

    public DHKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, boolean bl) {
        this.g = bigInteger2;
        this.m = bigInteger3;
        if (bl) {
            this.x = bigInteger;
            this.y = bigInteger2.modPow(bigInteger, bigInteger3);
        } else {
            this.y = bigInteger;
        }
    }

    public DHKey(int n) {
        n = n < 256 ? 256 : (n + 7) / 8 * 8;
        this.m = DHKey.getModulus(n);
        this.g = DHKey.getGenerator(this.m);
        do {
            this.x = new BigInteger(n, random);
        } while (this.x.compareTo(this.m) >= 0);
        this.y = this.g.modPow(this.x, this.m);
    }
}

