/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryUnicaster {
    private static final Log LOG;
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 30;
    public static final long ONE_HOUR = 3600000L;
    private static final QueryUnicaster _instance;
    private Thread _querier = null;
    private boolean _shouldRun = true;
    private Map _queries = new Hashtable();
    private Map _querySets;
    private LinkedList _queryHosts = new LinkedList();
    private Map _queryKeys = new Hashtable();
    private Buffer _pingList = new Buffer(25);
    private List _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private boolean _initialized = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.QueryUnicaster");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _instance = new QueryUnicaster();
    }

    public static QueryUnicaster instance() {
        return _instance;
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnicastEndpoints() {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            LOG.debug((Object)"QueryUnicaster.getUnicastEndpoints(): obtained lock.");
            int n = this._queryHosts.size();
            if (n > 0) {
                int n2 = n > 10 ? 10 : n;
                int n3 = 0;
                while (n3 < n2) {
                    arrayList.add(this._queryHosts.get(n3));
                    ++n3;
                }
            }
            LOG.debug((Object)"QueryUnicaster.getUnicastEndpoints(): releasing lock.");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.isEmpty()) {
                return null;
            }
            return (GUESSEndpoint)this._queryHosts.getFirst();
        }
    }

    private QueryUnicaster() {
        this._querySets = new Hashtable();
        this._qGuidsToRemove = new Vector();
        this._querier = new ManagedThread(){

            public void managedRun() {
                try {
                    QueryUnicaster.this.queryLoop();
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        };
        this._querier.setName("QueryUnicaster");
        this._querier.setDaemon(true);
    }

    public synchronized void start() {
        if (!this._initialized) {
            this._querier.start();
            QueryKeyExpirer queryKeyExpirer = new QueryKeyExpirer();
            RouterService.schedule(queryKeyExpirer, 0L, 10800000L);
            this._initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLoop() {
        UDPService uDPService = UDPService.instance();
        while (this._shouldRun) {
            try {
                Object object;
                this.waitForQueries();
                GUESSEndpoint gUESSEndpoint = this.getUnicastHost();
                if (!this._queryKeys.containsKey(gUESSEndpoint)) {
                    object = PingRequest.createQueryKeyRequest();
                    uDPService.send((Message)object, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage((Message)object);
                    continue;
                }
                object = ((QueryKeyBundle)this._queryKeys.get((Object)gUESSEndpoint))._queryKey;
                this.purgeGuidsInternal();
                boolean bl = false;
                Object object2 = this._queries;
                synchronized (object2) {
                    Iterator iterator = this._queries.values().iterator();
                    while (iterator.hasNext()) {
                        QueryBundle queryBundle = (QueryBundle)iterator.next();
                        if (queryBundle._hostsQueried.size() > 1000) {
                            this._qGuidsToRemove.add(new GUID(queryBundle._qr.getGUID()));
                            continue;
                        }
                        if (queryBundle._hostsQueried.contains(gUESSEndpoint)) continue;
                        InetAddress inetAddress = gUESSEndpoint.getAddress();
                        QueryRequest queryRequest = QueryRequest.createQueryKeyQuery(queryBundle._qr, (QueryKey)object);
                        uDPService.send(queryRequest, inetAddress, gUESSEndpoint.getPort());
                        bl = true;
                        SentMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(queryRequest);
                        queryBundle._hostsQueried.add(gUESSEndpoint);
                    }
                }
                if (!bl) {
                    this.addUnicastEndpoint(gUESSEndpoint);
                }
                object2 = this._qGuidsToRemove;
                synchronized (object2) {
                    this.purgeGuidsInternal();
                    this._qGuidsToRemove.clear();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeGuidsInternal() {
        List list = this._qGuidsToRemove;
        synchronized (list) {
            Iterator iterator = this._qGuidsToRemove.iterator();
            while (iterator.hasNext()) {
                GUID gUID = (GUID)iterator.next();
                this._queries.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueries() throws InterruptedException {
        LOG.debug((Object)"QueryUnicaster.waitForQueries(): waiting for Queries.");
        Map map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("QueryUnicaster.waitForQueries(): numQueries = " + this._queries.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQuery(QueryRequest queryRequest, ReplyHandler replyHandler) {
        HashSet<GUID> hashSet;
        LOG.debug((Object)"QueryUnicaster.addQuery(): entered.");
        boolean bl = false;
        GUID gUID = new GUID(queryRequest.getGUID());
        Map map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey(gUID)) {
                hashSet = new QueryBundle(queryRequest);
                this._queries.put(gUID, hashSet);
                bl = true;
            }
            if (bl) {
                this._queries.notifyAll();
            }
        }
        if (replyHandler == null) {
            return bl;
        }
        map = this._querySets;
        synchronized (map) {
            hashSet = (Set)this._querySets.get(replyHandler);
            if (hashSet == null) {
                hashSet = new HashSet<GUID>();
                this._querySets.put(replyHandler, hashSet);
            }
            hashSet.add(gUID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("QueryUnicaster.addQuery(): returning " + bl));
        }
        return bl;
    }

    public void addUnicastEndpoint(InetAddress inetAddress, int n) {
        if (!SearchSettings.GUESS_ENABLED.getValue()) {
            return;
        }
        if (this.notMe(inetAddress, n) && NetworkUtils.isValidPort(n) && NetworkUtils.isValidAddress(inetAddress)) {
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
            this.addUnicastEndpoint(gUESSEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnicastEndpoint(GUESSEndpoint gUESSEndpoint) {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            LOG.debug((Object)"QueryUnicaster.addUnicastEndpoint(): obtained lock.");
            if (this._queryHosts.size() == 30) {
                this._queryHosts.removeLast();
            }
            this._queryHosts.addFirst(gUESSEndpoint);
            this._queryHosts.notify();
            if (!(!UDPService.instance().isListening() || RouterService.isGUESSCapable() || this._testUDPPingsSent >= 10 || ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isCloseIP(RouterService.getAddress(), gUESSEndpoint.getAddress().getAddress()))) {
                PingRequest pingRequest = new PingRequest(UDPService.instance().getSolicitedGUID().bytes(), 1, 0);
                UDPService.instance().send(pingRequest, gUESSEndpoint.getAddress(), gUESSEndpoint.getPort());
                SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                ++this._testUDPPingsSent;
            }
            LOG.debug((Object)"QueryUnicaster.addUnicastEndpoint(): released lock.");
        }
    }

    private boolean notMe(InetAddress inetAddress, int n) {
        boolean bl = true;
        if (n == RouterService.getPort() && Arrays.equals(inetAddress.getAddress(), RouterService.getAddress())) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeQuery(ReplyHandler replyHandler) {
        LOG.debug((Object)"QueryUnicaster.purgeQuery(RH): entered.");
        if (replyHandler == null) {
            return;
        }
        Map map = this._querySets;
        synchronized (map) {
            Set set = (Set)this._querySets.remove(replyHandler);
            if (set == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.purgeQuery((GUID)iterator.next());
            }
        }
        LOG.debug((Object)"QueryUnicaster.purgeQuery(RH): returning.");
    }

    void purgeQuery(GUID gUID) {
        LOG.debug((Object)"QueryUnicaster.purgeQuery(GUID): entered.");
        this._qGuidsToRemove.add(gUID);
        LOG.debug((Object)"QueryUnicaster.purgeQuery(GUID): returning.");
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.addResults(new GUID(queryReply.getGUID()), queryReply.getResultCount());
    }

    public void handleQueryKeyPong(PingReply pingReply) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        QueryKey queryKey = pingReply.getQueryKey();
        if (queryKey == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress inetAddress = pingReply.getInetAddress();
        Assert.that(queryKey != null);
        int n = pingReply.getPort();
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
        this._queryKeys.put(gUESSEndpoint, new QueryKeyBundle(queryKey));
        this.addUnicastEndpoint(gUESSEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResults(GUID gUID, int n) {
        Map map = this._queries;
        synchronized (map) {
            QueryBundle queryBundle = (QueryBundle)this._queries.get(gUID);
            if (queryBundle != null) {
                queryBundle._numResults += n;
                if (queryBundle._numResults > 300) {
                    List list = this._qGuidsToRemove;
                    synchronized (list) {
                        this._qGuidsToRemove.add(new GUID(queryBundle._qr.getGUID()));
                        this.purgeGuidsInternal();
                        this._qGuidsToRemove.clear();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        Object object;
        LOG.debug((Object)"QueryUnicaster.getUnicastHost(): waiting for hosts.");
        Object object2 = this._queryHosts;
        synchronized (object2) {
            LOG.debug((Object)"QueryUnicaster.getUnicastHost(): obtained lock.");
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    object = new PingRequest(ConnectionSettings.TTL.getValue());
                    RouterService.getMessageRouter().broadcastPingRequest((PingRequest)object);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
            LOG.debug((Object)"QueryUnicaster.getUnicastHost(): got a host, let go lock!");
        }
        if (this._queryHosts.size() < 25) {
            object2 = (GUESSEndpoint)this._queryHosts.removeLast();
            object = this._pingList;
            synchronized (object) {
                if (!this._pingList.contains(object2)) {
                    PingRequest pingRequest = new PingRequest(1);
                    InetAddress inetAddress = ((GUESSEndpoint)object2).getAddress();
                    UDPService.instance().send(pingRequest, inetAddress, ((GUESSEndpoint)object2).getPort());
                    this._pingList.add(object2);
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pingRequest);
                }
            }
            return object2;
        }
        return (GUESSEndpoint)this._queryHosts.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUnicastEndpointsAndQueries() {
        LOG.debug((Object)"Resetting unicast endpoints.");
        Object object = this._queries;
        synchronized (object) {
            this._queries.clear();
            this._queries.notifyAll();
        }
        object = this._queryHosts;
        synchronized (object) {
            this._queryHosts.clear();
            this._queryHosts.notifyAll();
        }
        object = this._queryKeys;
        synchronized (object) {
            this._queryKeys.clear();
            this._queryKeys.notifyAll();
        }
        object = this._pingList;
        synchronized (object) {
            this._pingList.clear();
            this._pingList.notifyAll();
        }
        this._lastPingTime = 0L;
        this._testUDPPingsSent = 0;
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 300;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set _hostsQueried = new HashSet();

        public QueryBundle(QueryRequest queryRequest) {
            this._qr = queryRequest;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }

    private static class QueryKeyBundle {
        public static final long QUERY_KEY_LIFETIME = 0x6DDD00L;
        final long _birthTime;
        final QueryKey _queryKey;

        public QueryKeyBundle(QueryKey queryKey) {
            this._queryKey = queryKey;
            this._birthTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._birthTime >= 0x6DDD00L;
        }

        public String toString() {
            return "{QueryKeyBundle: " + this._queryKey + " BirthTime = " + this._birthTime;
        }
    }

    private class QueryKeyExpirer
    implements Runnable {
        QueryKeyExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = QueryUnicaster.this._queryKeys;
            synchronized (map) {
                Set set = QueryUnicaster.this._queryKeys.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    QueryKeyBundle queryKeyBundle = (QueryKeyBundle)((Object)iterator.next());
                    if (!queryKeyBundle.shouldExpire()) continue;
                    set.remove(queryKeyBundle);
                }
            }
        }
    }
}

