/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointForSelf;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class PushAltLoc
extends AlternateLocation {
    private final PushEndpoint _pushAddress;

    protected PushAltLoc(PushEndpoint pushEndpoint, URN uRN) throws IOException {
        super(uRN);
        if (pushEndpoint == null) {
            throw new IOException("null address");
        }
        this._pushAddress = pushEndpoint;
    }

    protected PushAltLoc(URN uRN) throws IOException {
        super(uRN);
        this._pushAddress = PushEndpointForSelf.instance();
    }

    protected String generateHTTPString() {
        return this._pushAddress.httpStringValue();
    }

    public RemoteFileDesc createRemoteFileDesc(int n) {
        HashSet<URN> hashSet = new HashSet<URN>();
        hashSet.add(this.getSHA1Urn());
        int n2 = 3;
        RemoteFileDesc remoteFileDesc = new RemoteFileDesc(this._pushAddress.getAddress(), this._pushAddress.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, n, 1000, true, n2, false, null, hashSet, false, true, "ALT", System.currentTimeMillis(), -1L, this._pushAddress);
        return remoteFileDesc;
    }

    public synchronized AlternateLocation createClone() {
        PushAltLoc pushAltLoc = null;
        try {
            pushAltLoc = new PushAltLoc(this._pushAddress.createClone(), this.SHA1_URN);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
        pushAltLoc._count = this._count;
        return pushAltLoc;
    }

    public boolean isMe() {
        return Arrays.equals(this._pushAddress.getClientGUID(), RouterService.getMyGUID());
    }

    public void updateProxies(boolean bl) {
        this._pushAddress.updateProxies(bl);
    }

    public PushEndpoint getPushAddress() {
        return this._pushAddress;
    }

    public int supportsFWTVersion() {
        return this._pushAddress.supportsFWTVersion();
    }

    void promote() {
    }

    void demote() {
    }

    public boolean isDemoted() {
        return this._pushAddress.getProxies().isEmpty();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PushAltLoc)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PushAltLoc pushAltLoc = (PushAltLoc)object;
        return this._pushAddress.equals(pushAltLoc._pushAddress);
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        int n = super.compareTo(object);
        if (n != 0) {
            return n;
        }
        if (!(object instanceof PushAltLoc)) {
            return 1;
        }
        PushAltLoc pushAltLoc = (PushAltLoc)object;
        return GUID.GUID_BYTE_COMPARATOR.compare(this._pushAddress.getClientGUID(), pushAltLoc.getPushAddress().getClientGUID());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = super.hashCode();
            this.hashCode = n = 37 * n + this._pushAddress.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._pushAddress + "," + this._count;
    }
}

