/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.messages.Message;

public abstract class AbstractMessageQueue
implements MessageQueue {
    private final int _cycleSize;
    private int _leftInCycle;
    private int _timeout;
    protected int _dropped;

    protected AbstractMessageQueue(int n, int n2) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Timeout too small: " + n);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Cycle too small: " + n);
        }
        this._cycleSize = n;
        this._leftInCycle = n;
        this._timeout = n2;
    }

    public void add(Message message) {
        Message message2 = this.addInternal(message);
        if (message2 != null) {
            ++this._dropped;
            message2.recordDrop();
        }
    }

    protected abstract Message addInternal(Message var1);

    public Message removeNext() {
        Message message;
        if (this._leftInCycle == 0) {
            return null;
        }
        long l = System.currentTimeMillis() - (long)this._timeout;
        while (true) {
            if ((message = this.removeNextInternal()) == null) {
                return null;
            }
            if (message.getCreationTime() >= l) break;
            ++this._dropped;
            message.recordDrop();
        }
        --this._leftInCycle;
        return message;
    }

    protected abstract Message removeNextInternal();

    public void resetCycle() {
        this._leftInCycle = this._cycleSize;
    }

    public final int resetDropped() {
        int n = this._dropped;
        this._dropped = 0;
        return n;
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

