/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IP;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IPList {
    private List ips = new LinkedList();

    public void add(String string) {
        IP iP;
        try {
            iP = new IP(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (!this.ips.contains(iP)) {
            this.ips.add(iP);
        }
    }

    public boolean contains(IP iP) {
        Iterator iterator = this.ips.iterator();
        while (iterator.hasNext()) {
            IP iP2 = (IP)iterator.next();
            if (!iP2.contains(iP)) continue;
            return true;
        }
        return false;
    }

    public int logMinDistanceTo(IP iP) {
        int n = this.minDistanceTo(iP);
        int n2 = 0;
        int n3 = -1;
        while ((n & n3) != 0) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public int minDistanceTo(IP iP) {
        if (iP.getMask() != -1) {
            throw new IllegalArgumentException("Expected single IP, not an IP range.");
        }
        int n = Integer.MAX_VALUE;
        Iterator iterator = this.ips.iterator();
        while (iterator.hasNext()) {
            IP iP2 = (IP)iterator.next();
            int n2 = Integer.MIN_VALUE ^ iP2.getDistanceTo(iP);
            if (n <= n2) continue;
            n = n2;
        }
        return Integer.MIN_VALUE ^ n;
    }
}

