/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.CountingOutputStream;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.MultiRRIterator;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadPong
extends VendorMessage {
    private static final Log LOG;
    private static UploadManager _uploadManager;
    private static FileManager _fileManager;
    private static final int PACKET_SIZE = 580;
    private static final byte FILE_NOT_FOUND = 0;
    private static final byte COMPLETE_FILE = 1;
    private static final byte PARTIAL_FILE = 2;
    private static final byte FIREWALLED = 4;
    private static final byte DOWNLOADING = 8;
    private static final byte CODES_MASK = 15;
    private static final byte BUSY = 127;
    public static final int VERSION = 1;
    private byte _features;
    private IntervalSet _ranges;
    private Set _altLocs;
    private Set _pushLocs;
    private int _queueStatus;
    private boolean _fileFound;
    private boolean _completeFile;
    private byte[] _vendorId;
    private boolean _isFirewalled;
    private boolean _isDownloading;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.messages.vendor.HeadPong");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _uploadManager = RouterService.getUploadManager();
        _fileManager = RouterService.getFileManager();
    }

    protected HeadPong(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 24, n, byArray2);
        if (byArray2 == null || byArray2.length < 2) {
            throw new BadPacketException("bad payload");
        }
        if (n == 1 && byArray2[1] > 15) {
            throw new BadPacketException("invalid payload for version " + n);
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
            this._features = (byte)(dataInputStream.readByte() & 0x1F);
            byte by3 = dataInputStream.readByte();
            if (by3 == 0) {
                return;
            }
            this._fileFound = true;
            if ((by3 & 4) == 4) {
                this._isFirewalled = true;
            }
            this._vendorId = new byte[4];
            dataInputStream.readFully(this._vendorId);
            this._queueStatus = dataInputStream.readByte();
            if ((by3 & 1) == 1) {
                this._completeFile = true;
            } else {
                if ((by3 & 8) == 8) {
                    this._isDownloading = true;
                }
                if ((this._features & 1) == 1) {
                    this._ranges = this.readRanges(dataInputStream);
                }
            }
            if ((this._features & 4) == 4) {
                this._pushLocs = this.readPushLocs(dataInputStream);
            }
            if ((this._features & 2) == 2) {
                this._altLocs = this.readLocs(dataInputStream);
            }
        }
        catch (IOException iOException) {
            throw new BadPacketException(iOException.getMessage());
        }
    }

    public HeadPong(HeadPing headPing) {
        super(F_LIME_VENDOR_ID, 24, 1, HeadPong.derivePayload(headPing));
        this.setGUID(new GUID(headPing.getGUID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] derivePayload(HeadPing headPing) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ByteArrayOutputStream byteArrayOutputStream;
        block28: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            CountingOutputStream countingOutputStream = new CountingOutputStream(byteArrayOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(countingOutputStream);
            int n = 0;
            URN uRN = headPing.getUrn();
            FileDesc fileDesc = _fileManager.getFileDescForUrn(uRN);
            bl3 = false;
            bl2 = false;
            bl = false;
            try {
                AlternateLocationCollection alternateLocationCollection;
                AlternateLocationCollection alternateLocationCollection2;
                byte by = headPing.getFeatures();
                by = (byte)(by & 0xFFFFFFEF);
                dataOutputStream.write(by);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("writing features " + by));
                }
                if (fileDesc == null) {
                    LOG.debug((Object)"we do not have the file");
                    dataOutputStream.write(0);
                    return byteArrayOutputStream.toByteArray();
                }
                if (!RouterService.acceptedIncomingConnection()) {
                    n = 4;
                }
                if (fileDesc instanceof IncompleteFileDesc) {
                    n = (byte)(n | 2);
                    IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
                    if (incompleteFileDesc.isActivelyDownloading()) {
                        n = (byte)(n | 8);
                    }
                } else {
                    n = (byte)(n | 1);
                }
                dataOutputStream.write(n);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("our return code is " + n));
                }
                dataOutputStream.write(F_LIME_VENDOR_ID);
                int n2 = _uploadManager.getNumQueuedUploads();
                int n3 = n2 == UploadSettings.UPLOAD_QUEUE_SIZE.getValue() ? 127 : (n2 > 0 ? (int)((byte)n2) : (int)((byte)(_uploadManager.uploadsInProgress() - UploadSettings.HARD_MAX_UPLOADS.getValue())));
                dataOutputStream.writeByte(n3);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("our queue status is " + n3));
                }
                if (n == 2 && headPing.requestsRanges()) {
                    boolean bl4 = bl = !HeadPong.writeRanges(countingOutputStream, fileDesc);
                }
                if (headPing.requestsPushLocs()) {
                    boolean bl5;
                    boolean bl6 = bl5 = (by & 8) == 8;
                    if (bl5) {
                        AlternateLocationCollection alternateLocationCollection3 = alternateLocationCollection2 = RouterService.getAltlocManager().getPush(uRN, true);
                        synchronized (alternateLocationCollection3) {
                            bl2 = !HeadPong.writePushLocs(countingOutputStream, alternateLocationCollection2.iterator());
                        }
                    }
                    alternateLocationCollection2 = RouterService.getAltlocManager().getPush(uRN, true);
                    AlternateLocationCollection alternateLocationCollection4 = RouterService.getAltlocManager().getPush(uRN, false);
                    AlternateLocationCollection alternateLocationCollection5 = alternateLocationCollection2;
                    synchronized (alternateLocationCollection5) {
                        AlternateLocationCollection alternateLocationCollection6 = alternateLocationCollection4;
                        synchronized (alternateLocationCollection6) {
                            bl2 = !HeadPong.writePushLocs(countingOutputStream, new MultiRRIterator(new Iterator[]{alternateLocationCollection2.iterator(), alternateLocationCollection4.iterator()}));
                        }
                    }
                }
                if (!headPing.requestsAltlocs()) break block28;
                alternateLocationCollection2 = alternateLocationCollection = RouterService.getAltlocManager().getDirect(uRN);
                synchronized (alternateLocationCollection2) {
                    bl3 = !HeadPong.writeLocs(countingOutputStream, alternateLocationCollection.iterator());
                }
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            LOG.debug((Object)"not sending ranges");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFE);
        }
        if (bl3) {
            LOG.debug((Object)"not sending altlocs");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFD);
        }
        if (bl2) {
            LOG.debug((Object)"not sending push altlocs");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFB);
        }
        return byArray;
    }

    public boolean hasFile() {
        return this._fileFound;
    }

    public boolean hasCompleteFile() {
        return this.hasFile() && this._completeFile;
    }

    public IntervalSet getRanges() {
        return this._ranges;
    }

    public Set getAltLocs() {
        return this._altLocs;
    }

    public Set getPushLocs() {
        return this._pushLocs;
    }

    public Set getAllLocsRFD(RemoteFileDesc remoteFileDesc) {
        IpPort ipPort;
        Iterator iterator;
        HashSet<RemoteFileDesc> hashSet = new HashSet<RemoteFileDesc>();
        if (this._altLocs != null) {
            iterator = this._altLocs.iterator();
            while (iterator.hasNext()) {
                ipPort = (IpPort)iterator.next();
                hashSet.add(new RemoteFileDesc(remoteFileDesc, ipPort));
            }
        }
        if (this._pushLocs != null) {
            iterator = this._pushLocs.iterator();
            while (iterator.hasNext()) {
                ipPort = (PushEndpoint)iterator.next();
                hashSet.add(new RemoteFileDesc(remoteFileDesc, (PushEndpoint)ipPort));
            }
        }
        return hashSet;
    }

    public void updateRFD(RemoteFileDesc remoteFileDesc) {
        if (this.isBusy()) {
            remoteFileDesc.setRetryAfter(60);
        }
        remoteFileDesc.setQueueStatus(this.getQueueStatus());
        remoteFileDesc.setAvailableRanges(this.getRanges());
        remoteFileDesc.setSerializeProxies();
    }

    public String getVendor() {
        return new String(this._vendorId);
    }

    public boolean isFirewalled() {
        return this._isFirewalled;
    }

    public int getQueueStatus() {
        return this._queueStatus;
    }

    public boolean isBusy() {
        return this._queueStatus >= 127;
    }

    public boolean isDownloading() {
        return this._isDownloading;
    }

    public boolean isGGEPPong() {
        return (this._features & 0x10) != 0;
    }

    public String toString() {
        return "HeadPong: isGGEP " + this.isGGEPPong() + " hasFile " + this.hasFile() + " hasCompleteFile " + this.hasCompleteFile() + " isDownloading " + this.isDownloading() + " isFirewalled " + this.isFirewalled() + " queue rank " + this.getQueueStatus() + " \nranges " + this.getRanges() + " \nalts " + this.getAltLocs() + " \npushalts " + this.getPushLocs();
    }

    private final IntervalSet readRanges(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return IntervalSet.parseBytes(byArray);
    }

    private final Set readPushLocs(DataInputStream dataInputStream) throws IOException, BadPacketException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        HashSet hashSet = new HashSet();
        hashSet.addAll(NetworkUtils.unpackPushEPs(new ByteArrayInputStream(byArray)));
        return hashSet;
    }

    private final Set readLocs(DataInputStream dataInputStream) throws IOException, BadPacketException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        HashSet hashSet = new HashSet();
        hashSet.addAll(NetworkUtils.unpackIps(byArray));
        return hashSet;
    }

    private static final boolean writeRanges(CountingOutputStream countingOutputStream, FileDesc fileDesc) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(countingOutputStream);
        LOG.debug((Object)"adding ranges to pong");
        IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
        byte[] byArray = incompleteFileDesc.getRangesAsByte();
        if (countingOutputStream.getAmountWritten() + 2 + byArray.length <= 580) {
            LOG.debug((Object)"added ranges");
            dataOutputStream.writeShort((short)byArray.length);
            countingOutputStream.write(byArray);
            return true;
        }
        LOG.debug((Object)"ranges will not fit :(");
        return false;
    }

    private static final boolean writePushLocs(CountingOutputStream countingOutputStream, Iterator iterator) throws IOException {
        if (!iterator.hasNext()) {
            return false;
        }
        int n = (580 - (countingOutputStream.getAmountWritten() + 2)) / 47;
        if (n == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("trying to add up to " + n + " push locs to pong"));
        }
        long l = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (iterator.hasNext() && n > 0) {
            PushAltLoc pushAltLoc = (PushAltLoc)iterator.next();
            if (pushAltLoc.getPushAddress().getProxies().isEmpty()) {
                iterator.remove();
                continue;
            }
            if (pushAltLoc.canBeSent(0)) {
                byteArrayOutputStream.write(pushAltLoc.getPushAddress().toBytes());
                --n;
                pushAltLoc.send(l, 0);
                continue;
            }
            if (pushAltLoc.canBeSentAny()) continue;
            iterator.remove();
        }
        if (byteArrayOutputStream.size() == 0) {
            LOG.debug((Object)"did not send any push locs");
            return false;
        }
        LOG.debug((Object)"adding push altlocs");
        ByteOrder.short2beb((short)byteArrayOutputStream.size(), countingOutputStream);
        byteArrayOutputStream.writeTo(countingOutputStream);
        return true;
    }

    private static final boolean writeLocs(CountingOutputStream countingOutputStream, Iterator iterator) throws IOException {
        if (!iterator.hasNext()) {
            return false;
        }
        int n = (580 - (countingOutputStream.getAmountWritten() + 2)) / 6;
        if (n == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("trying to add up to " + n + " locs to pong"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        long l = System.currentTimeMillis();
        while (iterator.hasNext() && n2 < n) {
            DirectAltLoc directAltLoc = (DirectAltLoc)iterator.next();
            if (directAltLoc.canBeSent(0)) {
                directAltLoc.send(l, 0);
                byteArrayOutputStream.write(directAltLoc.getHost().getInetAddress().getAddress());
                ByteOrder.short2leb((short)directAltLoc.getHost().getPort(), byteArrayOutputStream);
                ++n2;
                continue;
            }
            if (directAltLoc.canBeSentAny()) continue;
            iterator.remove();
        }
        LOG.debug((Object)"adding altlocs");
        ByteOrder.short2beb((short)byteArrayOutputStream.size(), countingOutputStream);
        byteArrayOutputStream.writeTo(countingOutputStream);
        return true;
    }
}

