/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.VideoMetaData;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RIFFMetaData
extends VideoMetaData {
    public RIFFMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            this.readRIFFHeader(dataInputStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            IOUtils.close(fileInputStream);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IOUtils.close(fileInputStream);
    }

    private void readRIFFHeader(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) {
            return;
        }
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        if (byArray[0] != 65 || byArray[1] != 86 || byArray[2] != 73 || byArray[3] != 32) {
            return;
        }
        IOUtils.ensureSkip(dataInputStream, 12L);
        IOUtils.ensureSkip(dataInputStream, 8L);
        dataInputStream.readFully(byArray);
        int n = ByteOrder.leb2int(byArray, 0, 4);
        IOUtils.ensureSkip(dataInputStream, 12L);
        dataInputStream.readFully(byArray);
        int n2 = ByteOrder.leb2int(byArray, 0, 4);
        this.setLength((short)(1L * (long)n * (long)n2 / 1000L));
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        ByteOrder.leb2int(byArray, 0, 4);
        IOUtils.ensureSkip(dataInputStream, 4L);
        dataInputStream.readFully(byArray);
        this.setWidth(ByteOrder.leb2int(byArray, 0, 4));
        dataInputStream.readFully(byArray);
        this.setHeight(ByteOrder.leb2int(byArray, 0, 4));
        IOUtils.ensureSkip(dataInputStream, 16L);
    }
}

