/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public final class BrowseHostUploadState
extends UploadState {
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public BrowseHostUploadState(HTTPUploader hTTPUploader) {
        super(hTTPUploader);
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        Object object;
        if (!this.UPLOADER.getClientAcceptsXGnutellaQueryreplies()) {
            String string = "HTTP/1.1 406 Not Acceptable\r\n\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("BHUS.doUpload(): client does not accept QRs.");
            return;
        }
        QueryRequest queryRequest = QueryRequest.createBrowseHostQuery();
        Response[] responseArray = RouterService.getFileManager().query(queryRequest);
        if (responseArray == null) {
            responseArray = new Response[]{};
        }
        Iterator iterator = RouterService.getMessageRouter().responsesToQueryReplies(responseArray, queryRequest);
        try {
            while (iterator.hasNext()) {
                object = (QueryReply)iterator.next();
                ((Message)object).write(this.BAOS);
            }
        }
        catch (IOException iOException) {}
        object = "HTTP/1.1 200 OK\r\n";
        outputStream.write(((String)object).getBytes());
        object = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(((String)object).getBytes());
        object = "Content-Type: application/x-gnutella-packets\r\n";
        outputStream.write(((String)object).getBytes());
        object = "Content-Length: " + this.BAOS.size() + "\r\n";
        outputStream.write(((String)object).getBytes());
        this.writeProxies(outputStream);
        object = "\r\n";
        outputStream.write(((String)object).getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        outputStream.write(this.BAOS.toByteArray());
        this.UPLOADER.setAmountUploaded(this.BAOS.size());
        this.debug("BHUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }
}

