/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.UploadStat;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StalledUploadWatchdog
implements Runnable {
    private static final Log LOG;
    public static long DELAY_TIME;
    private OutputStream ostream;
    private boolean isScheduled;
    private long nextCheckTime;
    private boolean closed;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.uploader.StalledUploadWatchdog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        DELAY_TIME = 120000L;
    }

    public synchronized boolean deactivate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deactived on: " + this.ostream));
        }
        this.nextCheckTime = -1L;
        this.ostream = null;
        return this.closed;
    }

    public synchronized void activate(OutputStream outputStream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activated on: " + outputStream));
        }
        this.nextCheckTime = System.currentTimeMillis() + DELAY_TIME;
        if (!this.isScheduled) {
            RouterService.schedule(this, DELAY_TIME, 0L);
            this.isScheduled = true;
        }
        this.ostream = outputStream;
    }

    public synchronized void run() {
        this.isScheduled = false;
        if (this.nextCheckTime == -1L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l < this.nextCheckTime) {
            RouterService.schedule(this, this.nextCheckTime - l, 0L);
        } else {
            this.closed = true;
            try {
                if (this.ostream != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("STALLED!  Killing: " + this.ostream));
                    }
                    UploadStat.STALLED.incrementStat();
                    this.ostream.close();
                }
            }
            catch (IOException iOException) {}
            this.ostream = null;
        }
    }
}

