/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class BufferByteArrayOutputStream
extends ByteArrayOutputStream {
    protected ByteBuffer buffer;
    protected boolean grow;

    public BufferByteArrayOutputStream() {
        this(32);
    }

    public BufferByteArrayOutputStream(int n) {
        this(ByteBuffer.allocate(n), true);
    }

    public BufferByteArrayOutputStream(int n, boolean bl) {
        this(ByteBuffer.allocate(n), bl);
    }

    public BufferByteArrayOutputStream(byte[] byArray) {
        this(ByteBuffer.wrap(byArray), false);
    }

    public BufferByteArrayOutputStream(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public BufferByteArrayOutputStream(ByteBuffer byteBuffer) {
        this(byteBuffer, false);
    }

    public BufferByteArrayOutputStream(ByteBuffer byteBuffer, boolean bl) {
        this.buffer = byteBuffer;
        this.grow = bl;
    }

    public void close() throws IOException {
    }

    public void reset() {
        this.buffer.clear();
    }

    public int size() {
        return this.buffer.position();
    }

    public byte[] toByteArray() {
        byte[] byArray = this.buffer.array();
        int n = this.buffer.arrayOffset();
        int n2 = this.buffer.position();
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public void writeTo(ByteBuffer byteBuffer) {
        this.buffer.flip();
        byteBuffer.put(this.buffer);
        this.buffer.compact();
    }

    public void writeTo(byte[] byArray) {
        this.writeTo(byArray, 0, byArray.length);
    }

    public void writeTo(byte[] byArray, int n, int n2) {
        this.buffer.flip();
        this.buffer.get(byArray, n, n2);
        this.buffer.compact();
    }

    public String toString() {
        return new String(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position(), string);
    }

    private void grow(int n) {
        int n2 = this.buffer.capacity();
        int n3 = Math.max(n2 << 1, n2 + n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        this.buffer.flip();
        byteBuffer.put(this.buffer);
        this.buffer = byteBuffer;
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.grow && n2 > this.buffer.remaining()) {
            this.grow(n2);
        }
        this.buffer.put(byArray, n, n2);
    }

    public void write(int n) {
        if (this.grow && !this.buffer.hasRemaining()) {
            this.grow(1);
        }
        this.buffer.put((byte)n);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
        this.buffer.clear();
    }
}

