/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class SOCKSSocketFactory
implements ProtocolSocketFactory {
    private int _version;
    private String _host;
    private int _port;
    private String _user;
    private String _pass;
    private String _destHost;
    private int _destPort;

    private SOCKSSocketFactory() {
    }

    public SOCKSSocketFactory(int version, String proxyHost, int proxyPort, String user, String pass) {
        if (version < 4 || version > 5) {
            throw new IllegalArgumentException("unsupported version of SOCKS");
        }
        if (proxyHost == null || "".equals(proxyHost)) {
            throw new IllegalArgumentException("Proxy host is null");
        }
        if ((proxyPort & 0xFFFF0000) != 0 || proxyPort == 0) {
            throw new IllegalArgumentException("Invalid Proxy Port");
        }
        this._version = version;
        this._host = proxyHost;
        this._port = proxyPort;
        this._user = user;
        this._pass = pass;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        this._destHost = host;
        this._destPort = port;
        Socket sock = new Socket(this._host, this._port, clientHost, clientPort);
        this.initializeConnection(sock);
        return sock;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this._destHost = host;
        this._destPort = port;
        Socket sock = new Socket(this._host, this._port);
        this.initializeConnection(sock);
        return sock;
    }

    private void initializeConnection(Socket socket) throws IOException, UnknownHostException {
        if (this._version == 4) {
            this.doSOCKSv4Handshake(socket);
        } else if (this._version == 5) {
            this.doSOCKSv5Handshake(socket);
        } else {
            throw new IllegalArgumentException("bad SOCKS version");
        }
    }

    private void doSOCKSv4Handshake(Socket socket) throws IOException, UnknownHostException {
        byte[] hostBytes = InetAddress.getByName(this._destHost).getAddress();
        byte[] portBytes = new byte[]{(byte)(this._destPort >> 8), (byte)this._destPort};
        OutputStream os = null;
        InputStream in = null;
        os = socket.getOutputStream();
        in = socket.getInputStream();
        os.write(4);
        os.write(1);
        os.write(portBytes);
        os.write(hostBytes);
        if (this._user != null) {
            os.write(this._user.getBytes());
        }
        os.write(0);
        os.flush();
        int version = in.read();
        if (version != 0 && version != 4) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 0 or 4");
        }
        int status = in.read();
        if (status != 90) {
            socket.close();
            throw new IOException("Request rejected with status: " + status);
        }
        byte[] connectedHostPort = new byte[2];
        byte[] connectedHostAddress = new byte[4];
        if (in.read(connectedHostPort) == -1 || in.read(connectedHostAddress) == -1) {
            socket.close();
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
    }

    private void doSOCKSv5Handshake(Socket socket) throws IOException, UnknownHostException {
        int status;
        byte[] hostBytes = InetAddress.getByName(this._destHost).getAddress();
        byte[] portBytes = new byte[]{(byte)(this._destPort >> 8), (byte)this._destPort};
        OutputStream os = null;
        InputStream in = null;
        os = socket.getOutputStream();
        in = socket.getInputStream();
        os.write(5);
        if (this._user != null) {
            os.write(2);
            os.write(0);
            os.write(2);
        } else {
            os.write(1);
            os.write(0);
        }
        os.flush();
        int version = in.read();
        if (version != 5) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        int auth_method = in.read();
        if (auth_method != 0 && auth_method == 2) {
            os.write(1);
            os.write((byte)this._user.length());
            os.write(this._user.getBytes());
            os.write((byte)this._pass.length());
            os.write(this._pass.getBytes());
            os.flush();
            version = in.read();
            if (version != 1) {
                socket.close();
                throw new IOException("Invalid version for authentication: " + version + " expected 1");
            }
            status = in.read();
            if (status != 0) {
                socket.close();
                throw new IOException("Authentication failed with status: " + status);
            }
        }
        os.write(5);
        os.write(1);
        os.write(0);
        os.write(1);
        os.write(hostBytes);
        os.write(portBytes);
        os.flush();
        version = in.read();
        if (version != 5) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        status = in.read();
        if (status != 0) {
            socket.close();
            throw new IOException("Request rejected with status: " + status);
        }
        in.read();
        int addrType = in.read();
        int bytesToSkip = 0;
        if (addrType == 1) {
            bytesToSkip = 6;
        } else if (addrType == 3) {
            bytesToSkip = in.read() + 2;
        } else if (addrType == 4) {
            bytesToSkip = 18;
        }
        for (int i = 0; i < bytesToSkip; ++i) {
            if (in.read() != -1) continue;
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
    }

    public Socket createSocket(String host, int port, int timeout) throws IOException, UnknownHostException {
        return null;
    }
}

