/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Random;
import org.logi.crypto.CryptoError;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.KeySource;
import org.logi.crypto.random.RandomFromStream;
import org.logi.crypto.random.RandomMD5;

public abstract class Crypto {
    public static Random random = new WarnRandom();
    public static int primeCertainty = 20;
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger FOUR = BigInteger.valueOf(4L);
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static KeySource keySource;
    public static char[] NIBBLE;
    public static char[] BIT;
    public static String[] cdsPath;

    public static void initRandom(Random random) {
        if (random == null) {
            throw new NullPointerException();
        }
        Crypto.random = random;
    }

    public static void initRandom() {
        Random random;
        if (!(Crypto.random instanceof WarnRandom)) {
            return;
        }
        try {
            random = new RandomFromStream(new FileInputStream("/dev/urandom"));
        }
        catch (Throwable throwable) {
            random = new RandomMD5();
        }
        Crypto.initRandom(random);
    }

    public static final long makeLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            ++n3;
        }
        return l;
    }

    public static final int makeInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public static final void writeBytes(long l, byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            byArray[n3] = (byte)l;
            l >>>= 8;
            --n3;
        }
    }

    public static final void writeBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3 - 1;
        while (n4 >= n2) {
            byArray[n4] = (byte)n;
            n >>>= 8;
            --n4;
        }
    }

    public static final int pickBits(int n, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            n2 = n2 << 1 | n >>> 31 - byArray[n4] & 1;
            ++n4;
        }
        return n2;
    }

    public static final long pickBits(long l, byte[] byArray) {
        long l2 = 0L;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            l2 = l2 << 1 | l >>> 63 - byArray[n2] & 1L;
            ++n2;
        }
        return l2;
    }

    public static final String hexString(byte[] byArray) {
        return Crypto.hexString(byArray, 0, byArray.length);
    }

    public static final String hexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(NIBBLE[byArray[n3] >>> 4 & 0xF]);
            stringBuffer.append(NIBBLE[byArray[n3] & 0xF]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final String hexString(long l) {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < 16) {
            stringBuffer.append(NIBBLE[(int)(l >>> 60 - 4 * n) & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String hexString(int n) {
        StringBuffer stringBuffer = new StringBuffer(8);
        int n2 = 0;
        while (n2 < 8) {
            stringBuffer.append(NIBBLE[n >>> 60 - 4 * n2 & 0xF]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String hexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(NIBBLE[by >>> 4 & 0xF]);
        stringBuffer.append(NIBBLE[by & 0xF]);
        return stringBuffer.toString();
    }

    public static byte fromHexNibble(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'G') {
            return (byte)(c - 55);
        }
        return (byte)(c - 87);
    }

    public static byte[] fromHexString(String string) {
        int n = (string.length() + 1) / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        if (string.length() % 2 == 1) {
            byArray[0] = Crypto.fromHexNibble(string.charAt(0));
            n3 = 1;
            n2 = 1;
        }
        while (n2 < n) {
            byArray[n2++] = (byte)(Crypto.fromHexNibble(string.charAt(n3++)) << 4 | Crypto.fromHexNibble(string.charAt(n3++)));
        }
        return byArray;
    }

    public static final String binString(long l) {
        StringBuffer stringBuffer = new StringBuffer(64);
        int n = 0;
        while (n < 64) {
            stringBuffer.append(BIT[(int)(l >>> 63 - n) & 1]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String binString(int n) {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n2 = 0;
        while (n2 < 32) {
            stringBuffer.append(BIT[n >>> 31 - n2 & 1]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length - 1;
        while (n >= 0) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static boolean equalRelaxed(byte[] byArray, byte[] byArray2) {
        if (byArray.length > byArray2.length) {
            int n = byArray.length - byArray2.length - 1;
            while (n >= 0) {
                if (byArray[n] != 0) {
                    return false;
                }
                --n;
            }
            n = byArray.length - 1;
            while (n > byArray.length - byArray2.length) {
                if (byArray[n] != byArray2[n + byArray2.length - byArray.length]) {
                    return false;
                }
                --n;
            }
        } else {
            int n = byArray2.length - byArray.length - 1;
            while (n >= 0) {
                if (byArray2[n] != 0) {
                    return false;
                }
                --n;
            }
            n = byArray2.length - 1;
            while (n > byArray2.length - byArray.length) {
                if (byArray2[n] != byArray[n + byArray.length - byArray2.length]) {
                    return false;
                }
                --n;
            }
        }
        return true;
    }

    public static boolean equalSub(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public static final void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 24);
        outputStream.write(n >>> 16);
        outputStream.write(n >>> 8);
        outputStream.write(n);
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public static final int readBlock(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = inputStream.read(byArray, n, n3);
            if (n4 == -1) {
                return -1;
            }
            n += n4;
            n3 -= n4;
        }
        return n2;
    }

    public static Class makeClass(String string) throws InvalidCDSException {
        int n = 0;
        while (n < cdsPath.length) {
            try {
                return Class.forName(cdsPath[n] + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n;
            }
        }
        throw new InvalidCDSException("The class " + string + " was not found");
    }

    public static CipherKey makeSessionKey(String string, byte[] byArray) throws InvalidCDSException {
        Constructor constructor;
        Object object;
        Class clazz = Crypto.makeClass(string);
        try {
            object = new Class[]{byArray.getClass()};
            constructor = clazz.getConstructor((Class<?>)object);
        }
        catch (Exception exception) {
            throw new InvalidCDSException(string + " does not have a " + string + "(byte[]) constructor");
        }
        try {
            Object[] objectArray = new Object[]{byArray};
            object = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidCDSException("Unable to create an instance of " + string + " [ " + invocationTargetException.getTargetException().toString() + " ]");
        }
        catch (Exception exception) {
            throw new InvalidCDSException("Unable to create an instance of " + string);
        }
        try {
            return (CipherKey)object;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCDSException(string + " does not implement CipherKey");
        }
    }

    public static int pastSpace(Reader reader) throws IOException {
        int n = 32;
        while (Character.isWhitespace((char)n) && n != -1) {
            n = reader.read();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Object fromString(Reader var0) throws InvalidCDSException, IOException {
        var1_1 = new StringBuffer();
        var2_2 = Crypto.pastSpace(var0);
        if (var2_2 != -1) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1.append((char)var2_2);
            var2_2 = var0.read();
lbl8:
            // 2 sources

            ** while (Character.isJavaIdentifierPart((char)((char)var2_2)) && var2_2 != -1)
        }
lbl9:
        // 1 sources

        var3_3 = var1_1.toString();
        var1_1 = new StringBuffer();
        if (Character.isWhitespace((char)var2_2)) {
            var2_2 = Crypto.pastSpace(var0);
        }
        if (var2_2 != 40) {
            throw new InvalidCDSException("( expected after " + var3_3);
        }
        var4_4 = 1;
        var5_5 = false;
        var2_2 = var0.read();
        while (true) {
            if (var2_2 == 34) {
                var5_5 = var5_5 == false;
            } else if (!var5_5) {
                if (var2_2 == 40) {
                    ++var4_4;
                } else if (var2_2 == 41) {
                    --var4_4;
                }
            }
            if (var4_4 == 0 || var2_2 == -1) break;
            var1_1.append((char)var2_2);
            var2_2 = var0.read();
        }
        if (var2_2 == -1) {
            throw new InvalidCDSException("parentheses after " + var3_3 + " never closed");
        }
        var6_6 = var1_1.toString();
        if (var3_3.equals("lookup")) {
            var7_7 = Crypto.fromString(var6_6);
            if (!(var7_7 instanceof Fingerprint)) {
                throw new InvalidCDSException("Fingerprint object expected as parameter to lookup()");
            }
            var8_9 = (Fingerprint)var7_7;
            if (Crypto.keySource == null) {
                throw new InvalidCDSException("No key-source has been assigned");
            }
            return Crypto.keySource.byFingerprint(var8_9);
        }
        var7_8 = Crypto.makeClass(var3_3);
        try {
            var9_11 /* !! */  = new Class[]{Class.forName("java.lang.String")};
            var8_10 = var7_8.getMethod("parseCDS", var9_11 /* !! */ );
        }
        catch (Exception var9_12) {
            throw new InvalidCDSException(var3_3 + " does not have a " + var3_3 + "(String) constructor");
        }
        try {
            var10_13 = new Object[]{var6_6};
            var9_11 /* !! */  = var8_10.invoke(null, var10_13);
        }
        catch (InvocationTargetException var10_14) {
            throw new InvalidCDSException("Unable to create an instance of " + var3_3 + " [ " + var10_14.getTargetException().toString() + " ]");
        }
        catch (Exception var10_15) {
            throw new InvalidCDSException("Unable to create an instance of " + var3_3);
        }
        return var9_11 /* !! */ ;
    }

    public static Object fromString(String string) throws InvalidCDSException {
        try {
            return Crypto.fromString(new StringReader(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        BIT = new char[]{'0', '1'};
        cdsPath = new String[]{"org.logi.crypto.", "org.logi.crypto.keys.", "org.logi.crypto.hash.", "org.logi.crypto.sign."};
    }

    private static class WarnRandom
    extends Random {
        protected synchronized int next(int n) {
            throw new CryptoError("A org.logi.crypto.Crypto.initRandom(...) method has not been called.");
        }
    }
}

