/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import org.logi.crypto.Crypto;
import org.logi.crypto.CryptoCorruptError;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.modes.EncryptECB;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.EncryptedKeyEx;
import org.logi.crypto.protocols.NoninterKeyExClient;

public class EncryptedKeyExClient
extends EncryptedKeyEx
implements NoninterKeyExClient {
    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        byte[] byArray2;
        if (byArray != null) {
            throw new CryptoProtocolException("A non-interactive key-exchange client should not receive messages.");
        }
        byte[] byArray3 = this.sessionKey.toString().getBytes();
        EncryptECB encryptECB = new EncryptECB(this.key);
        byte[] byArray4 = encryptECB.encrypt(byArray3, 0, byArray3.length);
        byte[] byArray5 = encryptECB.flush();
        if (this.signKey == null) {
            byArray2 = new byte[byArray4.length + byArray5.length + 8];
            Crypto.writeBytes(byArray2.length, byArray2, 0, 4);
        } else {
            try {
                byte[] byArray6 = this.signKey.sign(Fingerprint.create(byArray3, "SHA1")).getBytes();
                byArray2 = new byte[byArray4.length + byArray5.length + byArray6.length + 8];
                int n = 8 + byArray4.length + byArray5.length;
                Crypto.writeBytes(n, byArray2, 0, 4);
                System.arraycopy(byArray6, 0, byArray2, n, byArray6.length);
            }
            catch (KeyException keyException) {
                throw new CryptoProtocolException(keyException.getMessage());
            }
            catch (InvalidCDSException invalidCDSException) {
                throw new CryptoCorruptError(invalidCDSException.getMessage());
            }
        }
        Crypto.writeBytes(byArray3.length, byArray2, 4, 4);
        System.arraycopy(byArray4, 0, byArray2, 8, byArray4.length);
        System.arraycopy(byArray5, 0, byArray2, 8 + byArray4.length, byArray5.length);
        this.keyDecided = true;
        return byArray2;
    }

    public EncryptedKeyExClient(CipherKey cipherKey, Key key) {
        super(cipherKey, null, key);
    }

    public EncryptedKeyExClient(CipherKey cipherKey, SignatureKey signatureKey, Key key) {
        super(cipherKey, signatureKey, key);
    }
}

