/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.LibraryListener;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.ContentCodesResponseImpl;
import de.kapsi.net.daap.chunks.impl.AuthenticationMethod;
import de.kapsi.net.daap.chunks.impl.AuthenticationSchemes;
import de.kapsi.net.daap.chunks.impl.ContainerCount;
import de.kapsi.net.daap.chunks.impl.ContentCodesResponse;
import de.kapsi.net.daap.chunks.impl.DaapProtocolVersion;
import de.kapsi.net.daap.chunks.impl.DatabaseCount;
import de.kapsi.net.daap.chunks.impl.DeletedIdListing;
import de.kapsi.net.daap.chunks.impl.DmapProtocolVersion;
import de.kapsi.net.daap.chunks.impl.ItemCount;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.ItemName;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.LoginRequired;
import de.kapsi.net.daap.chunks.impl.LoginResponse;
import de.kapsi.net.daap.chunks.impl.MusicSharingVersion;
import de.kapsi.net.daap.chunks.impl.PersistentId;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.ServerDatabases;
import de.kapsi.net.daap.chunks.impl.ServerInfoResponse;
import de.kapsi.net.daap.chunks.impl.ServerRevision;
import de.kapsi.net.daap.chunks.impl.SessionId;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.SupportsAutoLogout;
import de.kapsi.net.daap.chunks.impl.SupportsExtensions;
import de.kapsi.net.daap.chunks.impl.SupportsPersistentIds;
import de.kapsi.net.daap.chunks.impl.SupportsUpdate;
import de.kapsi.net.daap.chunks.impl.TimeoutInterval;
import de.kapsi.net.daap.chunks.impl.UpdateResponse;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    private static final Log LOG = LogFactory.getLog(Library.class);
    private static long persistentId = 1L;
    private int revision = 0;
    private String name;
    private int totalDatabaseCount = 0;
    private final Set<Database> databases = new HashSet<Database>();
    private Set<Database> deletedDatabases = null;
    private final List<WeakReference<LibraryListener>> listener = new ArrayList<WeakReference<LibraryListener>>();
    protected boolean clone = false;

    protected Library(Library library, Transaction txn) {
        this.name = library.name;
        this.revision = library.revision;
        if (library.deletedDatabases != null) {
            this.deletedDatabases = library.deletedDatabases;
            library.deletedDatabases = null;
        }
        for (Database database : library.databases) {
            if (!txn.modified(database) || this.deletedDatabases != null && this.deletedDatabases.contains(database)) continue;
            Database clone = new Database(database, txn);
            this.databases.add(clone);
        }
        this.totalDatabaseCount = library.totalDatabaseCount;
        this.clone = true;
        this.init();
    }

    public Library(String name) {
        this.name = name;
        this.commit(null);
        this.init();
    }

    private void init() {
    }

    public synchronized int getRevision() {
        return this.revision;
    }

    public void setName(Transaction txn, final String name) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Library.this.setNameP(txn, name);
                }
            });
        } else {
            this.setNameP(txn, name);
        }
    }

    private void setNameP(Transaction txn, String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<Database> getDatabases() {
        return Collections.unmodifiableSet(this.databases);
    }

    public void addDatabase(Transaction txn, final Database database) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Library.this.addDatabaseP(txn, database);
                }
            });
            txn.attach(database);
        } else {
            this.addDatabaseP(txn, database);
        }
    }

    private void addDatabaseP(Transaction txn, Database database) {
        if (!this.databases.isEmpty()) {
            throw new DaapException("One Database per Library is maximum.");
        }
        if (this.databases.add(database)) {
            this.totalDatabaseCount = this.databases.size();
            if (this.deletedDatabases != null && this.deletedDatabases.remove(database) && this.deletedDatabases.isEmpty()) {
                this.deletedDatabases = null;
            }
        }
    }

    public void removeDatabase(Transaction txn, final Database database) {
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Library.this.removeDatabaseP(txn, database);
                }
            });
        } else {
            this.removeDatabaseP(txn, database);
        }
    }

    private void removeDatabaseP(Transaction txn, Database database) {
        if (this.databases.remove(database)) {
            this.totalDatabaseCount = this.databases.size();
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet<Database>();
            }
            this.deletedDatabases.add(database);
        }
    }

    public synchronized boolean containsDatabase(Database database) {
        return this.databases.contains(database);
    }

    public synchronized Transaction beginTransaction() {
        Transaction txn = new Transaction(this);
        return txn;
    }

    public synchronized Object select(DaapRequest request) {
        if (request.isServerInfoRequest()) {
            return this.getServerInfo(request);
        }
        if (request.isLoginRequest()) {
            return this.getLoginResponse(request);
        }
        if (request.isContentCodesRequest()) {
            return this.getContentCodes(request);
        }
        if (request.isUpdateRequest()) {
            return this.getUpdateResponse(request);
        }
        if (request.isDatabasesRequest()) {
            return this.getServerDatabases(request);
        }
        if (request.isSongRequest() || request.isDatabaseSongsRequest() || request.isDatabasePlaylistsRequest() || request.isPlaylistSongsRequest()) {
            Database database = this.getDatabase(request);
            if (database == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No database with this revision known: " + request.getRevisionNumber()));
                }
                return null;
            }
            return database.select(request);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unknown request: " + request));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Transaction txn) {
        if (txn == null) {
            txn = new Transaction(this);
            txn.addTxn(this, new Txn());
            txn.commit();
            return;
        }
        ++this.revision;
        Library diff = new Library(this, txn);
        List<WeakReference<LibraryListener>> list = this.listener;
        synchronized (list) {
            Iterator<WeakReference<LibraryListener>> it = this.listener.iterator();
            while (it.hasNext()) {
                LibraryListener l = (LibraryListener)it.next().get();
                if (l == null) {
                    it.remove();
                    continue;
                }
                l.libraryChanged(this, diff);
            }
        }
    }

    protected synchronized void rollback(Transaction txn) {
    }

    protected synchronized void close(Transaction txn) {
    }

    public int getDatabaseCount() {
        return this.databases.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Library)) {
            return false;
        }
        return o == this;
    }

    public String toString() {
        if (!this.clone) {
            return "Library(" + this.revision + ")";
        }
        return "LibraryPatch(" + this.revision + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long nextPersistentId() {
        Class<Library> clazz = Library.class;
        synchronized (Library.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return persistentId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibraryListener(LibraryListener l) {
        List<WeakReference<LibraryListener>> list = this.listener;
        synchronized (list) {
            this.listener.add(new WeakReference<LibraryListener>(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLibraryListener(LibraryListener l) {
        List<WeakReference<LibraryListener>> list = this.listener;
        synchronized (list) {
            Iterator<WeakReference<LibraryListener>> it = this.listener.iterator();
            while (it.hasNext()) {
                LibraryListener gotten = (LibraryListener)it.next().get();
                if (gotten != null && gotten != l) continue;
                it.remove();
            }
        }
    }

    protected Database getDatabase(DaapRequest request) {
        long databaseId = request.getDatabaseId();
        for (Database database : this.databases) {
            if (database.getItemId() != databaseId) continue;
            return database;
        }
        return null;
    }

    private LoginResponse getLoginResponse(DaapRequest request) {
        de.kapsi.net.daap.SessionId sessionId = request.getSessionId();
        if (sessionId.equals(de.kapsi.net.daap.SessionId.INVALID)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unknown SessionId, check Server code!");
            }
            return null;
        }
        LoginResponse loginResponse = new LoginResponse();
        loginResponse.add(new Status(200L));
        loginResponse.add(new SessionId(sessionId.intValue()));
        return loginResponse;
    }

    private ContentCodesResponse getContentCodes(DaapRequest request) {
        return new ContentCodesResponseImpl();
    }

    private UpdateResponse getUpdateResponse(DaapRequest request) {
        UpdateResponse updateResponse = new UpdateResponse();
        updateResponse.add(new Status(200L));
        updateResponse.add(new ServerRevision(this.getRevision()));
        return updateResponse;
    }

    private ServerDatabases getServerDatabases(DaapRequest request) {
        ServerDatabases serverDatabases = new ServerDatabases();
        serverDatabases.add(new Status(200L));
        serverDatabases.add(new UpdateType(request.isUpdateType() ? 1 : 0));
        serverDatabases.add(new SpecifiedTotalCount(this.totalDatabaseCount));
        serverDatabases.add(new ReturnedCount(this.databases.size()));
        Listing listing = new Listing();
        for (Database database : this.databases) {
            ListingItem listingItem = new ListingItem();
            listingItem.add(new ItemId(database.getItemId()));
            listingItem.add(new PersistentId(database.getPersistentId()));
            listingItem.add(new ItemName(database.getName()));
            listingItem.add(new ItemCount(database.getSongCount()));
            listingItem.add(new ContainerCount(database.getPlaylistCount()));
            listing.add(listingItem);
        }
        serverDatabases.add(listing);
        if (request.isUpdateType() && this.deletedDatabases != null) {
            DeletedIdListing deletedListing = new DeletedIdListing();
            for (Database database : this.deletedDatabases) {
                deletedListing.add(new ItemId(database.getItemId()));
            }
            serverDatabases.add(deletedListing);
        }
        return serverDatabases;
    }

    private ServerInfoResponse getServerInfo(DaapRequest request) {
        DaapConnection connection = request.getConnection();
        int version = connection.getProtocolVersion();
        if (version < 196608) {
            return null;
        }
        DaapServer server = request.getServer();
        DaapConfig config = server.getConfig();
        ServerInfoResponse serverInfoResponse = new ServerInfoResponse();
        serverInfoResponse.add(new Status(200L));
        serverInfoResponse.add(new TimeoutInterval(1800L));
        serverInfoResponse.add(new DmapProtocolVersion(131073));
        serverInfoResponse.add(new DaapProtocolVersion(196608));
        serverInfoResponse.add(new MusicSharingVersion(131073L));
        serverInfoResponse.add(new ItemName(this.name));
        serverInfoResponse.add(new LoginRequired(true));
        serverInfoResponse.add(new SupportsAutoLogout(true));
        serverInfoResponse.add(new SupportsUpdate(true));
        serverInfoResponse.add(new SupportsPersistentIds(true));
        serverInfoResponse.add(new SupportsExtensions(true));
        Object authenticationMethod = config.getAuthenticationMethod();
        if (!authenticationMethod.equals(DaapConfig.NO_PASSWORD)) {
            if (authenticationMethod.equals(DaapConfig.PASSWORD)) {
                serverInfoResponse.add(new AuthenticationMethod(2));
            } else {
                serverInfoResponse.add(new AuthenticationMethod(1));
            }
            serverInfoResponse.add(new AuthenticationSchemes(3));
        }
        serverInfoResponse.add(new DatabaseCount(this.getDatabaseCount()));
        return serverInfoResponse;
    }
}

