/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapRequestProcessor;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.SessionId;
import de.kapsi.net.daap.bio.DaapResponseFactoryBIO;
import de.kapsi.net.daap.bio.DaapServerBIO;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapConnectionBIO
extends DaapConnection
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DaapConnectionBIO.class);
    private static final DaapResponseFactory FACTORY = new DaapResponseFactoryBIO();
    private static final DaapRequestProcessor PROCESSOR = new DaapRequestProcessor(FACTORY);
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private boolean running = false;

    public DaapConnectionBIO(DaapServerBIO server, Socket socket) throws IOException {
        super(server);
        this.socket = socket;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.out = socket.getOutputStream();
        this.running = true;
    }

    private boolean read() throws IOException {
        DaapRequest request = this.readRequest();
        if (!this.isAudioStream()) {
            DaapResponse response;
            if (this.isUndef()) {
                if (request.isSongRequest()) {
                    this.setConnectionType(2);
                    this.socket.shutdownInput();
                    SessionId sid = request.getSessionId();
                    if (!((DaapServerBIO)this.server).isSessionIdValid(sid)) {
                        throw new IOException("Unknown Session-ID: " + sid);
                    }
                    DaapConnectionBIO connection = ((DaapServerBIO)this.server).getDaapConnection(sid);
                    if (connection == null) {
                        throw new IOException("No connection associated with this Session-ID: " + sid);
                    }
                    DaapConnectionBIO audio = ((DaapServerBIO)this.server).getAudioConnection(sid);
                    if (audio != null) {
                        throw new IOException("Multiple audio connections not allowed: " + sid);
                    }
                    this.setProtocolVersion(connection.getProtocolVersion());
                } else if (request.isServerInfoRequest()) {
                    this.setConnectionType(1);
                    this.setProtocolVersion(DaapUtil.getProtocolVersion(request));
                } else {
                    throw new IOException("Illegal first request: " + request);
                }
                if (!DaapUtil.isSupportedProtocolVersion(this.getProtocolVersion())) {
                    throw new IOException("Unsupported Protocol Version: " + this.getProtocolVersion());
                }
                if (!((DaapServerBIO)this.server).updateConnection(this)) {
                    throw new IOException("Too many connections");
                }
                this.socket.setSoTimeout(30000);
            }
            if ((response = PROCESSOR.process(request)) != null) {
                this.writer.add(response);
            }
            return true;
        }
        throw new IOException("Cannot read requests from audio stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                try {
                    this.read();
                }
                catch (SocketTimeoutException err) {
                    if (this.isDaapConnection() && err.bytesTransferred == 0) {
                        this.clearLibraryQueue();
                        continue;
                    }
                    throw err;
                }
            } while (this.running && this.write());
        }
        catch (DaapStreamException err) {
        }
        catch (SocketException err) {
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        finally {
            this.close();
        }
    }

    public synchronized void update() throws IOException {
        DaapSession session;
        if (this.isDaapConnection() && !this.isLocked() && (session = this.getSession(false)) != null) {
            SessionId sessionId = session.getSessionId();
            Integer delta = (Integer)session.getAttribute("CLIENT_REVISION");
            Integer revisionNumber = new Integer(this.getFirstInQueue().getRevision());
            DaapRequest request = new DaapRequest((DaapConnection)this, sessionId, revisionNumber, delta);
            DaapResponse response = PROCESSOR.process(request);
            if (response != null) {
                response.write();
            }
        }
    }

    protected synchronized void disconnect() {
        this.running = false;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            super.close();
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException err) {
                LOG.error((Object)"Error while closing connection", (Throwable)err);
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException err) {
                LOG.error((Object)"Error while closing connection", (Throwable)err);
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException err) {
                LOG.error((Object)"Error while closing connection", (Throwable)err);
            }
        }
        finally {
            if (this.running) {
                ((DaapServerBIO)this.server).removeConnection(this);
            }
        }
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    private DaapRequest readRequest() throws IOException {
        String line = null;
        while ((line = HttpParser.readLine((InputStream)this.in)) != null && line.length() == 0) {
        }
        if (line == null) {
            throw new IOException("Request is null: " + this);
        }
        DaapRequest request = new DaapRequest(this, line);
        Header[] headers = HttpParser.parseHeaders((InputStream)this.in);
        request.addHeaders(headers);
        return request;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("DaapConnection [");
        buffer.append("Host: ").append(this.socket.getInetAddress()).append(":").append(this.socket.getPort());
        buffer.append(", audioStream: ").append(this.isAudioStream());
        buffer.append(", hasSession: ").append(this.getSession(false) != null);
        return buffer.append("]").toString();
    }
}

