/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PoolUtils {
    private static Timer MIN_IDLE_TIMER;

    public static <V> PoolableObjectFactory<V> adapt(KeyedPoolableObjectFactory<V> keyedFactory) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedFactory, new Object());
    }

    public static <V> PoolableObjectFactory<V> adapt(KeyedPoolableObjectFactory<V> keyedFactory, Object key) throws IllegalArgumentException {
        return new PoolableObjectFactoryAdaptor<V>(keyedFactory, key);
    }

    public static <V> KeyedPoolableObjectFactory<V> adapt(PoolableObjectFactory<V> factory) throws IllegalArgumentException {
        return new KeyedPoolableObjectFactoryAdaptor<V>(factory);
    }

    public static <V> ObjectPool<V> adapt(KeyedObjectPool<V> keyedPool) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedPool, new Object());
    }

    public static <V> ObjectPool<V> adapt(KeyedObjectPool<V> keyedPool, Object key) throws IllegalArgumentException {
        return new ObjectPoolAdaptor<V>(keyedPool, key);
    }

    public static <V> KeyedObjectPool<V> adapt(ObjectPool<V> pool) throws IllegalArgumentException {
        return new KeyedObjectPoolAdaptor<V>(pool);
    }

    public static <V> ObjectPool<V> checkedPool(ObjectPool<V> pool, Class<? super V> type) {
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedObjectPool<V>(pool, type);
    }

    public static <V> KeyedObjectPool<V> checkedPool(KeyedObjectPool<V> keyedPool, Class<? super V> type) {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedKeyedObjectPool<V>(keyedPool, type);
    }

    public static TimerTask checkMinIdle(ObjectPool<?> pool, int minIdle, long period) throws IllegalArgumentException {
        if (pool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (minIdle < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        ObjectPoolMinIdleTimerTask task = new ObjectPoolMinIdleTimerTask(pool, minIdle);
        PoolUtils.getMinIdleTimer().schedule((TimerTask)task, 0L, period);
        return task;
    }

    public static TimerTask checkMinIdle(KeyedObjectPool<?> keyedPool, Object key, int minIdle, long period) throws IllegalArgumentException {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        if (minIdle < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        KeyedObjectPoolMinIdleTimerTask task = new KeyedObjectPoolMinIdleTimerTask(keyedPool, key, minIdle);
        PoolUtils.getMinIdleTimer().schedule((TimerTask)task, 0L, period);
        return task;
    }

    public static <T> Map checkMinIdle(KeyedObjectPool<?> keyedPool, Collection<T> keys, int minIdle, long period) throws IllegalArgumentException {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        HashMap<T, TimerTask> tasks = new HashMap<T, TimerTask>(keys.size());
        for (T key : keys) {
            TimerTask task = PoolUtils.checkMinIdle(keyedPool, key, minIdle, period);
            tasks.put(key, task);
        }
        return tasks;
    }

    public static void prefill(ObjectPool<?> pool, int count) throws Exception, IllegalArgumentException {
        if (pool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        for (int i = 0; i < count; ++i) {
            pool.addObject();
        }
    }

    public static void prefill(KeyedObjectPool<?> keyedPool, Object key, int count) throws Exception, IllegalArgumentException {
        if (keyedPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i = 0; i < count; ++i) {
            keyedPool.addObject(key);
        }
    }

    public static void prefill(KeyedObjectPool<?> keyedPool, Collection<?> keys, int count) throws Exception, IllegalArgumentException {
        if (keys == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        Iterator<?> iter = keys.iterator();
        while (iter.hasNext()) {
            PoolUtils.prefill(keyedPool, iter.next(), count);
        }
    }

    public static <V> ObjectPool<V> synchronizedPool(ObjectPool<V> pool) {
        return new SynchronizedObjectPool<V>(pool);
    }

    public static <V> KeyedObjectPool<V> synchronizedPool(KeyedObjectPool<V> keyedPool) {
        return new SynchronizedKeyedObjectPool<V>(keyedPool);
    }

    public static <V> PoolableObjectFactory<V> synchronizedPoolableFactory(PoolableObjectFactory<V> factory) {
        return new SynchronizedPoolableObjectFactory<V>(factory);
    }

    public static <V> KeyedPoolableObjectFactory<V> synchronizedPoolableFactory(KeyedPoolableObjectFactory<V> keyedFactory) {
        return new SynchronizedKeyedPoolableObjectFactory<V>(keyedFactory);
    }

    private static synchronized Timer getMinIdleTimer() {
        if (MIN_IDLE_TIMER == null) {
            MIN_IDLE_TIMER = new Timer(true);
        }
        return MIN_IDLE_TIMER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedKeyedPoolableObjectFactory<V>
    implements KeyedPoolableObjectFactory<V> {
        private final Object lock;
        private final KeyedPoolableObjectFactory<V> keyedFactory;

        SynchronizedKeyedPoolableObjectFactory(KeyedPoolableObjectFactory<V> keyedFactory) throws IllegalArgumentException {
            if (keyedFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedFactory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V makeObject(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.makeObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.destroyObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.validateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.activateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passivateObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.passivateObject(key, obj);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedKeyedPoolableObjectFactory");
            sb.append("{keyedFactory=").append(this.keyedFactory);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedPoolableObjectFactory<V>
    implements PoolableObjectFactory<V> {
        private final Object lock;
        private final PoolableObjectFactory<V> factory;

        SynchronizedPoolableObjectFactory(PoolableObjectFactory<V> factory) throws IllegalArgumentException {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = factory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V makeObject() {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.makeObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.factory.destroyObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.validateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.factory.activateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passivateObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.factory.passivateObject(obj);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedPoolableObjectFactory");
            sb.append("{factory=").append(this.factory);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedKeyedObjectPool<V>
    implements KeyedObjectPool<V> {
        private final Object lock;
        private final KeyedObjectPool<V> keyedPool;

        SynchronizedKeyedObjectPool(KeyedObjectPool<V> keyedPool) throws IllegalArgumentException {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.keyedPool = keyedPool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V borrowObject(Object key) throws NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.borrowObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.returnObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(Object key, V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.invalidateObject(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addObject(Object key) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.addObject(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle(Object key) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive(Object key) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(Object key) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFactory(KeyedPoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.setFactory(factory);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedKeyedObjectPool");
            sb.append("{keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedObjectPool<V>
    implements ObjectPool<V> {
        private final Object lock;
        private final ObjectPool<V> pool;

        SynchronizedObjectPool(ObjectPool<V> pool) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V borrowObject() throws NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.borrowObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.pool.returnObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(V obj) {
            Object object = this.lock;
            synchronized (object) {
                this.pool.invalidateObject(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addObject() throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.addObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.pool.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFactory(PoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.setFactory(factory);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SynchronizedObjectPool");
            sb.append("{keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedObjectPoolMinIdleTimerTask
    extends TimerTask {
        private final int minIdle;
        private final Object key;
        private final KeyedObjectPool<?> pool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<?> pool, Object key, int minIdle) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
            this.key = key;
            this.minIdle = minIdle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            try {
                if (this.pool.getNumIdle(this.key) < this.minIdle) {
                    this.pool.addObject(this.key);
                }
                success = true;
            }
            catch (Exception e) {
                this.cancel();
            }
            finally {
                if (!success) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedObjectPoolMinIdleTimerTask");
            sb.append("{minIdle=").append(this.minIdle);
            sb.append(", key=").append(this.key);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectPoolMinIdleTimerTask
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool<?> pool;

        ObjectPoolMinIdleTimerTask(ObjectPool<?> pool, int minIdle) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("poll must not be null.");
            }
            this.pool = pool;
            this.minIdle = minIdle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                success = true;
            }
            catch (Exception e) {
                this.cancel();
            }
            finally {
                if (!success) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ObjectPoolMinIdleTimerTask");
            sb.append("{minIdle=").append(this.minIdle);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedKeyedObjectPool<V>
    implements KeyedObjectPool<V> {
        private final Class<? super V> type;
        private final KeyedObjectPool<V> keyedPool;

        CheckedKeyedObjectPool(KeyedObjectPool<V> keyedPool, Class<? super V> type) {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (type == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.keyedPool = keyedPool;
            this.type = type;
        }

        @Override
        public V borrowObject(Object key) throws NoSuchElementException, IllegalStateException {
            V obj = this.keyedPool.borrowObject(key);
            if (this.type.isInstance(obj)) {
                return obj;
            }
            throw new ClassCastException("Borrowed object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
        }

        @Override
        public void returnObject(Object key, V obj) {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Returned object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.keyedPool.returnObject(key, obj);
        }

        @Override
        public void invalidateObject(Object key, V obj) {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Invalidated object for key: " + key + " is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.keyedPool.invalidateObject(key, obj);
        }

        @Override
        public void addObject(Object key) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.addObject(key);
        }

        @Override
        public int getNumIdle(Object key) throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(key);
        }

        @Override
        public int getNumActive(Object key) throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(key);
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive();
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            this.keyedPool.clear();
        }

        @Override
        public void clear(Object key) throws UnsupportedOperationException {
            this.keyedPool.clear(key);
        }

        @Override
        public void close() {
            this.keyedPool.close();
        }

        @Override
        public void setFactory(KeyedPoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(factory);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CheckedKeyedObjectPool");
            sb.append("{type=").append(this.type);
            sb.append(", keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedObjectPool<V>
    implements ObjectPool<V> {
        private final Class<? super V> type;
        private final ObjectPool<V> pool;

        CheckedObjectPool(ObjectPool<V> pool, Class<? super V> type) {
            if (pool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            if (type == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.pool = pool;
            this.type = type;
        }

        @Override
        public V borrowObject() throws NoSuchElementException, IllegalStateException {
            V obj = this.pool.borrowObject();
            if (this.type.isInstance(obj)) {
                return obj;
            }
            throw new ClassCastException("Borrowed object is not of type: " + this.type.getName() + " was: " + obj);
        }

        @Override
        public void returnObject(V obj) {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Returned object is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.pool.returnObject(obj);
        }

        @Override
        public void invalidateObject(V obj) {
            if (!this.type.isInstance(obj)) {
                throw new ClassCastException("Invalidated object is not of type: " + this.type.getName() + " was: " + obj);
            }
            this.pool.invalidateObject(obj);
        }

        @Override
        public void addObject() throws IllegalStateException, UnsupportedOperationException {
            this.pool.addObject();
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void close() {
            this.pool.close();
        }

        @Override
        public void setFactory(PoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(factory);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CheckedObjectPool");
            sb.append("{type=").append(this.type);
            sb.append(", keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedObjectPoolAdaptor<V>
    implements KeyedObjectPool<V> {
        private final ObjectPool<V> pool;

        KeyedObjectPoolAdaptor(ObjectPool<V> pool) throws IllegalArgumentException {
            if (pool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.pool = pool;
        }

        @Override
        public V borrowObject(Object key) throws NoSuchElementException, IllegalStateException {
            return this.pool.borrowObject();
        }

        @Override
        public void returnObject(Object key, V obj) {
            this.pool.returnObject(obj);
        }

        @Override
        public void invalidateObject(Object key, V obj) {
            this.pool.invalidateObject(obj);
        }

        @Override
        public void addObject(Object key) throws IllegalStateException {
            this.pool.addObject();
        }

        @Override
        public int getNumIdle(Object key) throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive(Object key) throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void clear(Object key) throws UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void close() {
            this.pool.close();
        }

        @Override
        public void setFactory(KeyedPoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(PoolUtils.adapt(factory));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedObjectPoolAdaptor");
            sb.append("{keyedPool=").append(this.pool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectPoolAdaptor<V>
    implements ObjectPool<V> {
        private final Object key;
        private final KeyedObjectPool<V> keyedPool;

        ObjectPoolAdaptor(KeyedObjectPool<V> keyedPool, Object key) throws IllegalArgumentException {
            if (keyedPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedPool = keyedPool;
            this.key = key;
        }

        @Override
        public V borrowObject() throws NoSuchElementException, IllegalStateException {
            return this.keyedPool.borrowObject(this.key);
        }

        @Override
        public void returnObject(V obj) {
            this.keyedPool.returnObject(this.key, obj);
        }

        @Override
        public void invalidateObject(V obj) {
            this.keyedPool.invalidateObject(this.key, obj);
        }

        @Override
        public void addObject() throws IllegalStateException {
            this.keyedPool.addObject(this.key);
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(this.key);
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(this.key);
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            this.keyedPool.clear();
        }

        @Override
        public void close() {
            this.keyedPool.close();
        }

        @Override
        public void setFactory(PoolableObjectFactory<V> factory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(PoolUtils.adapt(factory));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ObjectPoolAdaptor");
            sb.append("{key=").append(this.key);
            sb.append(", keyedPool=").append(this.keyedPool);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedPoolableObjectFactoryAdaptor<V>
    implements KeyedPoolableObjectFactory<V> {
        private final PoolableObjectFactory<V> factory;

        KeyedPoolableObjectFactoryAdaptor(PoolableObjectFactory<V> factory) throws IllegalArgumentException {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = factory;
        }

        @Override
        public V makeObject(Object key) {
            return this.factory.makeObject();
        }

        @Override
        public void destroyObject(Object key, V obj) {
            this.factory.destroyObject(obj);
        }

        @Override
        public boolean validateObject(Object key, V obj) {
            return this.factory.validateObject(obj);
        }

        @Override
        public void activateObject(Object key, V obj) {
            this.factory.activateObject(obj);
        }

        @Override
        public void passivateObject(Object key, V obj) {
            this.factory.passivateObject(obj);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("KeyedPoolableObjectFactoryAdaptor");
            sb.append("{factory=").append(this.factory);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PoolableObjectFactoryAdaptor<V>
    implements PoolableObjectFactory<V> {
        private final Object key;
        private final KeyedPoolableObjectFactory<V> keyedFactory;

        PoolableObjectFactoryAdaptor(KeyedPoolableObjectFactory<V> keyedFactory, Object key) throws IllegalArgumentException {
            if (keyedFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedFactory = keyedFactory;
            this.key = key;
        }

        @Override
        public V makeObject() {
            return this.keyedFactory.makeObject(this.key);
        }

        @Override
        public void destroyObject(V obj) {
            this.keyedFactory.destroyObject(this.key, obj);
        }

        @Override
        public boolean validateObject(V obj) {
            return this.keyedFactory.validateObject(this.key, obj);
        }

        @Override
        public void activateObject(V obj) {
            this.keyedFactory.activateObject(this.key, obj);
        }

        @Override
        public void passivateObject(V obj) {
            this.keyedFactory.passivateObject(this.key, obj);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PoolableObjectFactoryAdaptor");
            sb.append("{key=").append(this.key);
            sb.append(", keyedFactory=").append(this.keyedFactory);
            sb.append('}');
            return sb.toString();
        }
    }
}

