/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceObjectPool<V>
extends BaseObjectPool<V>
implements ObjectPool<V> {
    private List<SoftReference<V>> _pool = new ArrayList<SoftReference<V>>();
    private PoolableObjectFactory<V> _factory = null;
    private int _numActive = 0;

    public SoftReferenceObjectPool() {
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory<V> factory) {
        this._factory = factory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory<V> factory, int initSize) throws Exception {
        this._factory = factory;
        if (null != this._factory) {
            for (int i = 0; i < initSize; ++i) {
                V obj = this._factory.makeObject();
                this._factory.passivateObject(obj);
                this._pool.add(new SoftReference<V>(obj));
            }
        }
    }

    @Override
    public synchronized V borrowObject() {
        this.assertOpen();
        Object obj = null;
        while (null == obj) {
            if (this._pool.isEmpty()) {
                if (null == this._factory) {
                    throw new NoSuchElementException();
                }
                obj = this._factory.makeObject();
            } else {
                SoftReference<V> ref = this._pool.remove(this._pool.size() - 1);
                obj = ref.get();
            }
            if (null != this._factory && null != obj) {
                this._factory.activateObject(obj);
            }
            if (null == this._factory || null == obj || this._factory.validateObject(obj)) continue;
            this._factory.destroyObject(obj);
            obj = null;
        }
        ++this._numActive;
        return obj;
    }

    @Override
    public synchronized void returnObject(V obj) {
        this.assertOpen();
        boolean success = true;
        if (!this._factory.validateObject(obj)) {
            success = false;
        } else {
            try {
                this._factory.passivateObject(obj);
            }
            catch (Exception e) {
                success = false;
            }
        }
        boolean shouldDestroy = !success;
        --this._numActive;
        if (success) {
            this._pool.add(new SoftReference<V>(obj));
        }
        this.notifyAll();
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void invalidateObject(V obj) {
        this.assertOpen();
        --this._numActive;
        this._factory.destroyObject(obj);
        this.notifyAll();
    }

    @Override
    public synchronized void addObject() {
        this.assertOpen();
        V obj = this._factory.makeObject();
        ++this._numActive;
        this.returnObject(obj);
    }

    @Override
    public synchronized int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    @Override
    public synchronized int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    @Override
    public synchronized void clear() {
        this.assertOpen();
        if (null != this._factory) {
            for (SoftReference<V> ref : this._pool) {
                try {
                    V obj = ref.get();
                    if (null == obj) continue;
                    this._factory.destroyObject(obj);
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    @Override
    public synchronized void close() {
        this.clear();
        this._pool = null;
        this._factory = null;
        super.close();
    }

    @Override
    public synchronized void setFactory(PoolableObjectFactory<V> factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }
}

