/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackKeyedObjectPool<V>
extends BaseKeyedObjectPool<V>
implements KeyedObjectPool<V> {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected HashMap<Object, Stack<V>> _pools = null;
    protected KeyedPoolableObjectFactory<V> _factory = null;
    protected int _maxSleeping = 8;
    protected int _initSleepingCapacity = 4;
    protected int _totActive = 0;
    protected int _totIdle = 0;
    protected HashMap<Object, Integer> _activeCount = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(int max) {
        this(null, max, 4);
    }

    public StackKeyedObjectPool(int max, int init) {
        this(null, max, init);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<V> factory) {
        this(factory, 8);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<V> factory, int max) {
        this(factory, max, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<V> factory, int max, int init) {
        this._factory = factory;
        this._maxSleeping = max < 0 ? 8 : max;
        this._initSleepingCapacity = init < 1 ? 4 : init;
        this._pools = new HashMap();
        this._activeCount = new HashMap();
    }

    @Override
    public synchronized V borrowObject(Object key) {
        Object obj = null;
        Stack<Object> stack = this._pools.get(key);
        if (null == stack) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(key, stack);
        }
        try {
            obj = stack.pop();
            --this._totIdle;
        }
        catch (Exception e) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            obj = this._factory.makeObject(key);
        }
        if (null != obj && null != this._factory) {
            this._factory.activateObject(key, obj);
        }
        this.incrementActiveCount(key);
        return obj;
    }

    @Override
    public synchronized void returnObject(Object key, V obj) {
        this.decrementActiveCount(key);
        if (null == this._factory || this._factory.validateObject(key, obj)) {
            Stack<Object> stack = this._pools.get(key);
            if (null == stack) {
                stack = new Stack();
                stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
                this._pools.put(key, stack);
            }
            if (null != this._factory) {
                try {
                    this._factory.passivateObject(key, obj);
                }
                catch (Exception e) {
                    this._factory.destroyObject(key, obj);
                    return;
                }
            }
            if (stack.size() < this._maxSleeping) {
                stack.push(obj);
                ++this._totIdle;
            } else if (null != this._factory) {
                this._factory.destroyObject(key, obj);
            }
        } else if (null != this._factory) {
            this._factory.destroyObject(key, obj);
        }
    }

    @Override
    public synchronized void invalidateObject(Object key, V obj) {
        this.decrementActiveCount(key);
        if (null != this._factory) {
            this._factory.destroyObject(key, obj);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void addObject(Object key) {
        V obj = this._factory.makeObject(key);
        this.incrementActiveCount(key);
        this.returnObject(key, obj);
    }

    @Override
    public int getNumIdle() {
        return this._totIdle;
    }

    @Override
    public int getNumActive() {
        return this._totActive;
    }

    @Override
    public synchronized int getNumActive(Object key) {
        return this.getActiveCount(key);
    }

    @Override
    public synchronized int getNumIdle(Object key) {
        try {
            return this._pools.get(key).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public synchronized void clear() {
        for (Object key : this._pools.keySet()) {
            this.destroyStack(key, this._pools.get(key));
        }
        this._totIdle = 0;
        this._pools.clear();
        this._activeCount.clear();
    }

    @Override
    public synchronized void clear(Object key) {
        Stack<V> stack = this._pools.remove(key);
        this.destroyStack(key, stack);
    }

    private synchronized void destroyStack(Object key, Stack<V> stack) {
        if (null == stack) {
            return;
        }
        if (null != this._factory) {
            for (Object obj : stack) {
                try {
                    this._factory.destroyObject(key, obj);
                }
                catch (Exception e) {}
            }
        }
        this._totIdle -= stack.size();
        this._activeCount.remove(key);
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" contains ").append(this._pools.size()).append(" distinct pools: ");
        for (Object key : this._pools.keySet()) {
            buf.append(" |").append(key).append("|=");
            Stack<V> s = this._pools.get(key);
            buf.append(s.size());
        }
        return buf.toString();
    }

    @Override
    public synchronized void close() {
        this.clear();
        this._pools = null;
        this._factory = null;
        this._activeCount = null;
    }

    @Override
    public synchronized void setFactory(KeyedPoolableObjectFactory<V> factory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    private int getActiveCount(Object key) {
        try {
            return this._activeCount.get(key);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    private void incrementActiveCount(Object key) {
        ++this._totActive;
        Integer old = this._activeCount.get(key);
        if (null == old) {
            this._activeCount.put(key, new Integer(1));
        } else {
            this._activeCount.put(key, new Integer(old + 1));
        }
    }

    private void decrementActiveCount(Object key) {
        --this._totActive;
        Integer active = this._activeCount.get(key);
        if (null != active) {
            if (active <= 1) {
                this._activeCount.remove(key);
            } else {
                this._activeCount.put(key, new Integer(active - 1));
            }
        }
    }
}

