/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.io.DecryptStream;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.sign.Signature;

public class VerifyStream
extends FilterInputStream {
    private HashState fs;
    private SignatureKey key;
    private DecryptStream drainer;
    private byte[] buffer;
    private int bufPos;
    private int bufSize;
    private int newBufSize = -1;

    public synchronized int read() throws IOException {
        if (this.bufPos == this.bufSize) {
            this.fillBuffer(true);
        }
        if (this.buffer == null) {
            return -1;
        }
        return this.buffer[this.bufPos++] & 0xFF;
    }

    private void fillBuffer(boolean bl) throws IOException {
        block16: {
            try {
                if (!bl && this.in.available() < 4) {
                    return;
                }
                if (this.newBufSize == -1) {
                    this.newBufSize = Crypto.readInt(this.in);
                    if (this.newBufSize > this.buffer.length) {
                        throw new IOException("The stream contains a block of size " + this.newBufSize + " which is larger than the buffer size " + this.buffer.length);
                    }
                }
                if (!bl && this.in.available() < this.newBufSize) {
                    return;
                }
            }
            catch (IOException iOException) {
                this.buffer = null;
            }
            this.bufSize = this.newBufSize;
            this.newBufSize = -1;
            try {
                this.bufPos = 0;
                while (this.bufPos < this.bufSize) {
                    int n = this.in.read(this.buffer, this.bufPos, this.bufSize - this.bufPos);
                    if (n < 0) {
                        this.buffer = null;
                        return;
                    }
                    this.bufPos += n;
                }
                this.bufPos = 0;
                byte[] byArray = new byte[this.key == null ? this.fs.hashSize() : this.key.signatureSize()];
                int n = Crypto.readBlock(this.in, byArray, 0, byArray.length);
                if (n < 0) {
                    this.buffer = null;
                    return;
                }
                this.fs.update(this.buffer, 0, this.bufSize);
                Fingerprint fingerprint = this.fs.calculate();
                if (this.key == null) {
                    if (!Crypto.equal(byArray, fingerprint.getBytes())) {
                        throw new IOException("Data was not verified");
                    }
                    break block16;
                }
                Signature signature = new Signature(byArray, fingerprint.getName(), this.key.getFingerprint());
                try {
                    if (!this.key.verify(signature, fingerprint)) {
                        throw new IOException("Signature was not verified");
                    }
                }
                catch (KeyException keyException) {
                    throw new IOException(keyException.getMessage());
                }
            }
            catch (IOException iOException) {
                this.buffer = null;
                throw iOException;
            }
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufPos == this.bufSize) {
            this.fillBuffer(true);
        }
        if (this.buffer == null) {
            return -1;
        }
        if (n2 > this.bufSize - this.bufPos) {
            n2 = this.bufSize - this.bufPos;
        }
        System.arraycopy(this.buffer, this.bufPos, byArray, n, n2);
        this.bufPos += n2;
        return n2;
    }

    public int drain() {
        if (this.drainer != null) {
            return this.drainer.drain();
        }
        return 0;
    }

    public int available() throws IOException {
        if (this.bufSize == this.bufPos) {
            this.fillBuffer(false);
        }
        return this.bufSize - this.bufPos;
    }

    public long skip(long l) throws IOException {
        return 0L;
    }

    public boolean markSupported() {
        return false;
    }

    public VerifyStream(InputStream inputStream, int n, SignatureKey signatureKey, HashState hashState) {
        super(inputStream);
        if (inputStream instanceof DecryptStream) {
            this.drainer = (DecryptStream)inputStream;
        }
        this.key = signatureKey;
        this.bufSize = n / hashState.blockSize() * hashState.blockSize();
        if (this.bufSize == 0) {
            this.bufSize = hashState.blockSize();
        }
        this.buffer = new byte[this.bufSize];
        this.bufPos = this.bufSize;
        this.fs = hashState;
    }
}

