/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class TCPConnectBackVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    private final int _port;

    TCPConnectBackVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_BEAR_VENDOR_ID, 7, n, byArray2);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + byArray2.length);
        }
        this._port = ByteOrder.ubytes2int(ByteOrder.leb2short(this.getPayload(), 0));
        if (!NetworkUtils.isValidPort(this._port)) {
            throw new BadPacketException("invalid port");
        }
    }

    public TCPConnectBackVendorMessage(int n) {
        super(VendorMessage.F_BEAR_VENDOR_ID, 7, 1, TCPConnectBackVendorMessage.derivePayload(n));
        this._port = n;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    private static byte[] derivePayload(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

