/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.connection.ConnectionChecker;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.SystemUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    private volatile long _disconnectTime = -1L;
    private volatile long _connectTime = Long.MAX_VALUE;
    private volatile long _automaticConnectTime = 0L;
    private volatile boolean _automaticallyConnecting;
    private volatile long _lastSuccessfulConnect = 0L;
    private volatile long _lastConnectionCheck = 0L;
    private static volatile int _connectionAttempts;
    private static final Log LOG;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 3;
    public static final int CONNECT_BACK_REDUNDANT_REQUESTS = 3;
    private static final int MINIMUM_IDLE_TIME = 1800000;
    public static final int RESERVED_NON_LIMEWIRE_LEAVES = 2;
    private volatile int _preferredConnections = -1;
    private HostCatcher _catcher;
    private final List _fetchers = new ArrayList();
    private final List _initializingFetchedConnections = new ArrayList();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private boolean _needPrefInterrupterScheduled = false;
    private volatile List _connections = Collections.EMPTY_LIST;
    private volatile List _initializedConnections = Collections.EMPTY_LIST;
    private volatile List _initializedClientConnections = Collections.EMPTY_LIST;
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    private volatile int _leafTries;
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.ConnectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void initialize() {
        this._catcher = RouterService.getHostCatcher();
        if (SystemUtils.supportsIdleTime()) {
            RouterService.schedule(new Runnable(){

                public void run() {
                    ConnectionManager.this.setPreferredConnections();
                }
            }, 1000L, 1000L);
        }
    }

    public ManagedConnection createConnectionBlocking(String string, int n) throws IOException {
        ManagedConnection managedConnection = new ManagedConnection(string, n);
        this.initializeExternallyGeneratedConnection(managedConnection, null);
        ThreadFactory.startThread(new OutgoingConnector(managedConnection, false), "OutgoingConnector");
        return managedConnection;
    }

    public void createConnectionAsynchronously(String string, int n) {
        OutgoingConnector outgoingConnector = new OutgoingConnector(new ManagedConnection(string, n), true);
        ThreadFactory.startThread(outgoingConnector, "OutgoingConnectionThread");
    }

    void acceptConnection(Socket socket) {
        ManagedConnection managedConnection = new ManagedConnection(socket);
        IncomingGNetObserver incomingGNetObserver = null;
        if (managedConnection.isAsynchronous()) {
            incomingGNetObserver = new IncomingGNetObserver(managedConnection);
        } else {
            Thread.currentThread().setName("IncomingConnectionThread");
        }
        try {
            this.initializeExternallyGeneratedConnection(managedConnection, incomingGNetObserver);
        }
        catch (IOException iOException) {
            managedConnection.close();
            return;
        }
        if (incomingGNetObserver == null) {
            try {
                this.startConnection(managedConnection);
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void remove(ManagedConnection managedConnection) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(managedConnection);
        this.adjustConnectionFetchers();
    }

    public boolean isSupernode() {
        return this.isActiveSupernode() || this.isSupernodeCapable();
    }

    public boolean isSupernodeCapable() {
        return !NetworkUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() && !this.isBehindProxy() && this.minConnectTimePassed();
    }

    private boolean minConnectTimePassed() {
        if (!UltrapeerSettings.NEED_MIN_CONNECT_TIME.getValue()) {
            return true;
        }
        return Math.max(0L, System.currentTimeMillis() - this._connectTime) / 1000L >= (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue();
    }

    public boolean isBehindProxy() {
        return ConnectionSettings.CONNECTION_METHOD.getValue() != 0;
    }

    public boolean isActiveSupernode() {
        return !this.isShieldedLeaf() && (this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0);
    }

    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    boolean isConnectedTo(String string) {
        List list = this.getConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.getAddress().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isConnectingTo(IpPort ipPort) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Object object;
            int n = 0;
            while (n < this._fetchers.size()) {
                object = (ConnectionFetcher)this._fetchers.get(n);
                IpPort ipPort2 = ((ConnectionFetcher)object).getIpPort();
                if (ipPort2 != null && ipPort.getAddress().equals(ipPort2.getAddress()) && ipPort.getPort() == ipPort2.getPort()) {
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < this._initializingFetchedConnections.size()) {
                object = (ManagedConnection)this._initializingFetchedConnections.get(n);
                if (ipPort.getAddress().equals(((Connection)object).getAddress()) && ipPort.getPort() == ((Connection)object).getPort()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    public int getNumFreeNonLeafSlots() {
        return this._preferredConnections - this.getNumInitializedConnections();
    }

    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections) - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    public boolean isLocaleMatched() {
        return !ConnectionSettings.USE_LOCALE_PREF.getValue() || this._localeMatchingPeers != 0;
    }

    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    public boolean isFullyConnected() {
        return this._initializedConnections.size() >= this._preferredConnections;
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        if (this._disconnectTime != 0L) {
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            return this._fetchers.size() != 0 || this._initializingFetchedConnections.size() != 0;
        }
    }

    public void measureBandwidth() {
        float f = 0.0f;
        float f2 = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.measureBandwidth();
            f += managedConnection.getMeasuredUpstreamBandwidth();
            f2 += managedConnection.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = f;
        this._measuredDownstreamBandwidth = f2;
    }

    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private HandshakeStatus allowConnection(ManagedConnection managedConnection) {
        if (!managedConnection.receivedHeaders()) {
            return HandshakeStatus.NO_HEADERS;
        }
        return this.allowConnection(managedConnection.headers(), false);
    }

    public HandshakeStatus allowConnectionAsLeaf(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, true);
    }

    public HandshakeStatus allowConnection(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, !handshakeResponse.isUltrapeer());
    }

    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._preferredConnections || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    public HandshakeStatus allowConnection(HandshakeResponse handshakeResponse, boolean bl) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return HandshakeStatus.OK;
        }
        if (!handshakeResponse.isLeaf() && !handshakeResponse.isUltrapeer()) {
            return HandshakeStatus.NO_X_ULTRAPEER;
        }
        int n = ConnectionSettings.LIME_ATTEMPTS.getValue();
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._preferredConnections <= 0) {
            return HandshakeStatus.DISCONNECTED;
        }
        if (this.isShieldedLeaf() || !this.isSupernode()) {
            if (!handshakeResponse.isUltrapeer()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!handshakeResponse.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (_connectionAttempts < n && !handshakeResponse.isLimeWire()) {
                return HandshakeStatus.STARTING_LIMEWIRE;
            }
            if (this._shieldedConnections < this._preferredConnections) {
                if (this.checkLocale(handshakeResponse.getLocalePref())) {
                    this._needPref = false;
                }
                if (this.isIdle()) {
                    if (handshakeResponse.isLimeWire()) {
                        return HandshakeStatus.OK;
                    }
                    return HandshakeStatus.IDLE_LIMEWIRE;
                }
                return HandshakeStatus.OK;
            }
            if (this._needPref && this.checkLocale(handshakeResponse.getLocalePref())) {
                this._needPref = false;
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_UPS;
        }
        if (handshakeResponse.isLeaf() || bl) {
            if (this.isShieldedLeaf() || !this.isSupernode()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!ConnectionManager.allowUltrapeer2LeafConnection(handshakeResponse)) {
                return HandshakeStatus.NOT_ALLOWED_LEAF;
            }
            int n2 = this.getNumInitializedClientConnections();
            int n3 = this._nonLimeWireLeaves;
            if (!handshakeResponse.isLimeWire() && n2 < UltrapeerSettings.MAX_LEAVES.getValue() && n3 < 2) {
                return HandshakeStatus.OK;
            }
            if (!handshakeResponse.isGoodLeaf()) {
                return HandshakeStatus.NOT_GOOD_LEAF;
            }
            if (n2 + Math.max(0, 2 - n3) < UltrapeerSettings.MAX_LEAVES.getValue()) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_LEAF;
        }
        if (handshakeResponse.isUltrapeer()) {
            int n4 = this.getNumInitializedConnections();
            int n5 = this._nonLimeWirePeers;
            int n6 = 0;
            if (!ConnectionManager.allowUltrapeer2UltrapeerConnection(handshakeResponse)) {
                return HandshakeStatus.NOT_ALLOWED_UP;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(handshakeResponse.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return HandshakeStatus.OK;
                }
                n6 = this.getNumLimeWireLocalePrefSlots();
            }
            if (!handshakeResponse.isLimeWire()) {
                double d = (double)n5 / (double)this._preferredConnections;
                if (d < (double)ConnectionSettings.MIN_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                if (!handshakeResponse.isGoodUltrapeer()) {
                    return HandshakeStatus.NOT_GOOD_UP;
                }
                if (d < (double)ConnectionSettings.MAX_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                return HandshakeStatus.NON_LIME_RATIO;
            }
            int n7 = (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections);
            if (!handshakeResponse.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (n4 + Math.max(0, n7 - n5) + n6 < this._preferredConnections) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.NO_LIME_SLOTS;
        }
        return HandshakeStatus.UNKNOWN;
    }

    private static boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return true;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf(stringArray[n]) != -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean allowUltrapeer2LeafConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return true;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf(stringArray[n]) != -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int ultrapeerToUltrapeerConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    private int oldConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection.isSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    public List getInitializedConnections() {
        return this._initializedConnections;
    }

    public List getInitializedConnectionsMatchLocale(String string) {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!string.equals(connection.getLocalePref())) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    public List getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    public List getInitializedClientConnectionsMatchLocale(String string) {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this._initializedClientConnections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!string.equals(connection.getLocalePref())) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    public List getConnections() {
        return this._connections;
    }

    public Set getPushProxies() {
        if (this.isShieldedLeaf()) {
            Iterator iterator = this.getInitializedConnections().iterator();
            IpPortSet ipPortSet = new IpPortSet();
            while (iterator.hasNext() && ipPortSet.size() < 4) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (!managedConnection.isPushProxy()) continue;
                ipPortSet.add(managedConnection);
            }
            return ipPortSet;
        }
        return Collections.EMPTY_SET;
    }

    public boolean sendTCPConnectBackRequests() {
        Object object;
        int n = 0;
        ArrayList arrayList = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (ManagedConnection)object2.next();
            if (((Connection)object).remoteHostSupportsTCPRedirect() >= 0) continue;
            object2.remove();
        }
        if (arrayList.size() == 1) {
            object2 = (ManagedConnection)arrayList.get(0);
            int n2 = 0;
            while (n2 < 3) {
                TCPConnectBackVendorMessage tCPConnectBackVendorMessage = new TCPConnectBackVendorMessage(RouterService.getPort());
                ((ManagedConnection)object2).send(tCPConnectBackVendorMessage);
                ++n;
                ++n2;
            }
        } else {
            object2 = new TCPConnectBackVendorMessage(RouterService.getPort());
            object = arrayList.iterator();
            while (object.hasNext() && n < 5) {
                ManagedConnection managedConnection = (ManagedConnection)object.next();
                managedConnection.send((Message)object2);
                ++n;
            }
        }
        return n > 0;
    }

    public boolean sendUDPConnectBackRequests(GUID gUID) {
        int n = 0;
        UDPConnectBackVendorMessage uDPConnectBackVendorMessage = new UDPConnectBackVendorMessage(RouterService.getPort(), gUID);
        ArrayList arrayList = new ArrayList(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n < 5) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection.remoteHostSupportsUDPConnectBack() < 0) continue;
            managedConnection.send(uDPConnectBackVendorMessage);
            ++n;
        }
        return n > 0;
    }

    public void updateQueryStatus(QueryStatusResponse queryStatusResponse) {
        if (this.isShieldedLeaf()) {
            Iterator iterator = this.getInitializedConnections().iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection.remoteHostSupportsLeafGuidance() < 0) continue;
                managedConnection.send(queryStatusResponse);
            }
        }
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            return new Endpoint(managedConnection.getInetAddress().getAddress(), managedConnection.getPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            arrayList.add(managedConnection);
        }
        return arrayList;
    }

    private void connectionInitializing(Connection connection) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(this._connections);
        arrayList.add(connection);
        this._connections = Collections.unmodifiableList(arrayList);
    }

    private void connectionInitializingIncoming(ManagedConnection managedConnection) {
        this.connectionInitializing(managedConnection);
    }

    private boolean connectionInitialized(ManagedConnection managedConnection) {
        if (this._connections.contains(managedConnection)) {
            if (!this.allowInitializedConnection(managedConnection)) {
                this.removeInternal(managedConnection);
                return false;
            }
            if (!managedConnection.isSupernodeClientConnection()) {
                ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>(this._initializedConnections);
                arrayList.add(managedConnection);
                this._initializedConnections = Collections.unmodifiableList(arrayList);
                if (managedConnection.isClientSupernodeConnection()) {
                    this.killPeerConnections();
                    ++this._shieldedConnections;
                }
                if (!managedConnection.isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(managedConnection.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList<ManagedConnection> arrayList = new ArrayList<ManagedConnection>(this._initializedClientConnections);
                arrayList.add(managedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(arrayList);
                if (!managedConnection.isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            managedConnection.postInit();
            this.sendInitialPingRequest(managedConnection);
            return true;
        }
        return false;
    }

    private boolean allowInitializedConnection(ManagedConnection managedConnection) {
        if (!(!this.isShieldedLeaf() && this.isSupernode() || managedConnection.isClientSupernodeConnection())) {
            return false;
        }
        List list = this.getConnections();
        int n = managedConnection.getListeningPort();
        String string = managedConnection.getAddress();
        int n2 = 0;
        while (n2 < list.size()) {
            ManagedConnection managedConnection2 = (ManagedConnection)list.get(n2);
            if (managedConnection2 != managedConnection && !ConnectionSettings.ALLOW_DUPLICATE.getValue() && string.equals(managedConnection2.getAddress())) {
                int n3 = managedConnection2.getListeningPort();
                if (n == -1 || n == 0 || n3 == -1 || n3 == 0 || n3 == n) {
                    return false;
                }
            }
            ++n2;
        }
        return this.allowConnection(managedConnection.headers()).isAcceptable();
    }

    private void killPeerConnections() {
        List list = this._initializedConnections;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeSupernodeConnection()) continue;
            this.removeInternal(managedConnection);
        }
    }

    public void sendUpdatedCapabilities() {
        Connection connection;
        Iterator iterator = this.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            connection = (Connection)iterator.next();
            connection.sendUpdatedCapabilities();
        }
        iterator = this.getInitializedClientConnections().iterator();
        while (iterator.hasNext()) {
            connection = (Connection)iterator.next();
            connection.sendUpdatedCapabilities();
        }
    }

    public synchronized void disconnect() {
        if (this._disconnectTime == 0L) {
            long l = this.getCurrentAverageUptime();
            int n = Math.max(1, ApplicationSettings.TOTAL_CONNECTIONS.getValue() + 1);
            long l2 = l * (long)n;
            ApplicationSettings.TOTAL_CONNECTION_TIME.setValue(l2);
            ApplicationSettings.TOTAL_CONNECTIONS.setValue(n);
            ApplicationSettings.AVERAGE_CONNECTION_TIME.setValue(l);
        }
        this._disconnectTime = System.currentTimeMillis();
        this._connectTime = Long.MAX_VALUE;
        this._preferredConnections = 0;
        this.adjustConnectionFetchers();
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            this.remove(managedConnection);
            if (!managedConnection.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(managedConnection.getInetAddress().getHostAddress(), managedConnection.getPort()), true, managedConnection.getLocalePref());
        }
    }

    public synchronized long getCurrentAverageUptime() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        long l3 = Math.max(0L, l2 - this._connectTime);
        int n = ApplicationSettings.TOTAL_CONNECTIONS.getValue();
        if (l3 != 0L) {
            ++n;
        }
        long l4 = Math.max(0L, ApplicationSettings.TOTAL_CONNECTION_TIME.getValue() + l3);
        l = l4 / (long)Math.max(1, n);
        return l;
    }

    public synchronized void connect() {
        this._disconnectTime = 0L;
        this._connectTime = System.currentTimeMillis();
        if (this.isConnected() || this._catcher == null) {
            return;
        }
        _connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        this._catcher.expire();
        this.setPreferredConnections();
        this._catcher.sendUDPPings();
    }

    private void sendInitialPingRequest(ManagedConnection managedConnection) {
        if (managedConnection.supportsPongCaching()) {
            return;
        }
        PingRequest pingRequest = this.getNumInitializedConnections() >= this._preferredConnections ? new PingRequest(1) : new PingRequest(4);
        managedConnection.send(pingRequest);
        try {
            managedConnection.flush();
        }
        catch (IOException iOException) {}
    }

    private void removeInternal(ManagedConnection managedConnection) {
        ArrayList arrayList;
        int n;
        if (!managedConnection.isSupernodeClientConnection()) {
            n = this._initializedConnections.indexOf(managedConnection);
            if (n != -1) {
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedConnections);
                arrayList.remove(managedConnection);
                this._initializedConnections = Collections.unmodifiableList(arrayList);
                if (managedConnection.isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!managedConnection.isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(managedConnection.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            n = this._initializedClientConnections.indexOf(managedConnection);
            if (n != -1) {
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedClientConnections);
                arrayList.remove(managedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(arrayList);
                if (!managedConnection.isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        if ((n = this._connections.indexOf(managedConnection)) != -1) {
            arrayList = new ArrayList(this._connections);
            arrayList.remove(managedConnection);
            this._connections = Collections.unmodifiableList(arrayList);
        }
        managedConnection.close();
        RouterService.getMessageRouter().removeConnection(managedConnection);
        RouterService.getCallback().connectionClosed(managedConnection);
        QueryUnicaster.instance().purgeQuery(managedConnection);
    }

    private synchronized void stabilizeConnections() {
        while (this.getNumInitializedConnections() > this._preferredConnections) {
            ManagedConnection managedConnection = null;
            Iterator iterator = this._initializedConnections.iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection2 = (ManagedConnection)iterator.next();
                if (!managedConnection2.isLimeWire()) {
                    managedConnection = managedConnection2;
                    break;
                }
                if (managedConnection != null && managedConnection2.getConnectionTime() <= managedConnection.getConnectionTime()) continue;
                managedConnection = managedConnection2;
            }
            if (managedConnection == null) continue;
            this.remove(managedConnection);
        }
        this.adjustConnectionFetchers();
    }

    private void adjustConnectionFetchers() {
        ConnectionFetcher connectionFetcher;
        int n;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            this.startDedicatedLocaleFetcher();
        }
        int n2 = this.getNumInitializedConnections();
        int n3 = this._preferredConnections - n2;
        if (!RouterService.acceptedIncomingConnection() && !this.isActiveSupernode()) {
            n = 3;
        } else if (!this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            n = 3;
        } else if (n3 > 10) {
            n = 2;
        } else {
            n = 1;
            n3 = (int)((float)n3 - (5.0f + ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections));
        }
        int n4 = Math.min(10, n * n3) - this._fetchers.size() - this._initializingFetchedConnections.size();
        n4 = Math.min(n4, Sockets.getNumAllowedSockets());
        ArrayList<ConnectionFetcher> arrayList = Collections.EMPTY_LIST;
        if (n4 > 0) {
            arrayList = new ArrayList<ConnectionFetcher>(n4);
            while (n4 > 0) {
                ConnectionFetcher connectionFetcher2 = new ConnectionFetcher();
                arrayList.add(connectionFetcher2);
                --n4;
            }
            this._fetchers.addAll(arrayList);
        }
        int n5 = this._fetchers.size();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (n4 < 0 && n5 > 0) {
            ConnectionFetcher connectionFetcher3 = (ConnectionFetcher)this._fetchers.remove(--n5);
            ++n4;
            arrayList2.add(connectionFetcher3);
        }
        int n6 = this._initializingFetchedConnections.size();
        while (n4 < 0 && n6 > 0) {
            ManagedConnection managedConnection = (ManagedConnection)this._initializingFetchedConnections.remove(--n6);
            ++n4;
            arrayList2.add(managedConnection);
        }
        int n7 = arrayList.size() - 1;
        while (n7 >= 0) {
            connectionFetcher = (ConnectionFetcher)arrayList.remove(n7);
            connectionFetcher.connect();
            --n7;
        }
        n7 = arrayList2.size() - 1;
        while (n7 >= 0) {
            connectionFetcher = arrayList2.remove(n7);
            if (connectionFetcher instanceof ConnectionFetcher) {
                connectionFetcher.stopConnecting();
            } else {
                this.removeInternal((ManagedConnection)((Object)connectionFetcher));
            }
            --n7;
        }
    }

    private void startDedicatedLocaleFetcher() {
        if (RouterService.isShieldedLeaf() && this._needPref && !this._needPrefInterrupterScheduled && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            this._dedicatedPrefFetcher.connect();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConnectionManager connectionManager = ConnectionManager.this;
                    synchronized (connectionManager) {
                        ConnectionManager.this._needPref = false;
                        if (ConnectionManager.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManager.this._dedicatedPrefFetcher.stopConnecting();
                        ConnectionManager.this._dedicatedPrefFetcher = null;
                    }
                }
            };
            this._needPrefInterrupterScheduled = true;
            RouterService.schedule(runnable, 15000L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(ManagedConnection managedConnection, ConnectionFetcher connectionFetcher) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (connectionFetcher.isPrematurelyStopped()) {
                connectionFetcher.finish();
                return;
            }
            this._initializingFetchedConnections.add(managedConnection);
            if (connectionFetcher == this._dedicatedPrefFetcher) {
                this._dedicatedPrefFetcher = null;
            } else {
                this._fetchers.remove(connectionFetcher);
            }
            this.connectionInitializing(managedConnection);
        }
        RouterService.getCallback().connectionInitializing(managedConnection);
        try {
            managedConnection.initialize(connectionFetcher);
        }
        catch (IOException iOException) {
            this.cleanupBrokenFetchedConnection(managedConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrokenFetchedConnection(ManagedConnection managedConnection) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this._initializingFetchedConnections.remove(managedConnection);
            this.removeInternal(managedConnection);
            this.adjustConnectionFetchers();
        }
        this.processConnectionHeaders(managedConnection);
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.receivedHeaders()) {
            return;
        }
        Properties properties = connection.headers().props();
        if (properties == null) {
            return;
        }
        this.updateHostCache(connection.headers());
        String string = properties.getProperty("Listen-IP");
        if (string == null) {
            string = properties.getProperty("X-My-Address");
        }
        if (string != null && !connection.isOutgoing()) {
            int n = string.indexOf(58);
            if (n == -1) {
                return;
            }
            if (++n > string.length()) {
                return;
            }
            try {
                int n2 = Integer.parseInt(string.substring(n).trim());
                if (NetworkUtils.isValidPort(n2)) {
                    connection.setListeningPort(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public boolean allowLeafDemotion() {
        ++this._leafTries;
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isActiveSupernode()) {
            return false;
        }
        return !SupernodeAssigner.isTooGoodToPassUp() || this._leafTries >= this._demotionLimit;
    }

    public void tryToBecomeAnUltrapeer(int n) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = n;
        this._leafTries = 0;
        this.disconnect();
        this.connect();
    }

    private void updateHostCache(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.hasXTryUltrapeers()) {
            return;
        }
        String string = handshakeResponse.getXTryUltrapeers();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                Endpoint endpoint = new Endpoint(string2);
                arrayList.add(endpoint);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this._catcher.add(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(ManagedConnection managedConnection, GnetConnectObserver gnetConnectObserver) throws IOException {
        if (managedConnection.isOutgoing()) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(managedConnection);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        try {
            managedConnection.initialize(gnetConnectObserver);
        }
        catch (IOException iOException) {
            this.cleanupBrokenExternallyGeneratedConnection(managedConnection);
            throw iOException;
        }
        if (gnetConnectObserver == null) {
            this.completeInitializeExternallyGeneratedConnection(managedConnection);
        }
    }

    private void cleanupBrokenExternallyGeneratedConnection(ManagedConnection managedConnection) {
        this.remove(managedConnection);
        this.processConnectionHeaders(managedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeInitializeExternallyGeneratedConnection(ManagedConnection managedConnection) throws IOException {
        this.processConnectionHeaders(managedConnection);
        if (!managedConnection.isOutgoing() && !this.allowConnection(managedConnection).isAcceptable()) {
            throw new IOException("No space for connection");
        }
        if (!managedConnection.isOutgoing()) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(managedConnection);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        return this.completeConnectionInitialization(managedConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeConnectionInitialization(ManagedConnection managedConnection, boolean bl) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            boolean bl2;
            if (bl) {
                this._initializingFetchedConnections.remove(managedConnection);
            }
            if (bl2 = this.connectionInitialized(managedConnection)) {
                RouterService.getCallback().connectionInitialized(managedConnection);
                this.setPreferredConnections();
            }
            return bl2;
        }
    }

    public int getPreferredConnectionCount() {
        return this._preferredConnections;
    }

    public boolean isConnectionIdle() {
        return this._preferredConnections == ConnectionSettings.IDLE_CONNECTIONS.getValue();
    }

    private void setPreferredConnections() {
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._disconnectTime != 0L) {
            return;
        }
        int n = this._preferredConnections;
        this._preferredConnections = this.isSupernode() ? ConnectionSettings.NUM_CONNECTIONS.getValue() : (this.isIdle() ? ConnectionSettings.IDLE_CONNECTIONS.getValue() : 3);
        if (n != this._preferredConnections) {
            this.stabilizeConnections();
        }
    }

    private boolean isIdle() {
        return SystemUtils.getIdleTime() >= 1800000L;
    }

    private void startConnection(ManagedConnection managedConnection) throws IOException {
        if (managedConnection.isGUESSUltrapeer()) {
            QueryUnicaster.instance().addUnicastEndpoint(managedConnection.getInetAddress(), managedConnection.getPort());
        }
        managedConnection.loopForMessages();
    }

    public void noInternetConnection() {
        RouterService.getCallback().disconnected();
        if (this._automaticallyConnecting) {
            return;
        }
        this.disconnect();
        RouterService.schedule(new Runnable(){

            public void run() {
                if (ConnectionManager.this._automaticConnectTime < ConnectionManager.this._disconnectTime) {
                    return;
                }
                if (!RouterService.isConnected()) {
                    ConnectionManager.this.connect();
                }
            }
        }, 10000L, 120000L);
        this._automaticConnectTime = System.currentTimeMillis();
        this._automaticallyConnecting = true;
        this.recoverHosts();
    }

    private synchronized void recoverHosts() {
        if (this._catcher != null && this._catcher.getNumHosts() < 100) {
            this._catcher.recoverHosts();
        }
    }

    private boolean checkLocale(String string) {
        if (string == null) {
            string = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.LANGUAGE.getValue().equals(string);
    }

    private class OutgoingConnector
    implements Runnable {
        private final ManagedConnection _connection;
        private final boolean _doInitialization;

        public OutgoingConnector(ManagedConnection managedConnection, boolean bl) {
            this._connection = managedConnection;
            this._doInitialization = bl;
        }

        public void run() {
            try {
                if (this._doInitialization) {
                    ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection, null);
                }
                ConnectionManager.this.startConnection(this._connection);
            }
            catch (IOException iOException) {}
        }
    }

    private class IncomingGNetObserver
    implements GnetConnectObserver {
        private ManagedConnection connection;

        IncomingGNetObserver(ManagedConnection managedConnection) {
            this.connection = managedConnection;
        }

        public void handleConnect() {
            try {
                if (ConnectionManager.this.completeInitializeExternallyGeneratedConnection(this.connection)) {
                    // empty if block
                }
                ConnectionManager.this.startConnection(this.connection);
            }
            catch (IOException iOException) {
                LOG.warn((Object)"Failed to complete initialization", (Throwable)iOException);
            }
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int n, String string) {
            this.shutdown();
        }

        public void shutdown() {
            ConnectionManager.this.cleanupBrokenExternallyGeneratedConnection(this.connection);
        }
    }

    private class ConnectionFetcher
    implements GnetConnectObserver,
    HostCatcher.EndpointObserver {
        private boolean _pref = false;
        private ManagedConnection connection;
        private Endpoint endpoint;
        private volatile boolean stoppedEarly = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean bl) {
            this._pref = bl;
        }

        IpPort getIpPort() {
            if (this.connection != null) {
                return this.connection;
            }
            if (this.endpoint != null) {
                return this.endpoint;
            }
            return null;
        }

        public void connect() {
            ConnectionManager.this._catcher.getAnEndpoint(this);
        }

        public void stopConnecting() {
            this.stoppedEarly = true;
            ConnectionManager.this._catcher.removeEndpointObserver(this);
        }

        public boolean isPrematurelyStopped() {
            return this.stoppedEarly;
        }

        public void finish() {
        }

        public void handleEndpoint(Endpoint endpoint) {
            Assert.that(endpoint != null);
            if (!IPFilter.instance().allow(endpoint.getAddress()) || ConnectionManager.this.isConnectedTo(endpoint.getAddress()) || ConnectionManager.this.isConnectingTo(endpoint)) {
                ConnectionManager.this._catcher.getAnEndpoint(this);
                return;
            }
            this.endpoint = endpoint;
            this.connection = new ManagedConnection(endpoint.getAddress(), endpoint.getPort());
            this.connection.setLocalePreferencing(this._pref);
            this.doConnectionCheck();
            _connectionAttempts = _connectionAttempts + 1;
            ConnectionManager.this.initializeFetchedConnection(this.connection, this);
        }

        public void handleConnect() {
            boolean bl = ConnectionManager.this.completeConnectionInitialization(this.connection, true);
            ConnectionManager.this.processConnectionHeaders(this.connection);
            ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
            ConnectionManager.this._catcher.doneWithConnect(this.endpoint, true);
            if (this._pref) {
                ConnectionManager.this._needPref = false;
            }
            try {
                if (bl) {
                    ConnectionManager.this.startConnection(this.connection);
                }
            }
            catch (IOException iOException) {}
        }

        public void shutdown() {
            ConnectionManager.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManager.this._catcher.doneWithConnect(this.endpoint, false);
            ConnectionManager.this._catcher.expireHost(this.endpoint);
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int n, String string) {
            ConnectionManager.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
            if (n == 577) {
                ConnectionManager.this._catcher.add(this.endpoint, true, this.connection.getLocalePref());
            } else {
                ConnectionManager.this._catcher.doneWithConnect(this.endpoint, true);
                ConnectionManager.this._catcher.putHostOnProbation(this.endpoint);
            }
        }

        private void doConnectionCheck() {
            long l = System.currentTimeMillis();
            if (!ConnectionManager.this.isConnected() && _connectionAttempts > 40 && l - ConnectionManager.this._lastSuccessfulConnect > 4000L && l - ConnectionManager.this._lastConnectionCheck > 3600000L) {
                _connectionAttempts = 0;
                ConnectionManager.this._lastConnectionCheck = l;
                LOG.debug((Object)"checking for live connection");
                ConnectionChecker.checkForLiveConnection();
            }
        }
    }
}

