/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.SecureMessage;
import com.limegroup.gnutella.messages.SecureMessageCallback;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IntWrapper;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ForMeReplyHandler
implements ReplyHandler,
SecureMessageCallback {
    private static final Log LOG;
    private final Map PUSH_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final Map GUID_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private static final ReplyHandler INSTANCE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.ForMeReplyHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new ForMeReplyHandler();
    }

    public static ReplyHandler instance() {
        return INSTANCE;
    }

    private ForMeReplyHandler() {
        RouterService.schedule(new Runnable(){

            public void run() {
                ForMeReplyHandler.this.PUSH_REQUESTS.clear();
            }
        }, 30000L, 30000L);
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply.getHops() <= 1 && replyHandler.getNumMessagesReceived() <= 2 && !replyHandler.isOutgoing() && replyHandler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && replyHandler instanceof ManagedConnection && replyHandler.isStable()) {
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            connectionManager.remove((ManagedConnection)replyHandler);
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        boolean bl;
        if (replyHandler != null && replyHandler.isPersonalSpam(queryReply)) {
            return;
        }
        if (queryReply.isFakeMulticast()) {
            return;
        }
        if (queryReply.isReplyToMulticastQuery()) {
            if (queryReply.isTCP()) {
                return;
            }
            if (queryReply.getHops() != 1 || queryReply.getTTL() != 0) {
                return;
            }
        }
        if (queryReply.isUDP()) {
            Assert.that(replyHandler instanceof UDPReplyHandler);
            UDPReplyHandler uDPReplyHandler = (UDPReplyHandler)replyHandler;
            queryReply.setOOBAddress(uDPReplyHandler.getInetAddress(), uDPReplyHandler.getPort());
        }
        if (!(bl = this.addXMLToResponses(queryReply))) {
            return;
        }
        if (queryReply.hasSecureData() && ApplicationSettings.USE_SECURE_RESULTS.getValue()) {
            RouterService.getSecureMessageVerifier().verify(queryReply, this);
        } else {
            this.routeQueryReplyInternal(queryReply);
        }
    }

    public void handleSecureMessage(SecureMessage secureMessage, boolean bl) {
        if (bl) {
            this.routeQueryReplyInternal((QueryReply)secureMessage);
        }
    }

    private void routeQueryReplyInternal(QueryReply queryReply) {
        SearchResultHandler searchResultHandler = RouterService.getSearchResultHandler();
        searchResultHandler.handleQueryReply(queryReply);
        DownloadManager downloadManager = RouterService.getDownloadManager();
        downloadManager.handleQueryReply(queryReply);
    }

    private boolean addXMLToResponses(QueryReply queryReply) {
        int n;
        Object[] objectArray;
        String string = "";
        try {
            LOG.trace((Object)"Trying to do uncompress XML.....");
            objectArray = queryReply.getXMLBytes();
            if (objectArray.length > 1) {
                byte[] byArray = LimeXMLUtils.uncompress(objectArray);
                string = new String(byArray, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        catch (IOException iOException) {}
        if (string == null || string.equals("")) {
            return true;
        }
        try {
            objectArray = queryReply.getResultsArray();
            n = objectArray.length;
        }
        catch (BadPacketException badPacketException) {
            LOG.trace((Object)"Unable to get responses", (Throwable)badPacketException);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("xmlCollectionString = " + string));
        }
        List list = LimeXMLDocumentHelper.getDocuments(string, n);
        int n2 = 0;
        while (n2 < n) {
            byte by = objectArray[n2];
            int n3 = 0;
            while (n3 < list.size()) {
                LimeXMLDocument[] limeXMLDocumentArray = (LimeXMLDocument[])list.get(n3);
                if (limeXMLDocumentArray != null && limeXMLDocumentArray[n2] != null) {
                    by.setDocument(limeXMLDocumentArray[n2]);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        if (replyHandler.isPersonalSpam(pushRequest)) {
            return;
        }
        byte[] byArray = pushRequest.getIP();
        String string = NetworkUtils.ip2string(byArray);
        GUID gUID = new GUID(pushRequest.getGUID());
        if (this.GUID_REQUESTS.put(gUID, gUID) != null) {
            return;
        }
        IntWrapper intWrapper = (IntWrapper)this.PUSH_REQUESTS.get(string);
        if (intWrapper == null) {
            intWrapper = new IntWrapper(1);
            this.PUSH_REQUESTS.put(string, intWrapper);
        } else {
            intWrapper.addInt(1);
            if (intWrapper.getInt() > UploadSettings.MAX_PUSHES_PER_HOST.getValue()) {
                return;
            }
        }
        if (RouterService.getAcceptor().isBannedIP(byArray)) {
            return;
        }
        int n = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(n)) {
            return;
        }
        String string2 = new GUID(pushRequest.getClientGUID()).toString();
        RouterService.getPushManager().acceptPushUpload(string, n, string2, pushRequest.isMulticast(), pushRequest.isFirewallTransferPush());
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public void countDroppedMessage() {
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isPersonalSpam(Message message) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isLeafConnection() {
        return !RouterService.isSupernode();
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return true;
    }

    public boolean allowNewPings() {
        return true;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(RouterService.getAddress()));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return RouterService.getPort();
    }

    public String getAddress() {
        return NetworkUtils.ip2string(RouterService.getAddress());
    }

    public void handleStatisticVM(StatisticVendorMessage statisticVendorMessage) {
        Assert.that(false, "ForMeReplyHandler asked to send vendor message");
    }

    public void handleSimppVM(SimppVM simppVM) {
        Assert.that(false, "ForMeReplyHandler asked to send vendor message");
    }

    public boolean isStable() {
        return true;
    }

    public String getLocalePref() {
        return ApplicationSettings.LANGUAGE.getValue();
    }

    public void reply(Message message) {
    }

    public byte[] getClientGUID() {
        return RouterService.getMyGUID();
    }
}

