/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.guess.QueryKeyGenerator;
import com.limegroup.gnutella.security.SecurityUtils;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Arrays;

class TEAQueryKeyGenerator
implements QueryKeyGenerator {
    protected final int QK_LENGTH = 4;
    protected final int PRE_ROTATE;
    protected final int POST_ROTATE;
    protected final int LK0;
    protected final int LK1;
    protected final int RK0;
    protected final int RK1;
    protected final long PRE_WHITEN_KEY;
    protected final long POST_WHITEN_KEY;

    TEAQueryKeyGenerator() {
        SecureRandom secureRandom = SecurityUtils.createSecureRandomNoBlock();
        this.PRE_WHITEN_KEY = secureRandom.nextLong();
        this.POST_WHITEN_KEY = secureRandom.nextLong();
        this.LK0 = secureRandom.nextInt();
        this.LK1 = secureRandom.nextInt();
        this.RK0 = secureRandom.nextInt();
        this.RK1 = secureRandom.nextInt();
        int n = secureRandom.nextInt();
        this.PRE_ROTATE = n & 0x3F;
        this.POST_ROTATE = n >>> 26;
    }

    TEAQueryKeyGenerator(int n, int n2, int n3, int n4, int n5, int n6) {
        this.PRE_ROTATE = n5 & 0x3F;
        this.POST_ROTATE = n6 & 0x3F;
        this.POST_WHITEN_KEY = 0L;
        this.PRE_WHITEN_KEY = 0L;
        this.LK0 = n;
        this.LK1 = n2;
        this.RK0 = n3;
        this.RK1 = n4;
    }

    public boolean checkKeyBytes(byte[] byArray, InetAddress inetAddress, int n) {
        return Arrays.equals(byArray, this.getKeyBytes(inetAddress, n));
    }

    public byte[] getKeyBytes(InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress.getAddress();
        int n2 = 0;
        int n3 = 3;
        while (n3 >= 0) {
            n2 ^= byArray[n3] << (n3 << 3);
            --n3;
        }
        long l = this.encrypt((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
        byte[] byArray2 = new byte[4];
        int n4 = 3;
        int n5 = (int)(l >> 32);
        int n6 = (int)l;
        while (n4 >= 0) {
            int n7;
            if (n5 == 0) {
                n5 = n6;
                n6 ^= 0xFFFFFFFF;
            }
            if ((n7 = n5 & 0xFF) != 0 && n7 != 28) {
                byArray2[n4] = (byte)n7;
                --n4;
            }
            n5 >>>= 8;
        }
        return byArray2;
    }

    private final long encrypt(long l) {
        l = l << this.PRE_ROTATE | l >>> 64 - this.PRE_ROTATE;
        int n = (int)((l ^= this.PRE_WHITEN_KEY) >> 32);
        int n2 = (int)l;
        int n3 = 32;
        int n4 = 0;
        while (n3 > 0) {
            n2 += ((n += (n2 << 4) + this.LK0 ^ n2 + (n4 += -1640531527) ^ (n2 >>> 5) + this.LK1) << 4) + this.RK0 ^ n + n4 ^ (n >>> 5) + this.RK1;
            --n3;
        }
        l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        return (l ^= this.POST_WHITEN_KEY) << this.POST_ROTATE | l >>> 64 - this.POST_ROTATE;
    }
}

