/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.Setting;
import java.util.Properties;

public abstract class AbstractNumberSetting
extends Setting {
    protected final Number MAX_VALUE;
    protected final Number MIN_VALUE;

    protected AbstractNumberSetting(Properties properties, Properties properties2, String string, String string2, String string3, Number number, Number number2) {
        super(properties, properties2, string, string2, string3);
        Comparable comparable;
        if (number2 != null && number != null && (comparable = (Comparable)((Object)number2)).compareTo(number) < 0) {
            throw new IllegalArgumentException("max less than min");
        }
        this.MAX_VALUE = number2;
        this.MIN_VALUE = number;
    }

    protected void setValue(String string) {
        if (this.isSimppEnabled()) {
            Assert.that(this.MAX_VALUE != null, "simpp setting created with no max");
            Assert.that(this.MIN_VALUE != null, "simpp setting created with no min");
        }
        string = this.normalizeValue(string);
        super.setValue(string);
    }

    protected String normalizeValue(String string) {
        Comparable comparable = null;
        try {
            comparable = this.convertToComparable(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.DEFAULT_VALUE;
        }
        if (this.MAX_VALUE != null && comparable.compareTo(this.MAX_VALUE) > 0) {
            return this.MAX_VALUE.toString();
        }
        if (this.MIN_VALUE != null && comparable.compareTo(this.MIN_VALUE) < 0) {
            return this.MIN_VALUE.toString();
        }
        return string;
    }

    protected abstract Comparable convertToComparable(String var1);
}

