/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadManager
implements BandwidthTracker {
    private static final Log LOG;
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private ActivityCallback callback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    public static long TIME_BETWEEN_REQUERIES;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.DownloadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        TIME_BETWEEN_REQUERIES = 2700000L;
    }

    public void initialize() {
        this.callback = RouterService.getCallback();
        this.router = RouterService.getMessageRouter();
        this.fileManager = RouterService.getFileManager();
    }

    public void postGuiInit() {
        File file = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File file2 = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(file)) {
            LOG.debug((Object)"Reading real downloads.dat failed");
            if (this.readSnapshot(file2)) {
                LOG.debug((Object)"Reading backup downloads.bak succeeded.");
                this.copyBackupToReal();
            } else if (file2.exists() || file.exists()) {
                LOG.debug((Object)"Reading both downloads files failed.");
                MessageService.showError("DOWNLOAD_COULD_NOT_READ_SNAPSHOT");
            }
        } else {
            LOG.debug((Object)"Reading downloads.dat worked!");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                        DownloadManager.this.copyBackupToReal();
                    }
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        };
        RouterService.schedule(runnable, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
    }

    private synchronized void copyBackupToReal() {
        File file = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File file2 = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        file.delete();
        CommonUtils.copy(file2, file);
    }

    public boolean isIncomplete(URN uRN) {
        return this.incompleteFileManager.getFileForUrn(uRN) != null;
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int n = 0;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            n += managedDownloader.getNumDownloaders();
        }
        return n;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size();
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    public synchronized boolean isGuidForQueryDownloading(GUID gUID) {
        GUID gUID2;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            gUID2 = ((ManagedDownloader)iterator.next()).getQueryGUID();
            if (gUID2 == null || !gUID2.equals(gUID)) continue;
            return true;
        }
        iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            gUID2 = ((ManagedDownloader)iterator.next()).getQueryGUID();
            if (gUID2 == null || !gUID2.equals(gUID)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean writeSnapshot() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)this.active);
        arrayList.addAll((Collection)this.waiting);
        File file = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue().delete();
        file.renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue()));
            objectOutputStream.writeObject(arrayList);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                objectOutputStream.writeObject(this.incompleteFileManager);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean readSnapshot(File file) {
        ObjectInputStream objectInputStream;
        List list = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            list = (List)objectInputStream.readObject();
            this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            LOG.debug((Object)iOException);
            return false;
        }
        catch (ClassCastException classCastException) {
            LOG.debug((Object)classCastException);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.debug((Object)classNotFoundException);
            return false;
        }
        catch (ArrayStoreException arrayStoreException) {
            LOG.debug((Object)arrayStoreException);
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOG.debug((Object)indexOutOfBoundsException);
            return false;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            LOG.debug((Object)negativeArraySizeException);
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            LOG.debug((Object)illegalStateException);
            return false;
        }
        catch (SecurityException securityException) {
            LOG.debug((Object)securityException);
            return false;
        }
        if (this.incompleteFileManager.purge(true)) {
            this.writeSnapshot();
        }
        try {
            objectInputStream = list.iterator();
            while (objectInputStream.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)objectInputStream.next();
                this.waiting.add((Object)managedDownloader);
                managedDownloader.initialize(this, this.fileManager, this.callback, true);
                this.callback.addDownload(managedDownloader);
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public synchronized Downloader download(RemoteFileDesc[] remoteFileDescArray, List list, boolean bl, GUID gUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        String string;
        Serializable serializable;
        Serializable serializable2;
        String string2 = this.conflicts(remoteFileDescArray, null);
        if (string2 != null) {
            throw new AlreadyDownloadingException(string2);
        }
        if (!bl && (serializable2 = new File((File)(serializable = SharingSettings.getSaveDirectory()), string = remoteFileDescArray[0].getFileName())).exists()) {
            throw new FileExistsException(string);
        }
        this.incompleteFileManager.purge(false);
        serializable = new ManagedDownloader(remoteFileDescArray, this.incompleteFileManager, gUID);
        this.startDownload((ManagedDownloader)serializable, false);
        string = list.iterator();
        while (string.hasNext()) {
            serializable2 = (RemoteFileDesc)string.next();
            ((ManagedDownloader)serializable).addDownload((RemoteFileDesc)serializable2, false);
        }
        return serializable;
    }

    public synchronized Downloader download(File file) throws AlreadyDownloadingException, CantResumeException {
        Object object;
        Object object2 = this.active.iterator();
        while (object2.hasNext()) {
            object = (ManagedDownloader)object2.next();
            if (!((ManagedDownloader)object).conflicts(file)) continue;
            throw new AlreadyDownloadingException(((ManagedDownloader)object).getFileName());
        }
        object2 = this.waiting.iterator();
        while (object2.hasNext()) {
            object = (ManagedDownloader)object2.next();
            if (!((ManagedDownloader)object).conflicts(file)) continue;
            throw new AlreadyDownloadingException(((ManagedDownloader)object).getFileName());
        }
        this.incompleteFileManager.purge(false);
        object2 = null;
        try {
            file = FileUtils.getCanonicalFile(file);
            object = IncompleteFileManager.getCompletedName(file);
            int n = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(file));
            object2 = new ResumeDownloader(this.incompleteFileManager, file, (String)object, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantResumeException(file.getName());
        }
        catch (IOException iOException) {
            throw new CantResumeException(file.getName());
        }
        this.startDownload((ManagedDownloader)object2, false);
        return object2;
    }

    public synchronized Downloader download(String string, String string2, byte[] byArray, MediaType mediaType) throws AlreadyDownloadingException {
        AutoDownloadDetails autoDownloadDetails = new AutoDownloadDetails(string, string2, byArray, mediaType);
        if (this.requeryConflicts(autoDownloadDetails)) {
            throw new AlreadyDownloadingException(string);
        }
        this.incompleteFileManager.purge(false);
        RequeryDownloader requeryDownloader = new RequeryDownloader(this.incompleteFileManager, autoDownloadDetails, new GUID(byArray));
        this.startDownload(requeryDownloader, false);
        return requeryDownloader;
    }

    private void startDownload(ManagedDownloader managedDownloader, boolean bl) {
        managedDownloader.initialize(this, this.fileManager, this.callback, bl);
        this.waiting.add((Object)managedDownloader);
        this.callback.addDownload(managedDownloader);
        this.writeSnapshot();
    }

    public synchronized String conflicts(RemoteFileDesc[] remoteFileDescArray, ManagedDownloader managedDownloader) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            ManagedDownloader managedDownloader2;
            Iterator iterator = this.active.iterator();
            while (iterator.hasNext()) {
                managedDownloader2 = (ManagedDownloader)iterator.next();
                if (managedDownloader != null && managedDownloader2 == managedDownloader || !managedDownloader2.conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            iterator = this.waiting.iterator();
            while (iterator.hasNext()) {
                managedDownloader2 = (ManagedDownloader)iterator.next();
                if (managedDownloader != null && managedDownloader2 == managedDownloader || !managedDownloader2.conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            ++n;
        }
        return null;
    }

    private synchronized boolean conflicts(URN uRN) {
        ManagedDownloader managedDownloader;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            managedDownloader = (ManagedDownloader)iterator.next();
            if (!managedDownloader.conflicts(uRN)) continue;
            return true;
        }
        iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            managedDownloader = (ManagedDownloader)iterator.next();
            if (!managedDownloader.conflicts(uRN)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean requeryConflicts(AutoDownloadDetails autoDownloadDetails) {
        RequeryDownloader requeryDownloader;
        ManagedDownloader managedDownloader;
        boolean bl = false;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext() && !bl) {
            managedDownloader = (ManagedDownloader)iterator.next();
            if (!(managedDownloader instanceof RequeryDownloader)) continue;
            requeryDownloader = (RequeryDownloader)managedDownloader;
            bl = requeryDownloader.conflicts(autoDownloadDetails);
        }
        iterator = this.waiting.iterator();
        while (iterator.hasNext() && !bl) {
            managedDownloader = (ManagedDownloader)iterator.next();
            if (!(managedDownloader instanceof RequeryDownloader)) continue;
            requeryDownloader = (RequeryDownloader)managedDownloader;
            bl = requeryDownloader.conflicts(autoDownloadDetails);
        }
        return bl;
    }

    public void handleQueryReply(QueryReply queryReply) {
        HostData hostData;
        List list;
        if (queryReply.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        try {
            list = queryReply.getResultsAsList();
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        this.addDownloadWithResponses(list, hostData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List list, HostData hostData) {
        if (list == null) {
            throw new NullPointerException("null responses");
        }
        if (hostData == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList arrayList = new ArrayList(this.active.size() + this.waiting.size());
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            arrayList.addAll((Collection)this.active);
            arrayList.addAll((Collection)this.waiting);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        downloadManager = list.iterator();
        block3: while (downloadManager.hasNext()) {
            Response response = (Response)downloadManager.next();
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                if (!managedDownloader.addDownload(remoteFileDesc, true)) continue;
                Set set = response.getLocations();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Endpoint endpoint = (Endpoint)iterator2.next();
                    managedDownloader.addDownload(new RemoteFileDesc(remoteFileDesc, endpoint), false);
                }
                continue block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDownload(Socket socket) {
        Thread.currentThread().setName("PushDownloadThread");
        try {
            GIVLine gIVLine = DownloadManager.parseGIV(socket);
            String string = gIVLine.file;
            int n = gIVLine.index;
            byte[] byArray = gIVLine.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                ManagedDownloader managedDownloader;
                if (BrowseHostHandler.handlePush(n, new GUID(byArray), socket)) {
                    return;
                }
                Iterator iterator = this.active.iterator();
                while (iterator.hasNext()) {
                    managedDownloader = (ManagedDownloader)iterator.next();
                    if (!managedDownloader.acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
                iterator = this.waiting.iterator();
                while (iterator.hasNext()) {
                    managedDownloader = (ManagedDownloader)iterator.next();
                    if (!managedDownloader.acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {}
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private boolean hasFreeSlot() {
        return this.active.size() < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void waitForSlot(ManagedDownloader managedDownloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove((Object)managedDownloader);
        this.active.add((Object)managedDownloader);
    }

    public synchronized void yieldSlot(ManagedDownloader managedDownloader) {
        Assert.that(managedDownloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove((Object)managedDownloader);
        this.waiting.add((Object)managedDownloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader managedDownloader, boolean bl) {
        this.active.remove((Object)managedDownloader);
        this.waiting.remove((Object)managedDownloader);
        this.querySentMDs.remove((Object)managedDownloader);
        managedDownloader.finish();
        if (managedDownloader.getQueryGUID() != null) {
            this.router.downloadFinished(managedDownloader.getQueryGUID());
        }
        this.notify();
        this.callback.removeDownload(managedDownloader);
        this.writeSnapshot();
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader managedDownloader, QueryRequest queryRequest) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery():" + queryRequest.getQuery()));
        }
        Assert.that(this.waiting.contains((Object)managedDownloader), "Unknown or non-waiting MD trying to send requery.");
        boolean bl = GUID.isLimeRequeryGUID(queryRequest.getGUID());
        long l = System.currentTimeMillis() - this.lastRequeryTime;
        if (bl && l <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            LOG.trace((Object)"DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains((Object)managedDownloader)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("DM.sendQuery(): out of turn:" + queryRequest.getQuery()));
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery(): requery allowed:" + queryRequest.getQuery()));
        }
        this.querySentMDs.add((Object)managedDownloader);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(queryRequest);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendPush(RemoteFileDesc remoteFileDesc) {
        int n;
        byte[] byArray;
        block18: {
            LOG.trace((Object)"DM.sendPush(): entered.");
            if (remoteFileDesc.isReplyToMulticast()) {
                byArray = RouterService.getNonForcedAddress();
                n = RouterService.getNonForcedPort();
                if (NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n)) {
                    PushRequest pushRequest = new PushRequest(GUID.makeGuid(), 1, remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), byArray, n);
                    this.router.sendMulticastPushRequest(pushRequest);
                    return true;
                }
            }
            byArray = RouterService.getAddress();
            n = RouterService.getPort();
            if (!NetworkUtils.isValidAddress(byArray)) return false;
            if (!NetworkUtils.isValidPort(n)) {
                return false;
            }
            Set set = remoteFileDesc.getPushProxies();
            if (set.isEmpty()) break block18;
            LOG.info((Object)"DM.sendPush(): proxy info exists.");
            boolean bl = false;
            String string = "/gnutella/push-proxy?ServerID=" + Base32.encode(remoteFileDesc.getClientGUID());
            String string2 = String.valueOf(NetworkUtils.ip2string(byArray)) + ":" + n;
            Iterator iterator = set.iterator();
            while (true) {
                Object var16_18;
                if (!iterator.hasNext() || bl) {
                    if (!bl) break;
                    return bl;
                }
                PushProxyInterface pushProxyInterface = (PushProxyInterface)iterator.next();
                String string3 = pushProxyInterface.getPushProxyAddress().getHostAddress();
                int n2 = pushProxyInterface.getPushProxyPort();
                String string4 = "http://" + string3 + ":" + n2 + string;
                HeadMethod headMethod = new HeadMethod(string4);
                headMethod.addRequestHeader("X-Node", string2);
                headMethod.addRequestHeader("Cache-Control", "no-cache");
                HttpClient httpClient = HttpClientManager.getNewClient();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Push Proxy Requesting with: " + string4));
                }
                try {
                    try {
                        httpClient.executeMethod((HttpMethod)headMethod);
                        if (headMethod.getStatusCode() == 202) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("Succesful push proxy: " + string4));
                            }
                            bl = true;
                        } else if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Invalid push proxy: " + string4 + ", response: " + headMethod.getStatusCode()));
                        }
                    }
                    catch (IOException iOException) {
                        LOG.warn((Object)"PushProxy request exception", (Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    var16_18 = null;
                    if (headMethod == null) throw throwable;
                    headMethod.releaseConnection();
                    throw throwable;
                }
                {
                    var16_18 = null;
                    if (headMethod == null) continue;
                }
                headMethod.releaseConnection();
            }
        }
        PushRequest pushRequest = new PushRequest(GUID.makeGuid(), ConnectionSettings.TTL.getValue(), remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), byArray, n);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Sending push request through Gnutella: " + pushRequest));
        }
        try {
            this.router.sendPushRequest(pushRequest);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static GIVLine parseGIV(Socket socket) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        ByteReader byteReader = new ByteReader(inputStream);
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        String string2 = byteReader.readLine();
        if (string2 == null || !string2.equals("")) {
            throw new IOException();
        }
        try {
            int n = string.indexOf(":");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = string.indexOf("/", n);
            byte[] byArray = GUID.fromHexString(string.substring(n + 1, n3));
            String string3 = URLDecoder.decode(string.substring(n3 + 1));
            return new GIVLine(string3, n2, byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDownloads() {
        ArrayList arrayList = new ArrayList();
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            arrayList.addAll((Collection)this.active);
            arrayList.addAll((Collection)this.waiting);
        }
        return arrayList.iterator();
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String string, int n, byte[] byArray) {
            this.file = string;
            this.index = n;
            this.clientGUID = byArray;
        }
    }
}

