/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileDesc
implements AlternateLocationCollector {
    private final int _index;
    private final String _path;
    private final String _name;
    private final int _size;
    private long _modTime;
    private final Set URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private volatile List _limeXMLDocs = DataUtils.EMPTY_LIST;
    private AlternateLocationCollection ALT_LOCS;
    private int _hits;
    private int _attemptedUploads;
    private int _completedUploads;

    public FileDesc(File file, Set set, int n) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative values not permitted in FileDesc: " + n);
        }
        if (set == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = new File(file.getAbsolutePath());
        this._index = n;
        this._name = this.FILE.getName();
        this._path = this.FILE.getAbsolutePath();
        this._size = (int)this.FILE.length();
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet((Set)set);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this.ALT_LOCS = AlternateLocationCollection.create(this.SHA1_URN);
        try {
            this.addUrnsForSelf();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this._hits = 0;
    }

    public static Set calculateAndCacheURN(File file) throws IOException, InterruptedException {
        if (file == null) {
            throw new NullPointerException("cannot accept null file argument");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("file does not exist: " + file);
        }
        Set set = UrnCache.instance().getUrns(file);
        if (set.size() == 0) {
            set = FileDesc.calculateUrns(file);
            UrnCache.instance().addUrns(file, set);
        }
        return set;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    private URN extractSHA1() {
        Iterator iterator = this.URNS.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public File getFile() {
        return new File(this.FILE.getAbsolutePath());
    }

    public Set getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public void addLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        ArrayList arrayList = new ArrayList(this._limeXMLDocs.size() + 1);
        arrayList.addAll((Collection)this._limeXMLDocs);
        arrayList.add((Object)limeXMLDocument);
        this._limeXMLDocs = arrayList;
    }

    public boolean replaceLimeXMLDocument(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        int n = this._limeXMLDocs.indexOf((Object)limeXMLDocument);
        if (n == -1) {
            return false;
        }
        ArrayList arrayList = new ArrayList((Collection)this._limeXMLDocs);
        Object object = arrayList.remove(n);
        Assert.that(object == limeXMLDocument, "wrong doc removed!");
        arrayList.add((Object)limeXMLDocument2);
        this._limeXMLDocs = arrayList;
        return true;
    }

    public boolean removeLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        if (this._limeXMLDocs.size() == 0) {
            return false;
        }
        ArrayList arrayList = new ArrayList((Collection)this._limeXMLDocs);
        boolean bl = arrayList.remove((Object)limeXMLDocument);
        this._limeXMLDocs = arrayList;
        return bl;
    }

    public List getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    public AlternateLocationCollection getAlternateLocationCollection() {
        return this.ALT_LOCS;
    }

    public void addUrnsForSelf() {
        this.ALT_LOCS.add(AlternateLocation.create(this.SHA1_URN));
    }

    public boolean add(AlternateLocation alternateLocation) {
        if (alternateLocation == null) {
            throw new NullPointerException("cannot accept null alt locs");
        }
        URN uRN = alternateLocation.getSHA1Urn();
        if (uRN == null) {
            throw new IllegalArgumentException("sha1 cannot be null");
        }
        if (!uRN.equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("URN does not match:\n" + this.SHA1_URN + "\n" + uRN);
        }
        return this.ALT_LOCS.add(alternateLocation);
    }

    public boolean remove(AlternateLocation alternateLocation) {
        if (alternateLocation == null) {
            throw new NullPointerException("cannot accept null alt locs");
        }
        URN uRN = alternateLocation.getSHA1Urn();
        if (uRN == null) {
            throw new IllegalArgumentException("sha1 cannot be null");
        }
        if (!uRN.equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("URN does not match:\n" + this.SHA1_URN + "\n" + uRN);
        }
        return this.ALT_LOCS.remove(alternateLocation);
    }

    public int addAll(AlternateLocationCollection alternateLocationCollection) {
        if (alternateLocationCollection == null) {
            throw new NullPointerException("cannot accept null alt loc coll");
        }
        if (!alternateLocationCollection.getSHA1Urn().equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("SHA1 does not match:\n" + this.SHA1_URN + "\n" + alternateLocationCollection.getSHA1Urn());
        }
        return this.ALT_LOCS.addAll(alternateLocationCollection);
    }

    public boolean hasAlternateLocations() {
        return this.ALT_LOCS.hasAlternateLocations();
    }

    public int getAltLocsSize() {
        return this.ALT_LOCS.getAltLocsSize();
    }

    private static Set calculateUrns(File file) throws IOException, InterruptedException {
        HashSet hashSet = new HashSet(1);
        hashSet.add((Object)URN.createSHA1Urn(file));
        return hashSet;
    }

    public boolean containsUrn(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null URNS not allowed in containsUrn");
        }
        Iterator iterator = this.URNS.iterator();
        while (iterator.hasNext()) {
            if (!uRN.equals((URN)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public HashTree getHashTree() {
        return TigerTreeCache.instance().getHashTree(this);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public int incrementAttemptedUploads() {
        return ++this._attemptedUploads;
    }

    public int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new FileInputStream(this.FILE);
    }

    private String listInformation(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.listInformation(this.URNS.iterator()) + "\r\n" + "docs:     " + (this._limeXMLDocs == null ? "null" : this.listInformation(this._limeXMLDocs.iterator())) + "\r\n" + "alt locs: " + this.ALT_LOCS + "\r\n";
    }
}

