/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;

public final class RouteTable {
    private Map _newMap = new TreeMap((Comparator)new GUID.GUIDByteComparator());
    private Map _oldMap = new TreeMap((Comparator)new GUID.GUIDByteComparator());
    private int _mseconds;
    private long _nextSwitchTime;
    private int _maxSize;
    private Map _idMap = new HashMap();
    private Map _handlerMap = new HashMap();
    private int _nextID;
    private static boolean warned = false;

    public RouteTable(int n, int n2) {
        this._mseconds = n * 1000;
        this._nextSwitchTime = System.currentTimeMillis() + (long)this._mseconds;
        this._maxSize = n2;
    }

    public synchronized ResultCounter routeReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (!replyHandler.isOpen()) {
            return null;
        }
        int n = this.handler2id(replyHandler);
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.remove((Object)byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.remove((Object)byArray);
        }
        if (routeTableEntry == null) {
            routeTableEntry = new RouteTableEntry(n);
        } else {
            routeTableEntry.handlerID = n;
        }
        this._newMap.put((Object)byArray, (Object)routeTableEntry);
        return routeTableEntry;
    }

    public synchronized ResultCounter tryToRouteReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        Assert.that(replyHandler != null);
        Assert.that(byArray != null, "Null GUID in tryToRouteReply");
        if (!replyHandler.isOpen()) {
            return null;
        }
        if (!this._newMap.containsKey((Object)byArray) && !this._oldMap.containsKey((Object)byArray)) {
            int n = this.handler2id(replyHandler);
            RouteTableEntry routeTableEntry = new RouteTableEntry(n);
            this._newMap.put((Object)byArray, (Object)routeTableEntry);
            return routeTableEntry;
        }
        return null;
    }

    public synchronized void setTTL(ResultCounter resultCounter, byte by) {
        if (resultCounter == null) {
            throw new IllegalArgumentException("Null entry!!");
        }
        if (!(resultCounter instanceof RouteTableEntry)) {
            throw new IllegalArgumentException("entry is not recognized.");
        }
        if (by <= 0) {
            throw new IllegalArgumentException("Input TTL too small: " + by);
        }
        ((RouteTableEntry)resultCounter).setTTL(by);
    }

    public synchronized boolean getAndSetTTL(byte[] byArray, byte by, byte by2) {
        if (by < 1 || by2 <= by) {
            throw new IllegalArgumentException("Bad ttl input (get/set): " + by + "/" + by2);
        }
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.get((Object)byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.get((Object)byArray);
        }
        if (routeTableEntry != null && routeTableEntry.getTTL() == by) {
            routeTableEntry.setTTL(by2);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] byArray) {
        this.repOk();
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.get((Object)byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.get((Object)byArray);
        }
        return routeTableEntry == null ? null : this.id2handler(new Integer(routeTableEntry.handlerID));
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] byArray, int n, short s) {
        this.repOk();
        RouteTableEntry routeTableEntry = (RouteTableEntry)this._newMap.get((Object)byArray);
        if (routeTableEntry == null) {
            routeTableEntry = (RouteTableEntry)this._oldMap.get((Object)byArray);
        }
        if (routeTableEntry == null) {
            return null;
        }
        ReplyHandler replyHandler = this.id2handler(new Integer(routeTableEntry.handlerID));
        if (replyHandler == null) {
            return null;
        }
        ReplyRoutePair replyRoutePair = new ReplyRoutePair(replyHandler, routeTableEntry.bytesRouted, routeTableEntry.repliesRouted);
        RouteTableEntry routeTableEntry2 = routeTableEntry;
        routeTableEntry2.bytesRouted = routeTableEntry2.bytesRouted + n;
        RouteTableEntry routeTableEntry3 = routeTableEntry;
        routeTableEntry3.repliesRouted = routeTableEntry3.repliesRouted + s;
        return replyRoutePair;
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        this.repOk();
        Assert.that(replyHandler != null, "Null replyHandler in removeReplyHandler");
        Integer n = this.handler2id(replyHandler);
        this._idMap.remove((Object)n);
        this._handlerMap.remove((Object)replyHandler);
    }

    private Integer handler2id(ReplyHandler replyHandler) {
        Integer n = (Integer)this._handlerMap.get((Object)replyHandler);
        if (n != null) {
            return n;
        }
        while (this._idMap.get((Object)(n = new Integer(this._nextID++))) != null) {
        }
        this._handlerMap.put((Object)replyHandler, (Object)n);
        this._idMap.put((Object)n, (Object)replyHandler);
        return n;
    }

    private ReplyHandler id2handler(Integer n) {
        return (ReplyHandler)this._idMap.get((Object)n);
    }

    private final boolean purge() {
        long l = System.currentTimeMillis();
        if (l < this._nextSwitchTime && this._newMap.size() < this._maxSize) {
            return false;
        }
        this._oldMap.clear();
        Map map = this._oldMap;
        this._oldMap = this._newMap;
        this._newMap = map;
        this._nextSwitchTime = l + (long)this._mseconds;
        return true;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        TreeMap treeMap = new TreeMap((Comparator)new GUID.GUIDByteComparator());
        treeMap.putAll(this._oldMap);
        treeMap.putAll(this._newMap);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            stringBuffer.append(new GUID(byArray));
            stringBuffer.append("->");
            int n = ((RouteTableEntry)treeMap.get((Object)byArray)).handlerID;
            ReplyHandler replyHandler = this.id2handler(new Integer(n));
            stringBuffer.append(replyHandler == null ? "null" : replyHandler.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private final void repOk() {
    }

    private static final class RouteTableEntry
    implements ResultCounter {
        private int handlerID;
        private int bytesRouted;
        private int repliesRouted;
        private byte ttl = 0;

        RouteTableEntry(int n) {
            this.handlerID = n;
            this.bytesRouted = 0;
            this.repliesRouted = 0;
        }

        public void setTTL(byte by) {
            this.ttl = by;
        }

        public byte getTTL() {
            return this.ttl;
        }

        public int getNumResults() {
            return this.repliesRouted;
        }
    }

    public static final class ReplyRoutePair {
        private final ReplyHandler handler;
        private final int volume;
        private final int REPLIES_ROUTED;

        ReplyRoutePair(ReplyHandler replyHandler, int n, int n2) {
            this.handler = replyHandler;
            this.volume = n;
            this.REPLIES_ROUTED = n2;
        }

        public ReplyHandler getReplyHandler() {
            return this.handler;
        }

        public int getBytesRouted() {
            return this.volume;
        }

        public int getResultsRouted() {
            return this.REPLIES_ROUTED;
        }
    }
}

